/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.GraphicsProperties;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class ExternalDocument
extends AbstractPageSequence
implements GraphicsProperties {
    private LengthRangeProperty blockProgressionDimension;
    private Length contentHeight;
    private Length contentWidth;
    private int displayAlign;
    private Length height;
    private LengthRangeProperty inlineProgressionDimension;
    private int overflow;
    private int scaling;
    private String src;
    private int textAlign;
    private Length width;

    public ExternalDocument(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.contentHeight = propertyList.get(78).getLength();
        this.contentWidth = propertyList.get(80).getLength();
        this.displayAlign = propertyList.get(87).getEnum();
        this.height = propertyList.get(115).getLength();
        this.inlineProgressionDimension = propertyList.get(127).getLengthRange();
        this.overflow = propertyList.get(169).getEnum();
        this.scaling = propertyList.get(215).getEnum();
        this.textAlign = propertyList.get(245).getEnum();
        this.width = propertyList.get(264).getLength();
        this.src = propertyList.get(232).getString();
        if (this.src == null || this.src.length() == 0) {
            this.missingPropertyError("src");
        }
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startExternalDocument(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endExternalDocument(this);
        super.endOfNode();
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        this.invalidChildError(locator, string, string2);
    }

    public String getSrc() {
        return this.src;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getContentHeight() {
        return this.contentHeight;
    }

    public Length getContentWidth() {
        return this.contentWidth;
    }

    public int getScaling() {
        return this.scaling;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public String getNamespaceURI() {
        return "http://xmlgraphics.apache.org/fop/extensions";
    }

    public String getNormalNamespacePrefix() {
        return "fox";
    }

    public String getLocalName() {
        return "external-document";
    }
}

