/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.Stack;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.PropertyMaker;

public class PropertyInfo {
    private PropertyMaker maker;
    private PropertyList plist;
    private FObj fo;
    private Stack stkFunction;

    public PropertyInfo(PropertyMaker propertyMaker, PropertyList propertyList) {
        this.maker = propertyMaker;
        this.plist = propertyList;
        this.fo = propertyList.getParentFObj();
    }

    public PercentBase getPercentBase() throws PropertyException {
        PercentBase percentBase = this.getFunctionPercentBase();
        return percentBase != null ? percentBase : this.maker.getPercentBase(this.plist);
    }

    public Length currentFontSize() throws PropertyException {
        return this.plist.get(103).getLength();
    }

    public FObj getFO() {
        return this.fo;
    }

    public PropertyList getPropertyList() {
        return this.plist;
    }

    public PropertyMaker getPropertyMaker() {
        return this.maker;
    }

    public void pushFunction(Function function) {
        if (this.stkFunction == null) {
            this.stkFunction = new Stack();
        }
        this.stkFunction.push(function);
    }

    public void popFunction() {
        if (this.stkFunction != null) {
            this.stkFunction.pop();
        }
    }

    protected FOUserAgent getUserAgent() {
        return this.plist.getFObj() != null ? this.plist.getFObj().getUserAgent() : null;
    }

    private PercentBase getFunctionPercentBase() {
        Function function;
        if (this.stkFunction != null && (function = (Function)this.stkFunction.peek()) != null) {
            return function.getPercentBase();
        }
        return null;
    }
}

