/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.CompareUtil;

public class NumericProperty
extends Property
implements Numeric,
Length {
    private double value;
    private int dim;

    protected NumericProperty(double d, int n) {
        this.value = d;
        this.dim = n;
    }

    public int getDimension() {
        return this.dim;
    }

    public double getNumericValue() {
        return this.value;
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) {
        return this.value;
    }

    public boolean isAbsolute() {
        return true;
    }

    public Numeric getNumeric() {
        return this;
    }

    public Number getNumber() {
        return new Double(this.value);
    }

    public int getValue() {
        return (int)this.value;
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        return (int)this.value;
    }

    public Length getLength() {
        if (this.dim == 1) {
            return this;
        }
        log.error((Object)("Can't create length with dimension " + this.dim));
        return null;
    }

    public Color getColor(FOUserAgent fOUserAgent) {
        return null;
    }

    public Object getObject() {
        return this;
    }

    public String toString() {
        if (this.dim == 1) {
            return (int)this.value + "mpt";
        }
        return this.value + "^" + this.dim;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.dim;
        n = 31 * n + CompareUtil.getHashCode(this.value);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NumericProperty)) {
            return false;
        }
        NumericProperty numericProperty = (NumericProperty)object;
        return this.dim == numericProperty.dim && CompareUtil.equal(this.value, numericProperty.value);
    }
}

