/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.util.ContentHandlerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class XMLObj
extends FONode
implements ContentHandlerFactory.ObjectBuiltListener {
    private Attributes attr = null;
    protected Element element;
    protected Document doc;
    protected String name;
    private static HashMap ns = new HashMap();

    public XMLObj(FONode fONode) {
        super(fONode);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        this.setLocator(locator);
        this.name = string;
        this.attr = attributes;
    }

    public Document getDOMDocument() {
        return this.doc;
    }

    public Point2D getDimension(Point2D point2D) {
        return null;
    }

    public Length getIntrinsicAlignmentAdjust() {
        return null;
    }

    public String getLocalName() {
        return this.name;
    }

    public void addElement(Document document, Element element) {
        this.doc = document;
        this.element = document.createElementNS(this.getNamespaceURI(), this.name);
        XMLObj.setAttributes(this.element, this.attr);
        this.attr = null;
        element.appendChild(this.element);
    }

    private static void setAttributes(Element element, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getValue(i);
            String string2 = attributes.getQName(i);
            int n = string2.indexOf(":");
            if (n == -1) {
                element.setAttribute(string2, string);
                continue;
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equals("xmlns")) {
                ns.put(string4, string);
                continue;
            }
            element.setAttributeNS((String)ns.get(string3), string4, string);
        }
    }

    public void buildTopLevel(Document document, Element element) {
        XMLObj.setAttributes(this.element, this.attr);
    }

    public Document createBasicDocument() {
        this.doc = null;
        this.element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element element = this.doc.createElementNS(this.getNamespaceURI(), this.name);
            this.doc.appendChild(element);
            this.element = this.doc.getDocumentElement();
            this.buildTopLevel(this.doc, this.element);
            if (!this.element.hasAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns")) {
                this.element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getNamespaceURI());
            }
        }
        catch (Exception exception) {
            log.error((Object)"Error while trying to instantiate a DOM Document", (Throwable)exception);
        }
        return this.doc;
    }

    protected void addChildNode(FONode fONode) {
        if (fONode instanceof XMLObj) {
            ((XMLObj)fONode).addElement(this.doc, this.element);
        } else {
            log.debug((Object)("Invalid element: " + fONode.getName() + " inside foreign xml markup"));
        }
    }

    protected void characters(char[] cArray, int n, int n2, PropertyList propertyList, Locator locator) throws FOPException {
        super.characters(cArray, n, n2, propertyList, locator);
        String string = new String(cArray, n, n2);
        Text text = this.doc.createTextNode(string);
        this.element.appendChild(text);
    }

    public void notifyObjectBuilt(Object object) {
        this.doc = (Document)object;
        this.element = this.doc.getDocumentElement();
    }

    static {
        ns.put("xlink", "http://www.w3.org/1999/xlink");
    }
}

