/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.events.model.EventSeverity;
import org.apache.xmlgraphics.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EventMethodModel
implements Serializable,
XMLizable {
    private static final long serialVersionUID = -7548882973341444354L;
    private String methodName;
    private EventSeverity severity;
    private List params = new ArrayList();
    private String exceptionClass;

    public EventMethodModel(String string, EventSeverity eventSeverity) {
        this.methodName = string;
        this.severity = eventSeverity;
    }

    public void addParameter(Parameter parameter) {
        this.params.add(parameter);
    }

    public Parameter addParameter(Class clazz, String string) {
        Parameter parameter = new Parameter(clazz, string);
        this.addParameter(parameter);
        return parameter;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setSeverity(EventSeverity eventSeverity) {
        this.severity = eventSeverity;
    }

    public EventSeverity getSeverity() {
        return this.severity;
    }

    public List getParameters() {
        return Collections.unmodifiableList(this.params);
    }

    public void setExceptionClass(String string) {
        this.exceptionClass = string;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "CDATA", this.getMethodName());
        attributesImpl.addAttribute("", "severity", "severity", "CDATA", this.getSeverity().getName());
        if (this.getExceptionClass() != null) {
            attributesImpl.addAttribute("", "exception", "exception", "CDATA", this.getExceptionClass());
        }
        String string = "method";
        contentHandler.startElement("", string, string, attributesImpl);
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            ((XMLizable)iterator.next()).toSAX(contentHandler);
        }
        contentHandler.endElement("", string, string);
    }

    public static class Parameter
    implements Serializable,
    XMLizable {
        private static final long serialVersionUID = 6062500277953887099L;
        private Class type;
        private String name;

        public Parameter(Class clazz, String string) {
            this.type = clazz;
            this.name = string;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public void toSAX(ContentHandler contentHandler) throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "type", "type", "CDATA", this.getType().getName());
            attributesImpl.addAttribute("", "name", "name", "CDATA", this.getName());
            String string = "parameter";
            contentHandler.startElement("", string, string, attributesImpl);
            contentHandler.endElement("", string, string);
        }
    }
}

