/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.io.UnsupportedEncodingException;

public final class URISpecification {
    private static final String PUNCT = ",;:$&+=";
    private static final String RESERVED = ",;:$&+=?/[]@";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URISpecification() {
    }

    public static String getURL(String string) {
        if ((string = string.trim()).startsWith("url(") && string.indexOf(")") != -1) {
            if ((string = string.substring(4, string.lastIndexOf(")")).trim()).startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    private static boolean isValidURIChar(char c) {
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'A' && c <= 'z';
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isReserved(char c) {
        if (RESERVED.indexOf(c) >= 0) {
            return true;
        }
        return '#' == c;
    }

    private static boolean isUnreserved(char c) {
        if (URISpecification.isDigit(c) || URISpecification.isAlpha(c)) {
            return true;
        }
        return "_-!.~'()*".indexOf(c) >= 0;
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%').append(HEX_DIGITS[by >> 4 & 0xF]).append(HEX_DIGITS[by >> 0 & 0xF]);
    }

    public static String escapeURI(String string) {
        string = URISpecification.getURL(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%' && i < n - 3 && URISpecification.isHexDigit(string.charAt(i + 1)) && URISpecification.isHexDigit(string.charAt(i + 2))) {
                stringBuffer.append(c);
                continue;
            }
            if (URISpecification.isReserved(c) || URISpecification.isUnreserved(c)) {
                stringBuffer.append(c);
                continue;
            }
            try {
                byte[] byArray = Character.toString(c).getBytes("UTF-8");
                int n2 = byArray.length;
                for (int j = 0; j < n2; ++j) {
                    URISpecification.appendEscape(stringBuffer, byArray[j]);
                }
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error("Incompatible JVM. UTF-8 not supported.");
            }
        }
        return stringBuffer.toString();
    }
}

