/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.scripts.IndicScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevanagariScriptProcessor
extends IndicScriptProcessor {
    private static final Log log = LogFactory.getLog(DevanagariScriptProcessor.class);
    static final short C_U = 0;
    static final short C_C = 1;
    static final short C_V = 2;
    static final short C_M = 3;
    static final short C_S = 4;
    static final short C_T = 5;
    static final short C_A = 6;
    static final short C_P = 7;
    static final short C_D = 8;
    static final short C_H = 9;
    static final short C_O = 10;
    static final short C_N = 256;
    static final short C_R = 512;
    static final short C_PRE = 1024;
    static final short C_M_TYPE = 255;
    static final short C_M_FLAGS = 32512;
    static final int ccaStart = 2304;
    static final int ccaEnd = 2432;
    static final short[] cca = new short[]{10, 10, 10, 10, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 769, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 256, 4, 3, 1027, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 3, 3, 4, 5, 5, 6, 6, 3, 3, 3, 257, 257, 257, 257, 257, 257, 257, 257, 2, 2, 3, 3, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1};

    DevanagariScriptProcessor(String string) {
        super(string);
    }

    protected Class<? extends DevanagariSyllabizer> getSyllabizerClass() {
        return DevanagariSyllabizer.class;
    }

    @Override
    protected int findPreBaseMatra(GlyphSequence glyphSequence) {
        int n = glyphSequence.getGlyphCount();
        int n2 = -1;
        for (int i = n; i > 0; --i) {
            int n3 = i - 1;
            if (!DevanagariScriptProcessor.containsPreBaseMatra(glyphSequence, n3)) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    @Override
    protected int findPreBaseMatraTarget(GlyphSequence glyphSequence, int n) {
        int n2;
        int n3 = glyphSequence.getGlyphCount();
        int n4 = -1;
        int n5 = n2 = n < n3 ? n : n3;
        while (n2 > 0) {
            int n6 = n2 - 1;
            if (DevanagariScriptProcessor.containsConsonant(glyphSequence, n6)) {
                if (DevanagariScriptProcessor.containsHalfConsonant(glyphSequence, n6)) {
                    n4 = n6;
                } else {
                    if (n4 != -1) break;
                    n4 = n6;
                }
            }
            --n2;
        }
        return n4;
    }

    private static boolean containsPreBaseMatra(GlyphSequence glyphSequence, int n) {
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n2 = charAssociation.getEnd();
        for (int i = charAssociation.getStart(); i < n2; ++i) {
            if (!DevanagariScriptProcessor.isPreM(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConsonant(GlyphSequence glyphSequence, int n) {
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n2 = charAssociation.getEnd();
        for (int i = charAssociation.getStart(); i < n2; ++i) {
            if (!DevanagariScriptProcessor.isC(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsHalfConsonant(GlyphSequence glyphSequence, int n) {
        Boolean bl = (Boolean)glyphSequence.getAssociation(n).getPredication("half");
        return bl != null ? bl : false;
    }

    @Override
    protected int findReph(GlyphSequence glyphSequence) {
        int n = glyphSequence.getGlyphCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!DevanagariScriptProcessor.containsReph(glyphSequence, i)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    @Override
    protected int findRephTarget(GlyphSequence glyphSequence, int n) {
        int n2;
        int n3 = glyphSequence.getGlyphCount();
        int n4 = -1;
        int n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 == n || !DevanagariScriptProcessor.containsConsonant(glyphSequence, n2) || DevanagariScriptProcessor.containsHalfConsonant(glyphSequence, n2)) continue;
            n4 = n2 + 1;
            break;
        }
        int n6 = n2 = n4 >= 0 ? n4 : 0;
        while (n2 < n3) {
            if (DevanagariScriptProcessor.containsMatra(glyphSequence, n2) && !DevanagariScriptProcessor.containsPreBaseMatra(glyphSequence, n2)) {
                n5 = n2 + 1;
            } else if (DevanagariScriptProcessor.containsOtherMark(glyphSequence, n2)) {
                n5 = n2;
                break;
            }
            ++n2;
        }
        if (n5 >= 0) {
            return n5;
        }
        if (n4 >= 0) {
            return n4;
        }
        return n;
    }

    private static boolean containsReph(GlyphSequence glyphSequence, int n) {
        Boolean bl = (Boolean)glyphSequence.getAssociation(n).getPredication("rphf");
        return bl != null ? bl : false;
    }

    private static boolean containsMatra(GlyphSequence glyphSequence, int n) {
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n2 = charAssociation.getEnd();
        for (int i = charAssociation.getStart(); i < n2; ++i) {
            if (!DevanagariScriptProcessor.isM(nArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsOtherMark(GlyphSequence glyphSequence, int n) {
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n2 = charAssociation.getEnd();
        for (int i = charAssociation.getStart(); i < n2; ++i) {
            switch (DevanagariScriptProcessor.typeOf(nArray[i])) {
                case 5: 
                case 6: 
                case 10: {
                    return true;
                }
            }
        }
        return false;
    }

    static int typeOf(int n) {
        if (n >= 2304 && n < 2432) {
            return cca[n - 2304] & 0xFF;
        }
        return 0;
    }

    static boolean isType(int n, int n2) {
        return DevanagariScriptProcessor.typeOf(n) == n2;
    }

    static boolean hasFlag(int n, int n2) {
        if (n >= 2304 && n < 2432) {
            return (cca[n - 2304] & n2) == n2;
        }
        return false;
    }

    static boolean isC(int n) {
        return DevanagariScriptProcessor.isType(n, 1);
    }

    static boolean isR(int n) {
        return DevanagariScriptProcessor.isType(n, 1) && DevanagariScriptProcessor.hasR(n);
    }

    static boolean isV(int n) {
        return DevanagariScriptProcessor.isType(n, 2);
    }

    static boolean isN(int n) {
        return n == 2364;
    }

    static boolean isH(int n) {
        return n == 2381;
    }

    static boolean isM(int n) {
        return DevanagariScriptProcessor.isType(n, 3);
    }

    static boolean isPreM(int n) {
        return DevanagariScriptProcessor.isType(n, 3) && DevanagariScriptProcessor.hasFlag(n, 1024);
    }

    static boolean isX(int n) {
        switch (DevanagariScriptProcessor.typeOf(n)) {
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    static boolean hasR(int n) {
        return DevanagariScriptProcessor.hasFlag(n, 512);
    }

    static boolean hasN(int n) {
        return DevanagariScriptProcessor.hasFlag(n, 256);
    }

    private static class DevanagariSyllabizer
    extends IndicScriptProcessor.DefaultSyllabizer {
        DevanagariSyllabizer(String string, String string2) {
            super(string, string2);
        }

        protected int findStartOfSyllable(int[] nArray, int n, int n2) {
            int n3;
            if (n < 0 || n >= n2) {
                return -1;
            }
            while (n < n2 && !DevanagariScriptProcessor.isC(n3 = nArray[n])) {
                ++n;
            }
            return n;
        }

        protected int findEndOfSyllable(int[] nArray, int n, int n2) {
            int n3;
            if (n < 0 || n >= n2) {
                return -1;
            }
            int n4 = 0;
            int n5 = 0;
            while ((n3 = this.isDeadConsonant(nArray, n, n2)) > n) {
                n = n3;
                ++n4;
            }
            n3 = this.isLiveConsonant(nArray, n, n2);
            if (n3 > n) {
                n = n3;
                ++n5;
            }
            return n4 > 0 || n5 > 0 ? n : -1;
        }

        private int isDeadConsonant(int[] nArray, int n, int n2) {
            int n3;
            int n4;
            int n5;
            block7: {
                int n6;
                block6: {
                    if (n < 0) {
                        return -1;
                    }
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    if (n + n5 >= n2) break block6;
                    n6 = nArray[n + n5];
                    if (!DevanagariScriptProcessor.isC(n6)) break block7;
                    ++n5;
                    ++n4;
                }
                if (n + n5 < n2 && DevanagariScriptProcessor.isN(n6 = nArray[n + 1])) {
                    ++n5;
                }
                if (n + n5 < n2 && DevanagariScriptProcessor.isH(n6 = nArray[n + n5])) {
                    ++n5;
                    ++n3;
                }
            }
            return n4 > 0 && n3 > 0 ? n + n5 : -1;
        }

        private int isLiveConsonant(int[] nArray, int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block12: {
                block10: {
                    block11: {
                        if (n < 0) {
                            return -1;
                        }
                        n7 = 0;
                        n6 = 0;
                        n5 = 0;
                        n4 = 0;
                        if (n + n7 >= n2) break block10;
                        n3 = nArray[n + n7];
                        if (!DevanagariScriptProcessor.isC(n3)) break block11;
                        ++n7;
                        ++n6;
                        break block10;
                    }
                    if (!DevanagariScriptProcessor.isV(n3)) break block12;
                    ++n7;
                    ++n5;
                }
                if (n + n7 < n2 && DevanagariScriptProcessor.isN(n3 = nArray[n + n7])) {
                    ++n7;
                }
                while (n + n7 < n2 && DevanagariScriptProcessor.isX(n3 = nArray[n + n7])) {
                    ++n7;
                    ++n4;
                }
            }
            if (n4 == 0 && n + n7 < n2 && DevanagariScriptProcessor.isH(n3 = nArray[n + n7])) {
                if (n6 > 0) {
                    --n6;
                } else if (n5 > 0) {
                    --n5;
                }
            }
            return n6 > 0 || n5 > 0 ? n + n7 : -1;
        }
    }
}

