/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassTable;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFTableName;

public final class OTFAdvancedTypographicTableReader {
    private static Log log = LogFactory.getLog(OTFAdvancedTypographicTableReader.class);
    private TTFFile ttf;
    private FontFileReader in;
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private transient Map seScripts;
    private transient Map seLanguages;
    private transient Map seFeatures;
    private transient GlyphMappingTable seMapping;
    private transient List seEntries;
    private transient List seSubtables;
    private static String defaultTag = "dflt";

    public OTFAdvancedTypographicTableReader(TTFFile tTFFile, FontFileReader fontFileReader) {
        assert (tTFFile != null);
        assert (fontFileReader != null);
        this.ttf = tTFFile;
        this.in = fontFileReader;
    }

    public void readAll() throws AdvancedTypographicTableFormatException {
        try {
            this.readGDEF();
            this.readGSUB();
            this.readGPOS();
        }
        catch (AdvancedTypographicTableFormatException advancedTypographicTableFormatException) {
            this.resetATStateAll();
            throw advancedTypographicTableFormatException;
        }
        catch (IOException iOException) {
            this.resetATStateAll();
            throw new AdvancedTypographicTableFormatException(iOException.getMessage(), iOException);
        }
        finally {
            this.resetATState();
        }
    }

    public boolean hasAdvancedTable() {
        return this.gdef != null || this.gsub != null || this.gpos != null;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    private void readLangSysTable(TTFTableName tTFTableName, long l, String string) throws IOException {
        this.in.seekSet(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " lang sys table: " + string));
        }
        int n = this.in.readTTFUShort();
        int n2 = this.in.readTTFUShort();
        String string2 = n2 != 65535 ? "f" + n2 : null;
        int n3 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " lang sys table reorder table: " + n));
            log.debug((Object)(tTFTableName + " lang sys table required feature index: " + n2));
            log.debug((Object)(tTFTableName + " lang sys table non-required feature count: " + n3));
        }
        int[] nArray = new int[n3];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " lang sys table non-required feature index: " + n4));
            }
            nArray[i] = n4;
            arrayList.add("f" + n4);
        }
        if (this.seLanguages == null) {
            this.seLanguages = new LinkedHashMap();
        }
        this.seLanguages.put(string, new Object[]{string2, arrayList});
    }

    private void readScriptTable(TTFTableName tTFTableName, long l, String string) throws IOException {
        this.in.seekSet(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " script table: " + string));
        }
        int n = this.in.readTTFUShort();
        String string2 = defaultTag;
        if (n > 0 && log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " default lang sys tag: " + string2));
            log.debug((Object)(tTFTableName + " default lang sys table offset: " + n));
        }
        int n2 = this.in.readTTFUShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 > 0) {
            int n3;
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            int n4 = n2;
            for (n3 = 0; n3 < n4; ++n3) {
                String string3 = this.in.readTTFString(4);
                int n5 = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " lang sys tag: " + string3));
                    log.debug((Object)(tTFTableName + " lang sys table offset: " + n5));
                }
                stringArray[n3] = string3;
                nArray[n3] = n5;
                if (n == n5) {
                    n = 0;
                    string2 = string3;
                }
                arrayList.add(string3);
            }
            n4 = n2;
            for (n3 = 0; n3 < n4; ++n3) {
                this.readLangSysTable(tTFTableName, l + (long)nArray[n3], stringArray[n3]);
            }
        }
        if (n > 0) {
            this.readLangSysTable(tTFTableName, l + (long)n, string2);
        } else if (string2 != null && log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " lang sys default: " + string2));
        }
        this.seScripts.put(string, new Object[]{string2, arrayList, this.seLanguages});
        this.seLanguages = null;
    }

    private void readScriptList(TTFTableName tTFTableName, long l) throws IOException {
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " script list record count: " + n));
        }
        if (n > 0) {
            int n2;
            String[] stringArray = new String[n];
            int[] nArray = new int[n];
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                String string = this.in.readTTFString(4);
                int n4 = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " script tag: " + string));
                    log.debug((Object)(tTFTableName + " script table offset: " + n4));
                }
                stringArray[n2] = string;
                nArray[n2] = n4;
            }
            n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                this.seLanguages = null;
                this.readScriptTable(tTFTableName, l + (long)nArray[n2], stringArray[n2]);
            }
        }
    }

    private void readFeatureTable(TTFTableName tTFTableName, long l, String string, int n) throws IOException {
        this.in.seekSet(l);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " feature table: " + string));
        }
        int n2 = this.in.readTTFUShort();
        int n3 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " feature table parameters offset: " + n2));
            log.debug((Object)(tTFTableName + " feature table lookup list index count: " + n3));
        }
        int[] nArray = new int[n3];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " feature table lookup index: " + n4));
            }
            nArray[i] = n4;
            arrayList.add("lu" + n4);
        }
        this.seFeatures.put("f" + n, new Object[]{string, arrayList});
    }

    private void readFeatureList(TTFTableName tTFTableName, long l) throws IOException {
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " feature list record count: " + n));
        }
        if (n > 0) {
            int n2;
            String[] stringArray = new String[n];
            int[] nArray = new int[n];
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                String string = this.in.readTTFString(4);
                int n4 = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " feature tag: " + string));
                    log.debug((Object)(tTFTableName + " feature table offset: " + n4));
                }
                stringArray[n2] = string;
                nArray[n2] = n4;
            }
            n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " feature index: " + n2));
                }
                this.readFeatureTable(tTFTableName, l + (long)nArray[n2], stringArray[n2], n2);
            }
        }
    }

    private GlyphCoverageTable readCoverageTableFormat1(String string, long l, int n) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.in.seekSet(l);
        this.in.skip(2L);
        int n2 = this.in.readTTFUShort();
        int[] nArray = new int[n2];
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            int n4;
            nArray[i] = n4 = this.in.readTTFUShort();
            arrayList.add(n4);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " glyphs: " + this.toString(nArray)));
        }
        return GlyphCoverageTable.createCoverageTable(arrayList);
    }

    private GlyphCoverageTable readCoverageTableFormat2(String string, long l, int n) throws IOException {
        ArrayList<GlyphMappingTable.MappingRange> arrayList = new ArrayList<GlyphMappingTable.MappingRange>();
        this.in.seekSet(l);
        this.in.skip(2L);
        int n2 = this.in.readTTFUShort();
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.in.readTTFUShort();
            int n5 = this.in.readTTFUShort();
            int n6 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " range[" + i + "]: [" + n4 + "," + n5 + "]: " + n6));
            }
            arrayList.add(new GlyphMappingTable.MappingRange(n4, n5, n6));
        }
        return GlyphCoverageTable.createCoverageTable(arrayList);
    }

    private GlyphCoverageTable readCoverageTable(String string, long l) throws IOException {
        GlyphCoverageTable glyphCoverageTable;
        long l2 = this.in.getCurrentPos();
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (n == 1) {
            glyphCoverageTable = this.readCoverageTableFormat1(string, l, n);
        } else if (n == 2) {
            glyphCoverageTable = this.readCoverageTableFormat2(string, l, n);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported coverage table format: " + n);
        }
        this.in.seekSet(l2);
        return glyphCoverageTable;
    }

    private GlyphClassTable readClassDefTableFormat1(String string, long l, int n) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.in.seekSet(l);
        this.in.skip(2L);
        int n2 = this.in.readTTFUShort();
        arrayList.add(n2);
        int n3 = this.in.readTTFUShort();
        int[] nArray = new int[n3];
        int n4 = n3;
        for (int i = 0; i < n4; ++i) {
            int n5;
            nArray[i] = n5 = this.in.readTTFUShort();
            arrayList.add(n5);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " glyph classes: " + this.toString(nArray)));
        }
        return GlyphClassTable.createClassTable(arrayList);
    }

    private GlyphClassTable readClassDefTableFormat2(String string, long l, int n) throws IOException {
        ArrayList<GlyphMappingTable.MappingRange> arrayList = new ArrayList<GlyphMappingTable.MappingRange>();
        this.in.seekSet(l);
        this.in.skip(2L);
        int n2 = this.in.readTTFUShort();
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.in.readTTFUShort();
            int n5 = this.in.readTTFUShort();
            int n6 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " range[" + i + "]: [" + n4 + "," + n5 + "]: " + n6));
            }
            arrayList.add(new GlyphMappingTable.MappingRange(n4, n5, n6));
        }
        return GlyphClassTable.createClassTable(arrayList);
    }

    private GlyphClassTable readClassDefTable(String string, long l) throws IOException {
        GlyphClassTable glyphClassTable;
        long l2 = this.in.getCurrentPos();
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (n == 1) {
            glyphClassTable = this.readClassDefTableFormat1(string, l, n);
        } else if (n == 2) {
            glyphClassTable = this.readClassDefTableFormat2(string, l, n);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported class definition table format: " + n);
        }
        this.in.seekSet(l2);
        return glyphClassTable;
    }

    private void readSingleSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        short s = this.in.readTTFShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " single substitution subtable format: " + n3 + " (delta)"));
            log.debug((Object)(string + " single substitution coverage table offset: " + n4));
            log.debug((Object)(string + " single substitution delta: " + s));
        }
        this.seMapping = this.readCoverageTable(string + " single substitution coverage", l + (long)n4);
        this.seEntries.add(Integer.valueOf(s));
    }

    private void readSingleSubTableFormat2(int n, int n2, long l, int n3) throws IOException {
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " single substitution subtable format: " + n3 + " (mapped)"));
            log.debug((Object)(string + " single substitution coverage table offset: " + n4));
            log.debug((Object)(string + " single substitution glyph count: " + n5));
        }
        this.seMapping = this.readCoverageTable(string + " single substitution coverage", l + (long)n4);
        int[] nArray = new int[n5];
        int n6 = n5;
        for (int i = 0; i < n6; ++i) {
            int n7 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " single substitution glyph[" + i + "]: " + n7));
            }
            nArray[i] = n7;
            this.seEntries.add(n7);
        }
    }

    private int readSingleSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readSingleSubTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readSingleSubTableFormat2(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported single substitution subtable format: " + n3);
        }
        return n3;
    }

    private void readMultipleSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " multiple substitution subtable format: " + n3 + " (mapped)"));
            log.debug((Object)(string + " multiple substitution coverage table offset: " + n4));
            log.debug((Object)(string + " multiple substitution sequence count: " + n5));
        }
        this.seMapping = this.readCoverageTable(string + " multiple substitution coverage", l + (long)n4);
        int[] nArray = new int[n5];
        int n6 = n5;
        for (int i = 0; i < n6; ++i) {
            nArray[i] = this.in.readTTFUShort();
        }
        int[][] nArrayArray = new int[n5][];
        int n7 = n5;
        for (n6 = 0; n6 < n7; ++n6) {
            int[] nArray2;
            int n8 = nArray[n6];
            if (n8 > 0) {
                this.in.seekSet(l + (long)n8);
                int n9 = this.in.readTTFUShort();
                nArray2 = new int[n9];
                for (int i = 0; i < n9; ++i) {
                    nArray2[i] = this.in.readTTFUShort();
                }
            } else {
                nArray2 = null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " multiple substitution sequence[" + n6 + "]: " + this.toString(nArray2)));
            }
            nArrayArray[n6] = nArray2;
        }
        this.seEntries.add(nArrayArray);
    }

    private int readMultipleSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported multiple substitution subtable format: " + n3);
        }
        this.readMultipleSubTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readAlternateSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " alternate substitution subtable format: " + n3 + " (mapped)"));
            log.debug((Object)(string + " alternate substitution coverage table offset: " + n5));
            log.debug((Object)(string + " alternate substitution alternate set count: " + n6));
        }
        this.seMapping = this.readCoverageTable(string + " alternate substitution coverage", l + (long)n5);
        int[] nArray = new int[n6];
        int n7 = n6;
        for (n4 = 0; n4 < n7; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        n7 = n6;
        for (n4 = 0; n4 < n7; ++n4) {
            int n8 = nArray[n4];
            this.in.seekSet(l + (long)n8);
            int n9 = this.in.readTTFUShort();
            int[] nArray2 = new int[n9];
            for (int i = 0; i < n9; ++i) {
                int n10;
                nArray2[i] = n10 = this.in.readTTFUShort();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " alternate substitution alternate set[" + n4 + "]: " + this.toString(nArray2)));
            }
            this.seEntries.add(nArray2);
        }
    }

    private int readAlternateSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported alternate substitution subtable format: " + n3);
        }
        this.readAlternateSubTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readLigatureSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " ligature substitution subtable format: " + n3 + " (mapped)"));
            log.debug((Object)(string + " ligature substitution coverage table offset: " + n5));
            log.debug((Object)(string + " ligature substitution ligature set count: " + n6));
        }
        this.seMapping = this.readCoverageTable(string + " ligature substitution coverage", l + (long)n5);
        int[] nArray = new int[n6];
        int n7 = n6;
        for (n4 = 0; n4 < n7; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        n7 = n6;
        for (n4 = 0; n4 < n7; ++n4) {
            int n8 = nArray[n4];
            this.in.seekSet(l + (long)n8);
            int n9 = this.in.readTTFUShort();
            int[] nArray2 = new int[n9];
            for (int i = 0; i < n9; ++i) {
                nArray2[i] = this.in.readTTFUShort();
            }
            ArrayList<GlyphSubstitutionTable.Ligature> arrayList = new ArrayList<GlyphSubstitutionTable.Ligature>();
            for (int i = 0; i < n9; ++i) {
                int n10 = nArray2[i];
                this.in.seekSet(l + (long)n8 + (long)n10);
                int n11 = this.in.readTTFUShort();
                int n12 = this.in.readTTFUShort();
                int[] nArray3 = new int[n12 - 1];
                for (int j = 0; j < n12 - 1; ++j) {
                    nArray3[j] = this.in.readTTFUShort();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(string + " ligature substitution ligature set[" + n4 + "]: ligature(" + n11 + "), components: " + this.toString(nArray3)));
                }
                arrayList.add(new GlyphSubstitutionTable.Ligature(n11, nArray3));
            }
            this.seEntries.add(new GlyphSubstitutionTable.LigatureSet(arrayList));
        }
    }

    private int readLigatureSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported ligature substitution subtable format: " + n3);
        }
        this.readLigatureSubTableFormat1(n, n2, l, n3);
        return n3;
    }

    private GlyphTable.RuleLookup[] readRuleLookups(int n, String string) throws IOException {
        GlyphTable.RuleLookup[] ruleLookupArray = new GlyphTable.RuleLookup[n];
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.in.readTTFUShort();
            int n4 = this.in.readTTFUShort();
            ruleLookupArray[i] = new GlyphTable.RuleLookup(n3, n4);
            if (!log.isDebugEnabled() || string == null) continue;
            log.debug((Object)(string + "lookup[" + i + "]: " + ruleLookupArray[i]));
        }
        return ruleLookupArray;
    }

    private void readContextualSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual substitution format: " + n3 + " (glyphs)"));
            log.debug((Object)(string + " contextual substitution coverage table offset: " + n5));
            log.debug((Object)(string + " contextual substitution rule set count: " + n6));
            for (n4 = 0; n4 < n6; ++n4) {
                log.debug((Object)(string + " contextual substitution rule set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " contextual substitution coverage", l + (long)n5) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n6];
        String string2 = null;
        for (int i = 0; i < n6; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n7 = nArray[i];
            if (n7 > 0) {
                int n8;
                this.in.seekSet(l + (long)n7);
                int n9 = this.in.readTTFUShort();
                int[] nArray2 = new int[n9];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    nArray2[n8] = this.in.readTTFUShort();
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    GlyphTable.GlyphSequenceRule glyphSequenceRule;
                    int n10 = nArray2[n8];
                    if (n10 > 0) {
                        this.in.seekSet(l + (long)n7 + (long)n10);
                        int n11 = this.in.readTTFUShort();
                        int n12 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n11 - 1];
                        int n13 = nArray3.length;
                        for (int j = 0; j < n13; ++j) {
                            nArray3[j] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual substitution lookups @rule[" + i + "][" + n8 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n12, string2);
                        glyphSequenceRule = new GlyphTable.GlyphSequenceRule(ruleLookupArray, n11, nArray3);
                    } else {
                        glyphSequenceRule = null;
                    }
                    ruleArray[n8] = glyphSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(ruleSetArray);
    }

    private void readContextualSubTableFormat2(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int[] nArray = new int[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual substitution format: " + n3 + " (glyph classes)"));
            log.debug((Object)(string + " contextual substitution coverage table offset: " + n5));
            log.debug((Object)(string + " contextual substitution class set count: " + n7));
            for (n4 = 0; n4 < n7; ++n4) {
                log.debug((Object)(string + " contextual substitution class set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " contextual substitution coverage", l + (long)n5) : null;
        GlyphClassTable glyphClassTable = n6 > 0 ? this.readClassDefTable(string + " contextual substitution class definition", l + (long)n6) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n7];
        String string2 = null;
        for (int i = 0; i < n7; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n8 = nArray[i];
            if (n8 > 0) {
                int n9;
                this.in.seekSet(l + (long)n8);
                int n10 = this.in.readTTFUShort();
                int[] nArray2 = new int[n10];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n10];
                for (n9 = 0; n9 < n10; ++n9) {
                    nArray2[n9] = this.in.readTTFUShort();
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    GlyphTable.ClassSequenceRule classSequenceRule;
                    int n11 = nArray2[n9];
                    if (n11 > 0) {
                        this.in.seekSet(l + (long)n8 + (long)n11);
                        int n12 = this.in.readTTFUShort();
                        int n13 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n12 - 1];
                        int n14 = nArray3.length;
                        for (int j = 0; j < n14; ++j) {
                            nArray3[j] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual substitution lookups @rule[" + i + "][" + n9 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n13, string2);
                        classSequenceRule = new GlyphTable.ClassSequenceRule(ruleLookupArray, n12, nArray3);
                    } else {
                        assert (n11 > 0) : "unexpected null subclass rule offset";
                        classSequenceRule = null;
                    }
                    ruleArray[n9] = classSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphClassTable);
        this.seEntries.add(n7);
        this.seEntries.add(ruleSetArray);
    }

    private void readContextualSubTableFormat3(int n, int n2, long l, int n3) throws IOException {
        Object object;
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual substitution format: " + n3 + " (glyph sets)"));
            log.debug((Object)(string + " contextual substitution glyph input sequence length count: " + n5));
            log.debug((Object)(string + " contextual substitution lookup count: " + n6));
            for (n4 = 0; n4 < n5; ++n4) {
                log.debug((Object)(string + " contextual substitution coverage table offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n5];
        for (int i = 0; i < n5; ++i) {
            int n7 = nArray[i];
            object = n7 > 0 ? this.readCoverageTable(string + " contextual substitution coverage[" + i + "]", l + (long)n7) : null;
            glyphCoverageTableArray[i] = object;
        }
        String string2 = null;
        if (log.isDebugEnabled()) {
            string2 = string + " contextual substitution lookups: ";
        }
        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n6, string2);
        object = new GlyphTable.CoverageSequenceRule(ruleLookupArray, n5, glyphCoverageTableArray);
        GlyphTable.HomogeneousRuleSet homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{object});
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[]{homogeneousRuleSet};
        assert (glyphCoverageTableArray != null && glyphCoverageTableArray.length > 0);
        this.seMapping = glyphCoverageTableArray[0];
        this.seEntries.add(ruleSetArray);
    }

    private int readContextualSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readContextualSubTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readContextualSubTableFormat2(n, n2, l, n3);
        } else if (n3 == 3) {
            this.readContextualSubTableFormat3(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported contextual substitution subtable format: " + n3);
        }
        return n3;
    }

    private void readChainedContextualSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " chained contextual substitution format: " + n3 + " (glyphs)"));
            log.debug((Object)(string + " chained contextual substitution coverage table offset: " + n5));
            log.debug((Object)(string + " chained contextual substitution rule set count: " + n6));
            for (n4 = 0; n4 < n6; ++n4) {
                log.debug((Object)(string + " chained contextual substitution rule set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " chained contextual substitution coverage", l + (long)n5) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n6];
        String string2 = null;
        for (int i = 0; i < n6; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n7 = nArray[i];
            if (n7 > 0) {
                int n8;
                this.in.seekSet(l + (long)n7);
                int n9 = this.in.readTTFUShort();
                int[] nArray2 = new int[n9];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    nArray2[n8] = this.in.readTTFUShort();
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int n10 = nArray2[n8];
                    if (n10 > 0) {
                        int n11;
                        int n12;
                        int n13;
                        this.in.seekSet(l + (long)n7 + (long)n10);
                        int n14 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n14];
                        int n15 = nArray3.length;
                        for (n13 = 0; n13 < n15; ++n13) {
                            nArray3[n13] = this.in.readTTFUShort();
                        }
                        n13 = this.in.readTTFUShort();
                        int[] nArray4 = new int[n13 - 1];
                        int n16 = nArray4.length;
                        for (n12 = 0; n12 < n16; ++n12) {
                            nArray4[n12] = this.in.readTTFUShort();
                        }
                        n12 = this.in.readTTFUShort();
                        int[] nArray5 = new int[n12];
                        int n17 = nArray5.length;
                        for (n11 = 0; n11 < n17; ++n11) {
                            nArray5[n11] = this.in.readTTFUShort();
                        }
                        n11 = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual substitution lookups @rule[" + i + "][" + n8 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n11, string2);
                        chainedGlyphSequenceRule = new GlyphTable.ChainedGlyphSequenceRule(ruleLookupArray, n13, nArray4, nArray3, nArray5);
                    } else {
                        chainedGlyphSequenceRule = null;
                    }
                    ruleArray[n8] = chainedGlyphSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(ruleSetArray);
    }

    private void readChainedContextualSubTableFormat2(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int[] nArray = new int[n9];
        for (n4 = 0; n4 < n9; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " chained contextual substitution format: " + n3 + " (glyph classes)"));
            log.debug((Object)(string + " chained contextual substitution coverage table offset: " + n5));
            log.debug((Object)(string + " chained contextual substitution class set count: " + n9));
            for (n4 = 0; n4 < n9; ++n4) {
                log.debug((Object)(string + " chained contextual substitution class set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " chained contextual substitution coverage", l + (long)n5) : null;
        GlyphClassTable glyphClassTable = n6 > 0 ? this.readClassDefTable(string + " contextual substitution backtrack class definition", l + (long)n6) : null;
        GlyphClassTable glyphClassTable2 = n7 > 0 ? this.readClassDefTable(string + " contextual substitution input class definition", l + (long)n7) : null;
        GlyphClassTable glyphClassTable3 = n8 > 0 ? this.readClassDefTable(string + " contextual substitution lookahead class definition", l + (long)n8) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n9];
        String string2 = null;
        for (int i = 0; i < n9; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n10 = nArray[i];
            if (n10 > 0) {
                int n11;
                this.in.seekSet(l + (long)n10);
                int n12 = this.in.readTTFUShort();
                int[] nArray2 = new int[n12];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n12];
                for (n11 = 0; n11 < n12; ++n11) {
                    nArray2[n11] = this.in.readTTFUShort();
                }
                for (n11 = 0; n11 < n12; ++n11) {
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int n13 = nArray2[n11];
                    if (n13 > 0) {
                        int n14;
                        int n15;
                        int n16;
                        this.in.seekSet(l + (long)n10 + (long)n13);
                        int n17 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n17];
                        int n18 = nArray3.length;
                        for (n16 = 0; n16 < n18; ++n16) {
                            nArray3[n16] = this.in.readTTFUShort();
                        }
                        n16 = this.in.readTTFUShort();
                        int[] nArray4 = new int[n16 - 1];
                        int n19 = nArray4.length;
                        for (n15 = 0; n15 < n19; ++n15) {
                            nArray4[n15] = this.in.readTTFUShort();
                        }
                        n15 = this.in.readTTFUShort();
                        int[] nArray5 = new int[n15];
                        int n20 = nArray5.length;
                        for (n14 = 0; n14 < n20; ++n14) {
                            nArray5[n14] = this.in.readTTFUShort();
                        }
                        n14 = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual substitution lookups @rule[" + i + "][" + n11 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n14, string2);
                        chainedClassSequenceRule = new GlyphTable.ChainedClassSequenceRule(ruleLookupArray, n16, nArray4, nArray3, nArray5);
                    } else {
                        chainedClassSequenceRule = null;
                    }
                    ruleArray[n11] = chainedClassSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphClassTable2);
        this.seEntries.add(glyphClassTable);
        this.seEntries.add(glyphClassTable3);
        this.seEntries.add(n9);
        this.seEntries.add(ruleSetArray);
    }

    private void readChainedContextualSubTableFormat3(int n, int n2, long l, int n3) throws IOException {
        Object object;
        int n4;
        int n5;
        int n6;
        int n7;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n8 = this.in.readTTFUShort();
        int[] nArray = new int[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            nArray[n7] = this.in.readTTFUShort();
        }
        n7 = this.in.readTTFUShort();
        int[] nArray2 = new int[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            nArray2[n6] = this.in.readTTFUShort();
        }
        n6 = this.in.readTTFUShort();
        int[] nArray3 = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray3[n5] = this.in.readTTFUShort();
        }
        n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            int n9;
            log.debug((Object)(string + " chained contextual substitution format: " + n3 + " (glyph sets)"));
            log.debug((Object)(string + " chained contextual substitution backtrack glyph count: " + n8));
            for (n9 = 0; n9 < n8; ++n9) {
                log.debug((Object)(string + " chained contextual substitution backtrack coverage table offset[" + n9 + "]: " + nArray[n9]));
            }
            log.debug((Object)(string + " chained contextual substitution input glyph count: " + n7));
            for (n9 = 0; n9 < n7; ++n9) {
                log.debug((Object)(string + " chained contextual substitution input coverage table offset[" + n9 + "]: " + nArray2[n9]));
            }
            log.debug((Object)(string + " chained contextual substitution lookahead glyph count: " + n6));
            for (n9 = 0; n9 < n6; ++n9) {
                log.debug((Object)(string + " chained contextual substitution lookahead coverage table offset[" + n9 + "]: " + nArray3[n9]));
            }
            log.debug((Object)(string + " chained contextual substitution lookup count: " + n5));
        }
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n8];
        for (int i = 0; i < n8; ++i) {
            n4 = nArray[i];
            GlyphCoverageTable glyphCoverageTable = n4 > 0 ? this.readCoverageTable(string + " chained contextual substitution backtrack coverage[" + i + "]", l + (long)n4) : null;
            glyphCoverageTableArray[i] = glyphCoverageTable;
        }
        GlyphCoverageTable[] glyphCoverageTableArray2 = new GlyphCoverageTable[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            int n10 = nArray2[n4];
            GlyphCoverageTable glyphCoverageTable = n10 > 0 ? this.readCoverageTable(string + " chained contextual substitution input coverage[" + n4 + "]", l + (long)n10) : null;
            glyphCoverageTableArray2[n4] = glyphCoverageTable;
        }
        GlyphCoverageTable[] glyphCoverageTableArray3 = new GlyphCoverageTable[n6];
        for (int i = 0; i < n6; ++i) {
            int n11 = nArray3[i];
            object = n11 > 0 ? this.readCoverageTable(string + " chained contextual substitution lookahead coverage[" + i + "]", l + (long)n11) : null;
            glyphCoverageTableArray3[i] = object;
        }
        String string2 = null;
        if (log.isDebugEnabled()) {
            string2 = string + " chained contextual substitution lookups: ";
        }
        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n5, string2);
        object = new GlyphTable.ChainedCoverageSequenceRule(ruleLookupArray, n7, glyphCoverageTableArray2, glyphCoverageTableArray, glyphCoverageTableArray3);
        GlyphTable.HomogeneousRuleSet homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{object});
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[]{homogeneousRuleSet};
        assert (glyphCoverageTableArray2 != null && glyphCoverageTableArray2.length > 0);
        this.seMapping = glyphCoverageTableArray2[0];
        this.seEntries.add(ruleSetArray);
    }

    private int readChainedContextualSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readChainedContextualSubTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readChainedContextualSubTableFormat2(n, n2, l, n3);
        } else if (n3 == 3) {
            this.readChainedContextualSubTableFormat3(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported chained contextual substitution subtable format: " + n3);
        }
        return n3;
    }

    private void readExtensionSubTableFormat1(int n, int n2, int n3, int n4, long l, int n5) throws IOException {
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n6 = this.in.readTTFUShort();
        long l2 = this.in.readTTFULong();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " extension substitution subtable format: " + n5));
            log.debug((Object)(string + " extension substitution lookup type: " + n6));
            log.debug((Object)(string + " extension substitution lookup table offset: " + l2));
        }
        this.readGSUBSubtable(n6, n2, n3, n4, l + l2);
    }

    private int readExtensionSubTable(int n, int n2, int n3, int n4, long l) throws IOException {
        this.in.seekSet(l);
        int n5 = this.in.readTTFUShort();
        if (n5 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported extension substitution subtable format: " + n5);
        }
        this.readExtensionSubTableFormat1(n, n2, n3, n4, l, n5);
        return n5;
    }

    private void readReverseChainedSingleSubTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7;
        String string = "GSUB";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int[] nArray = new int[n9];
        for (n7 = 0; n7 < n9; ++n7) {
            nArray[n7] = this.in.readTTFUShort();
        }
        n7 = this.in.readTTFUShort();
        int[] nArray2 = new int[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            nArray2[n6] = this.in.readTTFUShort();
        }
        n6 = this.in.readTTFUShort();
        int[] nArray3 = new int[n6];
        int n10 = n6;
        for (n5 = 0; n5 < n10; ++n5) {
            nArray3[n5] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " reverse chained contextual substitution format: " + n3));
            log.debug((Object)(string + " reverse chained contextual substitution coverage table offset: " + n8));
            log.debug((Object)(string + " reverse chained contextual substitution backtrack glyph count: " + n9));
            for (n5 = 0; n5 < n9; ++n5) {
                log.debug((Object)(string + " reverse chained contextual substitution backtrack coverage table offset[" + n5 + "]: " + nArray[n5]));
            }
            log.debug((Object)(string + " reverse chained contextual substitution lookahead glyph count: " + n7));
            for (n5 = 0; n5 < n7; ++n5) {
                log.debug((Object)(string + " reverse chained contextual substitution lookahead coverage table offset[" + n5 + "]: " + nArray2[n5]));
            }
            log.debug((Object)(string + " reverse chained contextual substitution glyphs: " + this.toString(nArray3)));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " reverse chained contextual substitution coverage", l + (long)n8);
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n9];
        for (int i = 0; i < n9; ++i) {
            n4 = nArray[i];
            GlyphCoverageTable glyphCoverageTable2 = n4 > 0 ? this.readCoverageTable(string + " reverse chained contextual substitution backtrack coverage[" + i + "]", l + (long)n4) : null;
            glyphCoverageTableArray[i] = glyphCoverageTable2;
        }
        GlyphCoverageTable[] glyphCoverageTableArray2 = new GlyphCoverageTable[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            int n11 = nArray2[n4];
            GlyphCoverageTable glyphCoverageTable3 = n11 > 0 ? this.readCoverageTable(string + " reverse chained contextual substitution lookahead coverage[" + n4 + "]", l + (long)n11) : null;
            glyphCoverageTableArray2[n4] = glyphCoverageTable3;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphCoverageTableArray);
        this.seEntries.add(glyphCoverageTableArray2);
        this.seEntries.add(nArray3);
    }

    private int readReverseChainedSingleSubTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported reverse chained single substitution subtable format: " + n3);
        }
        this.readReverseChainedSingleSubTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readGSUBSubtable(int n, int n2, int n3, int n4, long l) throws IOException {
        this.initATSubState();
        int n5 = -1;
        switch (n) {
            case 1: {
                n5 = this.readSingleSubTable(n, n2, l);
                break;
            }
            case 2: {
                n5 = this.readMultipleSubTable(n, n2, l);
                break;
            }
            case 3: {
                n5 = this.readAlternateSubTable(n, n2, l);
                break;
            }
            case 4: {
                n5 = this.readLigatureSubTable(n, n2, l);
                break;
            }
            case 5: {
                n5 = this.readContextualSubTable(n, n2, l);
                break;
            }
            case 6: {
                n5 = this.readChainedContextualSubTable(n, n2, l);
                break;
            }
            case 8: {
                n5 = this.readReverseChainedSingleSubTable(n, n2, l);
                break;
            }
            case 7: {
                n5 = this.readExtensionSubTable(n, n2, n3, n4, l);
                break;
            }
        }
        this.extractSESubState(1, n, n2, n3, n4, n5);
        this.resetATSubState();
    }

    private GlyphPositioningTable.DeviceTable readPosDeviceTable(long l, long l2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long l3 = this.in.getCurrentPos();
        this.in.seekSet(l + l2);
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        if (n8 == 1) {
            n5 = 14;
            n4 = 3;
            n3 = 1;
            n2 = 4;
            n = 2;
        } else if (n8 == 2) {
            n5 = 12;
            n4 = 15;
            n3 = 7;
            n2 = 16;
            n = 4;
        } else if (n8 == 3) {
            n5 = 8;
            n4 = 255;
            n3 = 127;
            n2 = 256;
            n = 8;
        } else {
            log.debug((Object)("unsupported device table delta format: " + n8 + ", ignoring device table"));
            return null;
        }
        int n9 = n7 - n6 + 1;
        if (n9 < 0) {
            log.debug((Object)("invalid device table delta count: " + n9 + ", ignoring device table"));
            return null;
        }
        int[] nArray = new int[n9];
        int n10 = 0;
        block0: while (n10 < n9 && n > 0) {
            int n11 = this.in.readTTFUShort();
            int n12 = 16 / n;
            for (int i = 0; i < n12; ++i) {
                int n13 = n11 >> n5 & n4;
                if (n13 > n3) {
                    n13 -= n2;
                }
                if (n10 >= n9) continue block0;
                nArray[n10++] = n13;
                n11 <<= n;
            }
        }
        this.in.seekSet(l3);
        return new GlyphPositioningTable.DeviceTable(n6, n7, nArray);
    }

    private GlyphPositioningTable.Value readPosValue(long l, int n) throws IOException {
        GlyphPositioningTable.DeviceTable deviceTable;
        GlyphPositioningTable.DeviceTable deviceTable2;
        GlyphPositioningTable.DeviceTable deviceTable3;
        GlyphPositioningTable.DeviceTable deviceTable4;
        int n2 = (n & 1) != 0 ? this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int n3 = (n & 2) != 0 ? this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int n4 = (n & 4) != 0 ? this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        int n5 = (n & 8) != 0 ? this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort()) : 0;
        if ((n & 0x10) != 0) {
            int n6 = this.in.readTTFUShort();
            deviceTable4 = this.readPosDeviceTable(l, n6);
        } else {
            deviceTable4 = null;
        }
        if ((n & 0x20) != 0) {
            int n7 = this.in.readTTFUShort();
            deviceTable3 = this.readPosDeviceTable(l, n7);
        } else {
            deviceTable3 = null;
        }
        if ((n & 0x40) != 0) {
            int n8 = this.in.readTTFUShort();
            deviceTable2 = this.readPosDeviceTable(l, n8);
        } else {
            deviceTable2 = null;
        }
        if ((n & 0x80) != 0) {
            int n9 = this.in.readTTFUShort();
            deviceTable = this.readPosDeviceTable(l, n9);
        } else {
            deviceTable = null;
        }
        return new GlyphPositioningTable.Value(n2, n3, n4, n5, deviceTable4, deviceTable3, deviceTable2, deviceTable);
    }

    private void readSinglePosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        GlyphPositioningTable.Value value = this.readPosValue(l, n5);
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " single positioning subtable format: " + n3 + " (delta)"));
            log.debug((Object)(string + " single positioning coverage table offset: " + n4));
            log.debug((Object)(string + " single positioning value: " + value));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " single positioning coverage", l + (long)n4);
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(value);
    }

    private void readSinglePosTableFormat2(int n, int n2, long l, int n3) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " single positioning subtable format: " + n3 + " (mapped)"));
            log.debug((Object)(string + " single positioning coverage table offset: " + n4));
            log.debug((Object)(string + " single positioning value count: " + n6));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " single positioning coverage", l + (long)n4);
        GlyphPositioningTable.Value[] valueArray = new GlyphPositioningTable.Value[n6];
        int n7 = n6;
        for (int i = 0; i < n7; ++i) {
            GlyphPositioningTable.Value value = this.readPosValue(l, n5);
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + " single positioning value[" + i + "]: " + value));
            }
            valueArray[i] = value;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(valueArray);
    }

    private int readSinglePosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readSinglePosTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readSinglePosTableFormat2(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported single positioning subtable format: " + n3);
        }
        return n3;
    }

    private GlyphPositioningTable.PairValues readPosPairValues(long l, boolean bl, int n, int n2) throws IOException {
        int n3 = bl ? this.in.readTTFUShort() : 0;
        GlyphPositioningTable.Value value = n != 0 ? this.readPosValue(l, n) : null;
        GlyphPositioningTable.Value value2 = n2 != 0 ? this.readPosValue(l, n2) : null;
        return new GlyphPositioningTable.PairValues(n3, value, value2);
    }

    private GlyphPositioningTable.PairValues[] readPosPairSetTable(long l, int n, int n2, int n3) throws IOException {
        String string = "GPOS";
        long l2 = this.in.getCurrentPos();
        this.in.seekSet(l + (long)n);
        int n4 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " pair set table offset: " + n));
            log.debug((Object)(string + " pair set table values count: " + n4));
        }
        GlyphPositioningTable.PairValues[] pairValuesArray = new GlyphPositioningTable.PairValues[n4];
        int n5 = n4;
        for (int i = 0; i < n5; ++i) {
            GlyphPositioningTable.PairValues pairValues;
            pairValuesArray[i] = pairValues = this.readPosPairValues(l, true, n2, n3);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(string + " pair set table value[" + i + "]: " + pairValues));
        }
        this.in.seekSet(l2);
        return pairValuesArray;
    }

    private void readPairPosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " pair positioning subtable format: " + n3 + " (glyphs)"));
            log.debug((Object)(string + " pair positioning coverage table offset: " + n4));
            log.debug((Object)(string + " pair positioning value format #1: " + n5));
            log.debug((Object)(string + " pair positioning value format #2: " + n6));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " pair positioning coverage", l + (long)n4);
        GlyphPositioningTable.PairValues[][] pairValuesArrayArray = new GlyphPositioningTable.PairValues[n7][];
        int n8 = n7;
        for (int i = 0; i < n8; ++i) {
            int n9 = this.in.readTTFUShort();
            pairValuesArrayArray[i] = this.readPosPairSetTable(l, n9, n5, n6);
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(pairValuesArrayArray);
    }

    private void readPairPosTableFormat2(int n, int n2, long l, int n3) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int n10 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " pair positioning subtable format: " + n3 + " (glyph classes)"));
            log.debug((Object)(string + " pair positioning coverage table offset: " + n4));
            log.debug((Object)(string + " pair positioning value format #1: " + n5));
            log.debug((Object)(string + " pair positioning value format #2: " + n6));
            log.debug((Object)(string + " pair positioning class def table #1 offset: " + n7));
            log.debug((Object)(string + " pair positioning class def table #2 offset: " + n8));
            log.debug((Object)(string + " pair positioning class #1 count: " + n9));
            log.debug((Object)(string + " pair positioning class #2 count: " + n10));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " pair positioning coverage", l + (long)n4);
        GlyphClassTable glyphClassTable = this.readClassDefTable(string + " pair positioning class definition #1", l + (long)n7);
        GlyphClassTable glyphClassTable2 = this.readClassDefTable(string + " pair positioning class definition #2", l + (long)n8);
        GlyphPositioningTable.PairValues[][] pairValuesArray = new GlyphPositioningTable.PairValues[n9][n10];
        for (int i = 0; i < n9; ++i) {
            for (int j = 0; j < n10; ++j) {
                GlyphPositioningTable.PairValues pairValues;
                pairValuesArray[i][j] = pairValues = this.readPosPairValues(l, false, n5, n6);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(string + " pair set table value[" + i + "][" + j + "]: " + pairValues));
            }
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphClassTable);
        this.seEntries.add(glyphClassTable2);
        this.seEntries.add(n9);
        this.seEntries.add(n10);
        this.seEntries.add(pairValuesArray);
    }

    private int readPairPosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readPairPosTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readPairPosTableFormat2(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported pair positioning subtable format: " + n3);
        }
        return n3;
    }

    private GlyphPositioningTable.Anchor readPosAnchor(long l) throws IOException {
        GlyphPositioningTable.Anchor anchor;
        long l2 = this.in.getCurrentPos();
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (n == 1) {
            int n2 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int n3 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            anchor = new GlyphPositioningTable.Anchor(n2, n3);
        } else if (n == 2) {
            int n4 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int n5 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int n6 = this.in.readTTFUShort();
            anchor = new GlyphPositioningTable.Anchor(n4, n5, n6);
        } else if (n == 3) {
            int n7 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int n8 = this.ttf.convertTTFUnit2PDFUnit(this.in.readTTFShort());
            int n9 = this.in.readTTFUShort();
            int n10 = this.in.readTTFUShort();
            GlyphPositioningTable.DeviceTable deviceTable = n9 != 0 ? this.readPosDeviceTable(l2, n9) : null;
            GlyphPositioningTable.DeviceTable deviceTable2 = n10 != 0 ? this.readPosDeviceTable(l2, n10) : null;
            anchor = new GlyphPositioningTable.Anchor(n7, n8, deviceTable, deviceTable2);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported positioning anchor format: " + n);
        }
        this.in.seekSet(l2);
        return anchor;
    }

    private void readCursivePosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " cursive positioning subtable format: " + n3));
            log.debug((Object)(string + " cursive positioning coverage table offset: " + n4));
            log.debug((Object)(string + " cursive positioning entry/exit count: " + n5));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " cursive positioning coverage", l + (long)n4);
        GlyphPositioningTable.Anchor[] anchorArray = new GlyphPositioningTable.Anchor[n5 * 2];
        int n6 = n5;
        for (int i = 0; i < n6; ++i) {
            int n7 = this.in.readTTFUShort();
            int n8 = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor anchor = n7 > 0 ? this.readPosAnchor(l + (long)n7) : null;
            GlyphPositioningTable.Anchor anchor2 = n8 > 0 ? this.readPosAnchor(l + (long)n8) : null;
            anchorArray[i * 2 + 0] = anchor;
            anchorArray[i * 2 + 1] = anchor2;
            if (!log.isDebugEnabled()) continue;
            if (anchor != null) {
                log.debug((Object)(string + " cursive entry anchor [" + i + "]: " + anchor));
            }
            if (anchor2 == null) continue;
            log.debug((Object)(string + " cursive exit anchor  [" + i + "]: " + anchor2));
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(anchorArray);
    }

    private int readCursivePosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported cursive positioning subtable format: " + n3);
        }
        this.readCursivePosTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readMarkToBasePosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        int n5;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int n10 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-base positioning subtable format: " + n3));
            log.debug((Object)(string + " mark-to-base positioning mark coverage table offset: " + n6));
            log.debug((Object)(string + " mark-to-base positioning base coverage table offset: " + n7));
            log.debug((Object)(string + " mark-to-base positioning mark class count: " + n8));
            log.debug((Object)(string + " mark-to-base positioning mark array offset: " + n9));
            log.debug((Object)(string + " mark-to-base positioning base array offset: " + n10));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " mark-to-base positioning mark coverage", l + (long)n6);
        GlyphCoverageTable glyphCoverageTable2 = this.readCoverageTable(string + " mark-to-base positioning base coverage", l + (long)n7);
        this.in.seekSet(l + (long)n9);
        int n11 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-base positioning mark count: " + n11));
        }
        GlyphPositioningTable.MarkAnchor[] markAnchorArray = new GlyphPositioningTable.MarkAnchor[n11];
        for (n5 = 0; n5 < n11; ++n5) {
            int n12 = this.in.readTTFUShort();
            n4 = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor anchor = n4 > 0 ? this.readPosAnchor(l + (long)n9 + (long)n4) : null;
            GlyphPositioningTable.MarkAnchor markAnchor = anchor != null ? new GlyphPositioningTable.MarkAnchor(n12, anchor) : null;
            markAnchorArray[n5] = markAnchor;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(string + " mark-to-base positioning mark anchor[" + n5 + "]: " + markAnchor));
        }
        this.in.seekSet(l + (long)n10);
        n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-base positioning base count: " + n5));
        }
        GlyphPositioningTable.Anchor[][] anchorArray = new GlyphPositioningTable.Anchor[n5][n8];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n8; ++i) {
                int n13 = this.in.readTTFUShort();
                GlyphPositioningTable.Anchor anchor = n13 > 0 ? this.readPosAnchor(l + (long)n10 + (long)n13) : null;
                anchorArray[n4][i] = anchor;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(string + " mark-to-base positioning base anchor[" + n4 + "][" + i + "]: " + anchor));
            }
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphCoverageTable2);
        this.seEntries.add(n8);
        this.seEntries.add(markAnchorArray);
        this.seEntries.add(anchorArray);
    }

    private int readMarkToBasePosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-base positioning subtable format: " + n3);
        }
        this.readMarkToBasePosTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readMarkToLigaturePosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int n10 = this.in.readTTFUShort();
        int n11 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-ligature positioning subtable format: " + n3));
            log.debug((Object)(string + " mark-to-ligature positioning mark coverage table offset: " + n7));
            log.debug((Object)(string + " mark-to-ligature positioning ligature coverage table offset: " + n8));
            log.debug((Object)(string + " mark-to-ligature positioning mark class count: " + n9));
            log.debug((Object)(string + " mark-to-ligature positioning mark array offset: " + n10));
            log.debug((Object)(string + " mark-to-ligature positioning ligature array offset: " + n11));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " mark-to-ligature positioning mark coverage", l + (long)n7);
        GlyphCoverageTable glyphCoverageTable2 = this.readCoverageTable(string + " mark-to-ligature positioning ligature coverage", l + (long)n8);
        this.in.seekSet(l + (long)n10);
        int n12 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-ligature positioning mark count: " + n12));
        }
        GlyphPositioningTable.MarkAnchor[] markAnchorArray = new GlyphPositioningTable.MarkAnchor[n12];
        for (n6 = 0; n6 < n12; ++n6) {
            int n13 = this.in.readTTFUShort();
            n5 = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor anchor = n5 > 0 ? this.readPosAnchor(l + (long)n10 + (long)n5) : null;
            GlyphPositioningTable.MarkAnchor markAnchor = anchor != null ? new GlyphPositioningTable.MarkAnchor(n13, anchor) : null;
            markAnchorArray[n6] = markAnchor;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(string + " mark-to-ligature positioning mark anchor[" + n6 + "]: " + markAnchor));
        }
        this.in.seekSet(l + (long)n11);
        n6 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-ligature positioning ligature count: " + n6));
        }
        int[] nArray = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = this.in.readTTFUShort();
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            int n14 = nArray[i];
            this.in.seekSet(l + (long)n11 + (long)n14);
            n4 = this.in.readTTFUShort();
            if (n4 <= n5) continue;
            n5 = n4;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-ligature positioning maximum component count: " + n5));
        }
        GlyphPositioningTable.Anchor[][][] anchorArrayArray = new GlyphPositioningTable.Anchor[n6][][];
        for (int i = 0; i < n6; ++i) {
            n4 = nArray[i];
            this.in.seekSet(l + (long)n11 + (long)n4);
            int n15 = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor[][] anchorArray = new GlyphPositioningTable.Anchor[n15][n9];
            for (int j = 0; j < n15; ++j) {
                for (int k = 0; k < n9; ++k) {
                    int n16 = this.in.readTTFUShort();
                    GlyphPositioningTable.Anchor anchor = n16 > 0 ? this.readPosAnchor(l + (long)n11 + (long)n4 + (long)n16) : null;
                    anchorArray[j][k] = anchor;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(string + " mark-to-ligature positioning ligature anchor[" + i + "][" + j + "][" + k + "]: " + anchor));
                }
            }
            anchorArrayArray[i] = anchorArray;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphCoverageTable2);
        this.seEntries.add(n9);
        this.seEntries.add(n5);
        this.seEntries.add(markAnchorArray);
        this.seEntries.add(anchorArrayArray);
    }

    private int readMarkToLigaturePosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-ligature positioning subtable format: " + n3);
        }
        this.readMarkToLigaturePosTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readMarkToMarkPosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        int n5;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int n10 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-mark positioning subtable format: " + n3));
            log.debug((Object)(string + " mark-to-mark positioning mark #1 coverage table offset: " + n6));
            log.debug((Object)(string + " mark-to-mark positioning mark #2 coverage table offset: " + n7));
            log.debug((Object)(string + " mark-to-mark positioning mark class count: " + n8));
            log.debug((Object)(string + " mark-to-mark positioning mark #1 array offset: " + n9));
            log.debug((Object)(string + " mark-to-mark positioning mark #2 array offset: " + n10));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(string + " mark-to-mark positioning mark #1 coverage", l + (long)n6);
        GlyphCoverageTable glyphCoverageTable2 = this.readCoverageTable(string + " mark-to-mark positioning mark #2 coverage", l + (long)n7);
        this.in.seekSet(l + (long)n9);
        int n11 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-mark positioning mark #1 count: " + n11));
        }
        GlyphPositioningTable.MarkAnchor[] markAnchorArray = new GlyphPositioningTable.MarkAnchor[n11];
        for (n5 = 0; n5 < n11; ++n5) {
            int n12 = this.in.readTTFUShort();
            n4 = this.in.readTTFUShort();
            GlyphPositioningTable.Anchor anchor = n4 > 0 ? this.readPosAnchor(l + (long)n9 + (long)n4) : null;
            GlyphPositioningTable.MarkAnchor markAnchor = anchor != null ? new GlyphPositioningTable.MarkAnchor(n12, anchor) : null;
            markAnchorArray[n5] = markAnchor;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(string + " mark-to-mark positioning mark #1 anchor[" + n5 + "]: " + markAnchor));
        }
        this.in.seekSet(l + (long)n10);
        n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " mark-to-mark positioning mark #2 count: " + n5));
        }
        GlyphPositioningTable.Anchor[][] anchorArray = new GlyphPositioningTable.Anchor[n5][n8];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n8; ++i) {
                int n13 = this.in.readTTFUShort();
                GlyphPositioningTable.Anchor anchor = n13 > 0 ? this.readPosAnchor(l + (long)n10 + (long)n13) : null;
                anchorArray[n4][i] = anchor;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(string + " mark-to-mark positioning mark #2 anchor[" + n4 + "][" + i + "]: " + anchor));
            }
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphCoverageTable2);
        this.seEntries.add(n8);
        this.seEntries.add(markAnchorArray);
        this.seEntries.add(anchorArray);
    }

    private int readMarkToMarkPosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark-to-mark positioning subtable format: " + n3);
        }
        this.readMarkToMarkPosTableFormat1(n, n2, l, n3);
        return n3;
    }

    private void readContextualPosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual positioning subtable format: " + n3 + " (glyphs)"));
            log.debug((Object)(string + " contextual positioning coverage table offset: " + n5));
            log.debug((Object)(string + " contextual positioning rule set count: " + n6));
            for (n4 = 0; n4 < n6; ++n4) {
                log.debug((Object)(string + " contextual positioning rule set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " contextual positioning coverage", l + (long)n5) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n6];
        String string2 = null;
        for (int i = 0; i < n6; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n7 = nArray[i];
            if (n7 > 0) {
                int n8;
                this.in.seekSet(l + (long)n7);
                int n9 = this.in.readTTFUShort();
                int[] nArray2 = new int[n9];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    nArray2[n8] = this.in.readTTFUShort();
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    GlyphTable.GlyphSequenceRule glyphSequenceRule;
                    int n10 = nArray2[n8];
                    if (n10 > 0) {
                        this.in.seekSet(l + (long)n7 + (long)n10);
                        int n11 = this.in.readTTFUShort();
                        int n12 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n11 - 1];
                        int n13 = nArray3.length;
                        for (int j = 0; j < n13; ++j) {
                            nArray3[j] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual positioning lookups @rule[" + i + "][" + n8 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n12, string2);
                        glyphSequenceRule = new GlyphTable.GlyphSequenceRule(ruleLookupArray, n11, nArray3);
                    } else {
                        glyphSequenceRule = null;
                    }
                    ruleArray[n8] = glyphSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(ruleSetArray);
    }

    private void readContextualPosTableFormat2(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int[] nArray = new int[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual positioning subtable format: " + n3 + " (glyph classes)"));
            log.debug((Object)(string + " contextual positioning coverage table offset: " + n5));
            log.debug((Object)(string + " contextual positioning class set count: " + n7));
            for (n4 = 0; n4 < n7; ++n4) {
                log.debug((Object)(string + " contextual positioning class set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " contextual positioning coverage", l + (long)n5) : null;
        GlyphClassTable glyphClassTable = n6 > 0 ? this.readClassDefTable(string + " contextual positioning class definition", l + (long)n6) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n7];
        String string2 = null;
        for (int i = 0; i < n7; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n8 = nArray[i];
            if (n8 > 0) {
                int n9;
                this.in.seekSet(l + (long)n8);
                int n10 = this.in.readTTFUShort();
                int[] nArray2 = new int[n10];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n10];
                for (n9 = 0; n9 < n10; ++n9) {
                    nArray2[n9] = this.in.readTTFUShort();
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    GlyphTable.ClassSequenceRule classSequenceRule;
                    int n11 = nArray2[n9];
                    if (n11 > 0) {
                        this.in.seekSet(l + (long)n8 + (long)n11);
                        int n12 = this.in.readTTFUShort();
                        int n13 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n12 - 1];
                        int n14 = nArray3.length;
                        for (int j = 0; j < n14; ++j) {
                            nArray3[j] = this.in.readTTFUShort();
                        }
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual positioning lookups @rule[" + i + "][" + n9 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n13, string2);
                        classSequenceRule = new GlyphTable.ClassSequenceRule(ruleLookupArray, n12, nArray3);
                    } else {
                        classSequenceRule = null;
                    }
                    ruleArray[n9] = classSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphClassTable);
        this.seEntries.add(n7);
        this.seEntries.add(ruleSetArray);
    }

    private void readContextualPosTableFormat3(int n, int n2, long l, int n3) throws IOException {
        Object object;
        int n4;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " contextual positioning subtable format: " + n3 + " (glyph sets)"));
            log.debug((Object)(string + " contextual positioning glyph input sequence length count: " + n5));
            log.debug((Object)(string + " contextual positioning lookup count: " + n6));
            for (n4 = 0; n4 < n5; ++n4) {
                log.debug((Object)(string + " contextual positioning coverage table offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n5];
        for (int i = 0; i < n5; ++i) {
            int n7 = nArray[i];
            object = n7 > 0 ? this.readCoverageTable(string + " contextual positioning coverage[" + i + "]", l + (long)nArray[i]) : null;
            glyphCoverageTableArray[i] = object;
        }
        String string2 = null;
        if (log.isDebugEnabled()) {
            string2 = string + " contextual positioning lookups: ";
        }
        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n6, string2);
        object = new GlyphTable.CoverageSequenceRule(ruleLookupArray, n5, glyphCoverageTableArray);
        GlyphTable.HomogeneousRuleSet homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{object});
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[]{homogeneousRuleSet};
        assert (glyphCoverageTableArray != null && glyphCoverageTableArray.length > 0);
        this.seMapping = glyphCoverageTableArray[0];
        this.seEntries.add(ruleSetArray);
    }

    private int readContextualPosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readContextualPosTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readContextualPosTableFormat2(n, n2, l, n3);
        } else if (n3 == 3) {
            this.readContextualPosTableFormat3(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported contextual positioning subtable format: " + n3);
        }
        return n3;
    }

    private void readChainedContextualPosTableFormat1(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " chained contextual positioning subtable format: " + n3 + " (glyphs)"));
            log.debug((Object)(string + " chained contextual positioning coverage table offset: " + n5));
            log.debug((Object)(string + " chained contextual positioning rule set count: " + n6));
            for (n4 = 0; n4 < n6; ++n4) {
                log.debug((Object)(string + " chained contextual positioning rule set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " chained contextual positioning coverage", l + (long)n5) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n6];
        String string2 = null;
        for (int i = 0; i < n6; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n7 = nArray[i];
            if (n7 > 0) {
                int n8;
                this.in.seekSet(l + (long)n7);
                int n9 = this.in.readTTFUShort();
                int[] nArray2 = new int[n9];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    nArray2[n8] = this.in.readTTFUShort();
                }
                for (n8 = 0; n8 < n9; ++n8) {
                    GlyphTable.ChainedGlyphSequenceRule chainedGlyphSequenceRule;
                    int n10 = nArray2[n8];
                    if (n10 > 0) {
                        int n11;
                        int n12;
                        int n13;
                        this.in.seekSet(l + (long)n7 + (long)n10);
                        int n14 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n14];
                        int n15 = nArray3.length;
                        for (n13 = 0; n13 < n15; ++n13) {
                            nArray3[n13] = this.in.readTTFUShort();
                        }
                        n13 = this.in.readTTFUShort();
                        int[] nArray4 = new int[n13 - 1];
                        int n16 = nArray4.length;
                        for (n12 = 0; n12 < n16; ++n12) {
                            nArray4[n12] = this.in.readTTFUShort();
                        }
                        n12 = this.in.readTTFUShort();
                        int[] nArray5 = new int[n12];
                        int n17 = nArray5.length;
                        for (n11 = 0; n11 < n17; ++n11) {
                            nArray5[n11] = this.in.readTTFUShort();
                        }
                        n11 = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual positioning lookups @rule[" + i + "][" + n8 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n11, string2);
                        chainedGlyphSequenceRule = new GlyphTable.ChainedGlyphSequenceRule(ruleLookupArray, n13, nArray4, nArray3, nArray5);
                    } else {
                        chainedGlyphSequenceRule = null;
                    }
                    ruleArray[n8] = chainedGlyphSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(ruleSetArray);
    }

    private void readChainedContextualPosTableFormat2(int n, int n2, long l, int n3) throws IOException {
        int n4;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        int n7 = this.in.readTTFUShort();
        int n8 = this.in.readTTFUShort();
        int n9 = this.in.readTTFUShort();
        int[] nArray = new int[n9];
        for (n4 = 0; n4 < n9; ++n4) {
            nArray[n4] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " chained contextual positioning subtable format: " + n3 + " (glyph classes)"));
            log.debug((Object)(string + " chained contextual positioning coverage table offset: " + n5));
            log.debug((Object)(string + " chained contextual positioning class set count: " + n9));
            for (n4 = 0; n4 < n9; ++n4) {
                log.debug((Object)(string + " chained contextual positioning class set offset[" + n4 + "]: " + nArray[n4]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = n5 > 0 ? this.readCoverageTable(string + " chained contextual positioning coverage", l + (long)n5) : null;
        GlyphClassTable glyphClassTable = n6 > 0 ? this.readClassDefTable(string + " contextual positioning backtrack class definition", l + (long)n6) : null;
        GlyphClassTable glyphClassTable2 = n7 > 0 ? this.readClassDefTable(string + " contextual positioning input class definition", l + (long)n7) : null;
        GlyphClassTable glyphClassTable3 = n8 > 0 ? this.readClassDefTable(string + " contextual positioning lookahead class definition", l + (long)n8) : null;
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[n9];
        String string2 = null;
        for (int i = 0; i < n9; ++i) {
            GlyphTable.HomogeneousRuleSet homogeneousRuleSet;
            int n10 = nArray[i];
            if (n10 > 0) {
                int n11;
                this.in.seekSet(l + (long)n10);
                int n12 = this.in.readTTFUShort();
                int[] nArray2 = new int[n12];
                GlyphTable.Rule[] ruleArray = new GlyphTable.Rule[n12];
                for (n11 = 0; n11 < n12; ++n11) {
                    nArray2[n11] = this.in.readTTFUShort();
                }
                for (n11 = 0; n11 < n12; ++n11) {
                    GlyphTable.ChainedClassSequenceRule chainedClassSequenceRule;
                    int n13 = nArray2[n11];
                    if (n13 > 0) {
                        int n14;
                        int n15;
                        int n16;
                        this.in.seekSet(l + (long)n10 + (long)n13);
                        int n17 = this.in.readTTFUShort();
                        int[] nArray3 = new int[n17];
                        int n18 = nArray3.length;
                        for (n16 = 0; n16 < n18; ++n16) {
                            nArray3[n16] = this.in.readTTFUShort();
                        }
                        n16 = this.in.readTTFUShort();
                        int[] nArray4 = new int[n16 - 1];
                        int n19 = nArray4.length;
                        for (n15 = 0; n15 < n19; ++n15) {
                            nArray4[n15] = this.in.readTTFUShort();
                        }
                        n15 = this.in.readTTFUShort();
                        int[] nArray5 = new int[n15];
                        int n20 = nArray5.length;
                        for (n14 = 0; n14 < n20; ++n14) {
                            nArray5[n14] = this.in.readTTFUShort();
                        }
                        n14 = this.in.readTTFUShort();
                        if (log.isDebugEnabled()) {
                            string2 = string + " contextual positioning lookups @rule[" + i + "][" + n11 + "]: ";
                        }
                        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n14, string2);
                        chainedClassSequenceRule = new GlyphTable.ChainedClassSequenceRule(ruleLookupArray, n16, nArray4, nArray3, nArray5);
                    } else {
                        chainedClassSequenceRule = null;
                    }
                    ruleArray[n11] = chainedClassSequenceRule;
                }
                homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(ruleArray);
            } else {
                homogeneousRuleSet = null;
            }
            ruleSetArray[i] = homogeneousRuleSet;
        }
        this.seMapping = glyphCoverageTable;
        this.seEntries.add(glyphClassTable2);
        this.seEntries.add(glyphClassTable);
        this.seEntries.add(glyphClassTable3);
        this.seEntries.add(n9);
        this.seEntries.add(ruleSetArray);
    }

    private void readChainedContextualPosTableFormat3(int n, int n2, long l, int n3) throws IOException {
        Object object;
        int n4;
        int n5;
        int n6;
        int n7;
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n8 = this.in.readTTFUShort();
        int[] nArray = new int[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            nArray[n7] = this.in.readTTFUShort();
        }
        n7 = this.in.readTTFUShort();
        int[] nArray2 = new int[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            nArray2[n6] = this.in.readTTFUShort();
        }
        n6 = this.in.readTTFUShort();
        int[] nArray3 = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray3[n5] = this.in.readTTFUShort();
        }
        n5 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            int n9;
            log.debug((Object)(string + " chained contextual positioning subtable format: " + n3 + " (glyph sets)"));
            log.debug((Object)(string + " chained contextual positioning backtrack glyph count: " + n8));
            for (n9 = 0; n9 < n8; ++n9) {
                log.debug((Object)(string + " chained contextual positioning backtrack coverage table offset[" + n9 + "]: " + nArray[n9]));
            }
            log.debug((Object)(string + " chained contextual positioning input glyph count: " + n7));
            for (n9 = 0; n9 < n7; ++n9) {
                log.debug((Object)(string + " chained contextual positioning input coverage table offset[" + n9 + "]: " + nArray2[n9]));
            }
            log.debug((Object)(string + " chained contextual positioning lookahead glyph count: " + n6));
            for (n9 = 0; n9 < n6; ++n9) {
                log.debug((Object)(string + " chained contextual positioning lookahead coverage table offset[" + n9 + "]: " + nArray3[n9]));
            }
            log.debug((Object)(string + " chained contextual positioning lookup count: " + n5));
        }
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n8];
        for (int i = 0; i < n8; ++i) {
            n4 = nArray[i];
            GlyphCoverageTable glyphCoverageTable = n4 > 0 ? this.readCoverageTable(string + " chained contextual positioning backtrack coverage[" + i + "]", l + (long)n4) : null;
            glyphCoverageTableArray[i] = glyphCoverageTable;
        }
        GlyphCoverageTable[] glyphCoverageTableArray2 = new GlyphCoverageTable[n7];
        for (n4 = 0; n4 < n7; ++n4) {
            int n10 = nArray2[n4];
            GlyphCoverageTable glyphCoverageTable = n10 > 0 ? this.readCoverageTable(string + " chained contextual positioning input coverage[" + n4 + "]", l + (long)n10) : null;
            glyphCoverageTableArray2[n4] = glyphCoverageTable;
        }
        GlyphCoverageTable[] glyphCoverageTableArray3 = new GlyphCoverageTable[n6];
        for (int i = 0; i < n6; ++i) {
            int n11 = nArray3[i];
            object = n11 > 0 ? this.readCoverageTable(string + " chained contextual positioning lookahead coverage[" + i + "]", l + (long)n11) : null;
            glyphCoverageTableArray3[i] = object;
        }
        String string2 = null;
        if (log.isDebugEnabled()) {
            string2 = string + " chained contextual positioning lookups: ";
        }
        GlyphTable.RuleLookup[] ruleLookupArray = this.readRuleLookups(n5, string2);
        object = new GlyphTable.ChainedCoverageSequenceRule(ruleLookupArray, n7, glyphCoverageTableArray2, glyphCoverageTableArray, glyphCoverageTableArray3);
        GlyphTable.HomogeneousRuleSet homogeneousRuleSet = new GlyphTable.HomogeneousRuleSet(new GlyphTable.Rule[]{object});
        GlyphTable.RuleSet[] ruleSetArray = new GlyphTable.RuleSet[]{homogeneousRuleSet};
        assert (glyphCoverageTableArray2 != null && glyphCoverageTableArray2.length > 0);
        this.seMapping = glyphCoverageTableArray2[0];
        this.seEntries.add(ruleSetArray);
    }

    private int readChainedContextualPosTable(int n, int n2, long l) throws IOException {
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        if (n3 == 1) {
            this.readChainedContextualPosTableFormat1(n, n2, l, n3);
        } else if (n3 == 2) {
            this.readChainedContextualPosTableFormat2(n, n2, l, n3);
        } else if (n3 == 3) {
            this.readChainedContextualPosTableFormat3(n, n2, l, n3);
        } else {
            throw new AdvancedTypographicTableFormatException("unsupported chained contextual positioning subtable format: " + n3);
        }
        return n3;
    }

    private void readExtensionPosTableFormat1(int n, int n2, int n3, int n4, long l, int n5) throws IOException {
        String string = "GPOS";
        this.in.seekSet(l);
        this.in.skip(2L);
        int n6 = this.in.readTTFUShort();
        long l2 = this.in.readTTFULong();
        if (log.isDebugEnabled()) {
            log.debug((Object)(string + " extension positioning subtable format: " + n5));
            log.debug((Object)(string + " extension positioning lookup type: " + n6));
            log.debug((Object)(string + " extension positioning lookup table offset: " + l2));
        }
        this.readGPOSSubtable(n6, n2, n3, n4, l + l2);
    }

    private int readExtensionPosTable(int n, int n2, int n3, int n4, long l) throws IOException {
        this.in.seekSet(l);
        int n5 = this.in.readTTFUShort();
        if (n5 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported extension positioning subtable format: " + n5);
        }
        this.readExtensionPosTableFormat1(n, n2, n3, n4, l, n5);
        return n5;
    }

    private void readGPOSSubtable(int n, int n2, int n3, int n4, long l) throws IOException {
        this.initATSubState();
        int n5 = -1;
        switch (n) {
            case 1: {
                n5 = this.readSinglePosTable(n, n2, l);
                break;
            }
            case 2: {
                n5 = this.readPairPosTable(n, n2, l);
                break;
            }
            case 3: {
                n5 = this.readCursivePosTable(n, n2, l);
                break;
            }
            case 4: {
                n5 = this.readMarkToBasePosTable(n, n2, l);
                break;
            }
            case 5: {
                n5 = this.readMarkToLigaturePosTable(n, n2, l);
                break;
            }
            case 6: {
                n5 = this.readMarkToMarkPosTable(n, n2, l);
                break;
            }
            case 7: {
                n5 = this.readContextualPosTable(n, n2, l);
                break;
            }
            case 8: {
                n5 = this.readChainedContextualPosTable(n, n2, l);
                break;
            }
            case 9: {
                n5 = this.readExtensionPosTable(n, n2, n3, n4, l);
                break;
            }
        }
        this.extractSESubState(2, n, n2, n3, n4, n5);
        this.resetATSubState();
    }

    private void readLookupTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        int n2;
        int n3;
        Object object;
        boolean bl = tTFTableName.equals(TTFTableName.GSUB);
        boolean bl2 = tTFTableName.equals(TTFTableName.GPOS);
        this.in.seekSet(l);
        int n4 = this.in.readTTFUShort();
        int n5 = this.in.readTTFUShort();
        int n6 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            object = bl ? (Object)GSUBLookupType.toString(n4) : (bl2 ? (Object)GPOSLookupType.toString(n4) : (Object)"?");
            log.debug((Object)(tTFTableName + " lookup table type: " + n4 + " (" + (String)object + ")"));
            log.debug((Object)(tTFTableName + " lookup table flags: " + n5 + " (" + LookupFlag.toString(n5) + ")"));
            log.debug((Object)(tTFTableName + " lookup table subtable count: " + n6));
        }
        object = new int[n6];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " lookup table subtable offset: " + n2));
            }
            object[n3] = n2;
        }
        if ((n5 & 0x10) != 0) {
            n3 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " lookup table mark filter set: " + n3));
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = object[n3];
            if (bl) {
                this.readGSUBSubtable(n4, n5, n, n3, l + (long)n2);
                continue;
            }
            if (!bl2) continue;
            this.readGPOSSubtable(n4, n5, n, n3, l + (long)n2);
        }
    }

    private void readLookupList(TTFTableName tTFTableName, long l) throws IOException {
        this.in.seekSet(l);
        int n = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " lookup list record count: " + n));
        }
        if (n > 0) {
            int n2;
            int[] nArray = new int[n];
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = this.in.readTTFUShort();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " lookup table offset: " + n4));
                }
                nArray[n2] = n4;
            }
            n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tTFTableName + " lookup index: " + n2));
                }
                this.readLookupTable(tTFTableName, n2, l + (long)nArray[n2]);
            }
        }
    }

    private void readCommonLayoutTables(TTFTableName tTFTableName, long l, long l2, long l3) throws IOException {
        if (l > 0L) {
            this.readScriptList(tTFTableName, l);
        }
        if (l2 > 0L) {
            this.readFeatureList(tTFTableName, l2);
        }
        if (l3 > 0L) {
            this.readLookupList(tTFTableName, l3);
        }
    }

    private void readGDEFClassDefTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        this.initATSubState();
        this.in.seekSet(l);
        GlyphClassTable glyphClassTable = this.readClassDefTable(tTFTableName + " glyph class definition table", l);
        this.seMapping = glyphClassTable;
        this.extractSESubState(5, 1, 0, n, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFAttachmentTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        this.initATSubState();
        this.in.seekSet(l);
        int n2 = this.in.readTTFUShort();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " attachment point coverage table offset: " + n2));
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(tTFTableName + " attachment point coverage", l + (long)n2);
        this.seMapping = glyphCoverageTable;
        this.extractSESubState(5, 2, 0, n, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFLigatureCaretTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        int n2;
        this.initATSubState();
        this.in.seekSet(l);
        int n3 = this.in.readTTFUShort();
        int n4 = this.in.readTTFUShort();
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = this.in.readTTFUShort();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " ligature caret coverage table offset: " + n3));
            log.debug((Object)(tTFTableName + " ligature caret ligature glyph count: " + n4));
            for (n2 = 0; n2 < n4; ++n2) {
                log.debug((Object)(tTFTableName + " ligature glyph table offset[" + n2 + "]: " + nArray[n2]));
            }
        }
        GlyphCoverageTable glyphCoverageTable = this.readCoverageTable(tTFTableName + " ligature caret coverage", l + (long)n3);
        this.seMapping = glyphCoverageTable;
        this.extractSESubState(5, 3, 0, n, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkAttachmentTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        this.initATSubState();
        this.in.seekSet(l);
        GlyphClassTable glyphClassTable = this.readClassDefTable(tTFTableName + " glyph class definition table", l);
        this.seMapping = glyphClassTable;
        this.extractSESubState(5, 4, 0, n, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkGlyphsTableFormat1(TTFTableName tTFTableName, int n, long l, int n2) throws IOException {
        int n3;
        this.initATSubState();
        this.in.seekSet(l);
        this.in.skip(2L);
        int n4 = this.in.readTTFUShort();
        long[] lArray = new long[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            lArray[n3] = this.in.readTTFULong();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(tTFTableName + " mark set subtable format: " + n2 + " (glyph sets)"));
            log.debug((Object)(tTFTableName + " mark set class count: " + n4));
            for (n3 = 0; n3 < n4; ++n3) {
                log.debug((Object)(tTFTableName + " mark set coverage table offset[" + n3 + "]: " + lArray[n3]));
            }
        }
        GlyphCoverageTable[] glyphCoverageTableArray = new GlyphCoverageTable[n4];
        for (int i = 0; i < n4; ++i) {
            glyphCoverageTableArray[i] = this.readCoverageTable(tTFTableName + " mark set coverage[" + i + "]", l + lArray[i]);
        }
        GlyphClassTable glyphClassTable = GlyphClassTable.createClassTable(Arrays.asList(glyphCoverageTableArray));
        this.seMapping = glyphClassTable;
        this.extractSESubState(5, 4, 0, n, 0, 1);
        this.resetATSubState();
    }

    private void readGDEFMarkGlyphsTable(TTFTableName tTFTableName, int n, long l) throws IOException {
        this.in.seekSet(l);
        int n2 = this.in.readTTFUShort();
        if (n2 != 1) {
            throw new AdvancedTypographicTableFormatException("unsupported mark glyph sets subtable format: " + n2);
        }
        this.readGDEFMarkGlyphsTableFormat1(tTFTableName, n, l, n2);
    }

    private void readGDEF() throws IOException {
        TTFTableName tTFTableName = TTFTableName.GDEF;
        this.initATState();
        TTFDirTabEntry tTFDirTabEntry = this.ttf.getDirectoryEntry(tTFTableName);
        if (this.gdef != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + ": ignoring duplicate table"));
            }
        } else if (tTFDirTabEntry != null) {
            GlyphDefinitionTable glyphDefinitionTable;
            this.ttf.seekTab(this.in, tTFTableName, 0L);
            long l = this.in.readTTFULong();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " version: " + l / 65536L + "." + l % 65536L));
            }
            int n = this.in.readTTFUShort();
            int n2 = this.in.readTTFUShort();
            int n3 = this.in.readTTFUShort();
            int n4 = this.in.readTTFUShort();
            int n5 = l >= 65538L ? this.in.readTTFUShort() : 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " glyph class definition table offset: " + n));
                log.debug((Object)(tTFTableName + " attachment point list offset: " + n2));
                log.debug((Object)(tTFTableName + " ligature caret list offset: " + n3));
                log.debug((Object)(tTFTableName + " mark attachment class definition table offset: " + n4));
                log.debug((Object)(tTFTableName + " mark glyph set definitions table offset: " + n5));
            }
            int n6 = 0;
            long l2 = tTFDirTabEntry.getOffset();
            if (n != 0) {
                this.readGDEFClassDefTable(tTFTableName, n6++, l2 + (long)n);
            }
            if (n2 != 0) {
                this.readGDEFAttachmentTable(tTFTableName, n6++, l2 + (long)n2);
            }
            if (n3 != 0) {
                this.readGDEFLigatureCaretTable(tTFTableName, n6++, l2 + (long)n3);
            }
            if (n4 != 0) {
                this.readGDEFMarkAttachmentTable(tTFTableName, n6++, l2 + (long)n4);
            }
            if (n5 != 0) {
                this.readGDEFMarkGlyphsTable(tTFTableName, n6++, l2 + (long)n5);
            }
            if ((glyphDefinitionTable = this.constructGDEF()) != null) {
                this.gdef = glyphDefinitionTable;
            }
        }
    }

    private void readGSUB() throws IOException {
        TTFTableName tTFTableName = TTFTableName.GSUB;
        this.initATState();
        TTFDirTabEntry tTFDirTabEntry = this.ttf.getDirectoryEntry(tTFTableName);
        if (this.gpos != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + ": ignoring duplicate table"));
            }
        } else if (tTFDirTabEntry != null) {
            this.ttf.seekTab(this.in, tTFTableName, 0L);
            int n = this.in.readTTFLong();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " version: " + n / 65536 + "." + n % 65536));
            }
            int n2 = this.in.readTTFUShort();
            int n3 = this.in.readTTFUShort();
            int n4 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " script list offset: " + n2));
                log.debug((Object)(tTFTableName + " feature list offset: " + n3));
                log.debug((Object)(tTFTableName + " lookup list offset: " + n4));
            }
            long l = tTFDirTabEntry.getOffset();
            this.readCommonLayoutTables(tTFTableName, l + (long)n2, l + (long)n3, l + (long)n4);
            GlyphSubstitutionTable glyphSubstitutionTable = this.constructGSUB();
            if (glyphSubstitutionTable != null) {
                this.gsub = glyphSubstitutionTable;
            }
        }
    }

    private void readGPOS() throws IOException {
        TTFTableName tTFTableName = TTFTableName.GPOS;
        this.initATState();
        TTFDirTabEntry tTFDirTabEntry = this.ttf.getDirectoryEntry(tTFTableName);
        if (this.gpos != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + ": ignoring duplicate table"));
            }
        } else if (tTFDirTabEntry != null) {
            this.ttf.seekTab(this.in, tTFTableName, 0L);
            int n = this.in.readTTFLong();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " version: " + n / 65536 + "." + n % 65536));
            }
            int n2 = this.in.readTTFUShort();
            int n3 = this.in.readTTFUShort();
            int n4 = this.in.readTTFUShort();
            if (log.isDebugEnabled()) {
                log.debug((Object)(tTFTableName + " script list offset: " + n2));
                log.debug((Object)(tTFTableName + " feature list offset: " + n3));
                log.debug((Object)(tTFTableName + " lookup list offset: " + n4));
            }
            long l = tTFDirTabEntry.getOffset();
            this.readCommonLayoutTables(tTFTableName, l + (long)n2, l + (long)n3, l + (long)n4);
            GlyphPositioningTable glyphPositioningTable = this.constructGPOS();
            if (glyphPositioningTable != null) {
                this.gpos = glyphPositioningTable;
            }
        }
    }

    private GlyphDefinitionTable constructGDEF() {
        GlyphDefinitionTable glyphDefinitionTable = null;
        List list = this.constructGDEFSubtables();
        if (list != null && list.size() > 0) {
            glyphDefinitionTable = new GlyphDefinitionTable(list);
        }
        this.resetATState();
        return glyphDefinitionTable;
    }

    private GlyphSubstitutionTable constructGSUB() {
        List list;
        GlyphSubstitutionTable glyphSubstitutionTable = null;
        Map map = this.constructLookups();
        if (map != null && (list = this.constructGSUBSubtables()) != null && map.size() > 0 && list.size() > 0) {
            glyphSubstitutionTable = new GlyphSubstitutionTable(this.gdef, map, list);
        }
        this.resetATState();
        return glyphSubstitutionTable;
    }

    private GlyphPositioningTable constructGPOS() {
        List list;
        GlyphPositioningTable glyphPositioningTable = null;
        Map map = this.constructLookups();
        if (map != null && (list = this.constructGPOSSubtables()) != null && map.size() > 0 && list.size() > 0) {
            glyphPositioningTable = new GlyphPositioningTable(this.gdef, map, list);
        }
        this.resetATState();
        return glyphPositioningTable;
    }

    private void constructLookupsFeature(Map map, String string, String string2, String string3) {
        Object[] objectArray = (Object[])this.seFeatures.get(string3);
        if (objectArray != null) {
            assert (objectArray.length == 2);
            String string4 = (String)objectArray[0];
            List list = (List)objectArray[1];
            if (string4 != null && list != null && list.size() > 0) {
                GlyphTable.LookupSpec lookupSpec = new GlyphTable.LookupSpec(string, string2, string4);
                map.put(lookupSpec, list);
            }
        }
    }

    private void constructLookupsFeatures(Map map, String string, String string2, List list) {
        for (String string3 : list) {
            this.constructLookupsFeature(map, string, string2, string3);
        }
    }

    private void constructLookupsLanguage(Map map, String string, String string2, Map map2) {
        Object[] objectArray = (Object[])map2.get(string2);
        if (objectArray != null) {
            assert (objectArray.length == 2);
            if (objectArray[0] != null) {
                this.constructLookupsFeature(map, string, string2, (String)objectArray[0]);
            }
            if (objectArray[1] != null) {
                this.constructLookupsFeatures(map, string, string2, (List)objectArray[1]);
            }
        }
    }

    private void constructLookupsLanguages(Map map, String string, List list, Map map2) {
        for (String string2 : list) {
            this.constructLookupsLanguage(map, string, string2, map2);
        }
    }

    private Map constructLookups() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : this.seScripts.keySet()) {
            Object[] objectArray = (Object[])this.seScripts.get(string);
            if (objectArray == null) continue;
            assert (objectArray.length == 3);
            Map map = (Map)objectArray[2];
            if (objectArray[0] != null) {
                this.constructLookupsLanguage(linkedHashMap, string, (String)objectArray[0], map);
            }
            if (objectArray[1] == null) continue;
            this.constructLookupsLanguages(linkedHashMap, string, (List)objectArray[1], map);
        }
        return linkedHashMap;
    }

    private List constructGDEFSubtables() {
        ArrayList<GlyphSubtable> arrayList = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object[] objectArray : this.seSubtables) {
                GlyphSubtable glyphSubtable = this.constructGDEFSubtable(objectArray);
                if (glyphSubtable == null) continue;
                arrayList.add(glyphSubtable);
            }
        }
        return arrayList;
    }

    private GlyphSubtable constructGDEFSubtable(Object[] objectArray) {
        GlyphSubtable glyphSubtable = null;
        assert (objectArray != null && objectArray.length == 8);
        Integer n = (Integer)objectArray[0];
        Integer n2 = (Integer)objectArray[1];
        Integer n3 = (Integer)objectArray[2];
        Integer n4 = (Integer)objectArray[3];
        Integer n5 = (Integer)objectArray[4];
        Integer n6 = (Integer)objectArray[5];
        GlyphMappingTable glyphMappingTable = (GlyphMappingTable)objectArray[6];
        List list = (List)objectArray[7];
        if (n == 5) {
            int n7 = GDEFLookupType.getSubtableType(n2);
            String string = "lu" + n3;
            int n8 = n5;
            int n9 = n4;
            int n10 = n6;
            glyphSubtable = GlyphDefinitionTable.createSubtable(n7, string, n8, n9, n10, glyphMappingTable, list);
        }
        return glyphSubtable;
    }

    private List constructGSUBSubtables() {
        ArrayList<GlyphSubtable> arrayList = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object[] objectArray : this.seSubtables) {
                GlyphSubtable glyphSubtable = this.constructGSUBSubtable(objectArray);
                if (glyphSubtable == null) continue;
                arrayList.add(glyphSubtable);
            }
        }
        return arrayList;
    }

    private GlyphSubtable constructGSUBSubtable(Object[] objectArray) {
        GlyphSubtable glyphSubtable = null;
        assert (objectArray != null && objectArray.length == 8);
        Integer n = (Integer)objectArray[0];
        Integer n2 = (Integer)objectArray[1];
        Integer n3 = (Integer)objectArray[2];
        Integer n4 = (Integer)objectArray[3];
        Integer n5 = (Integer)objectArray[4];
        Integer n6 = (Integer)objectArray[5];
        GlyphCoverageTable glyphCoverageTable = (GlyphCoverageTable)objectArray[6];
        List list = (List)objectArray[7];
        if (n == 1) {
            int n7 = GSUBLookupType.getSubtableType(n2);
            String string = "lu" + n3;
            int n8 = n5;
            int n9 = n4;
            int n10 = n6;
            glyphSubtable = GlyphSubstitutionTable.createSubtable(n7, string, n8, n9, n10, glyphCoverageTable, list);
        }
        return glyphSubtable;
    }

    private List constructGPOSSubtables() {
        ArrayList<GlyphSubtable> arrayList = new ArrayList<GlyphSubtable>();
        if (this.seSubtables != null) {
            for (Object[] objectArray : this.seSubtables) {
                GlyphSubtable glyphSubtable = this.constructGPOSSubtable(objectArray);
                if (glyphSubtable == null) continue;
                arrayList.add(glyphSubtable);
            }
        }
        return arrayList;
    }

    private GlyphSubtable constructGPOSSubtable(Object[] objectArray) {
        GlyphSubtable glyphSubtable = null;
        assert (objectArray != null && objectArray.length == 8);
        Integer n = (Integer)objectArray[0];
        Integer n2 = (Integer)objectArray[1];
        Integer n3 = (Integer)objectArray[2];
        Integer n4 = (Integer)objectArray[3];
        Integer n5 = (Integer)objectArray[4];
        Integer n6 = (Integer)objectArray[5];
        GlyphCoverageTable glyphCoverageTable = (GlyphCoverageTable)objectArray[6];
        List list = (List)objectArray[7];
        if (n == 2) {
            int n7 = GSUBLookupType.getSubtableType(n2);
            String string = "lu" + n3;
            int n8 = n5;
            int n9 = n4;
            int n10 = n6;
            glyphSubtable = GlyphPositioningTable.createSubtable(n7, string, n8, n9, n10, glyphCoverageTable, list);
        }
        return glyphSubtable;
    }

    private void initATState() {
        this.seScripts = new LinkedHashMap();
        this.seLanguages = new LinkedHashMap();
        this.seFeatures = new LinkedHashMap();
        this.seSubtables = new ArrayList();
        this.resetATSubState();
    }

    private void resetATState() {
        this.seScripts = null;
        this.seLanguages = null;
        this.seFeatures = null;
        this.seSubtables = null;
        this.resetATSubState();
    }

    private void initATSubState() {
        this.seMapping = null;
        this.seEntries = new ArrayList();
    }

    private void extractSESubState(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.seEntries != null && (n == 5 || this.seEntries.size() > 0) && this.seSubtables != null) {
            Integer n7 = n;
            Integer n8 = n2;
            Integer n9 = n4;
            Integer n10 = n3;
            Integer n11 = n5;
            Integer n12 = n6;
            this.seSubtables.add(new Object[]{n7, n8, n9, n10, n11, n12, this.seMapping, this.seEntries});
        }
    }

    private void resetATSubState() {
        this.seMapping = null;
        this.seEntries = null;
    }

    private void resetATStateAll() {
        this.resetATState();
        this.gdef = null;
        this.gsub = null;
        this.gpos = null;
    }

    private String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray == null || nArray.length == 0) {
            stringBuffer.append('-');
        } else {
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (!bl) {
                    stringBuffer.append(' ');
                } else {
                    bl = false;
                }
                stringBuffer.append(nArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    static final class LookupFlag {
        static final int RIGHT_TO_LEFT = 1;
        static final int IGNORE_BASE_GLYPHS = 2;
        static final int IGNORE_LIGATURE = 4;
        static final int IGNORE_MARKS = 8;
        static final int USE_MARK_FILTERING_SET = 16;
        static final int MARK_ATTACHMENT_TYPE = 65280;

        private LookupFlag() {
        }

        public static String toString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            if ((n & 1) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('|');
                }
                stringBuffer.append("RightToLeft");
            }
            if ((n & 2) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('|');
                }
                stringBuffer.append("IgnoreBaseGlyphs");
            }
            if ((n & 4) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('|');
                }
                stringBuffer.append("IgnoreLigature");
            }
            if ((n & 8) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('|');
                }
                stringBuffer.append("IgnoreMarks");
            }
            if ((n & 0x10) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append('|');
                }
                stringBuffer.append("UseMarkFilteringSet");
            }
            if (stringBuffer.length() == 0) {
                stringBuffer.append('-');
            }
            return stringBuffer.toString();
        }
    }

    static final class GPOSLookupType {
        static final int SINGLE = 1;
        static final int PAIR = 2;
        static final int CURSIVE = 3;
        static final int MARK_TO_BASE = 4;
        static final int MARK_TO_LIGATURE = 5;
        static final int MARK_TO_MARK = 6;
        static final int CONTEXTUAL = 7;
        static final int CHAINED_CONTEXTUAL = 8;
        static final int EXTENSION = 9;

        private GPOSLookupType() {
        }

        public static String toString(int n) {
            String string;
            switch (n) {
                case 1: {
                    string = "Single";
                    break;
                }
                case 2: {
                    string = "Pair";
                    break;
                }
                case 3: {
                    string = "Cursive";
                    break;
                }
                case 4: {
                    string = "MarkToBase";
                    break;
                }
                case 5: {
                    string = "MarkToLigature";
                    break;
                }
                case 6: {
                    string = "MarkToMark";
                    break;
                }
                case 7: {
                    string = "Contextual";
                    break;
                }
                case 8: {
                    string = "ChainedContextual";
                    break;
                }
                case 9: {
                    string = "Extension";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            return string;
        }
    }

    static final class GSUBLookupType {
        static final int SINGLE = 1;
        static final int MULTIPLE = 2;
        static final int ALTERNATE = 3;
        static final int LIGATURE = 4;
        static final int CONTEXTUAL = 5;
        static final int CHAINED_CONTEXTUAL = 6;
        static final int EXTENSION = 7;
        static final int REVERSE_CHAINED_SINGLE = 8;

        private GSUBLookupType() {
        }

        public static int getSubtableType(int n) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                case 6: {
                    n2 = 6;
                    break;
                }
                case 7: {
                    n2 = 7;
                    break;
                }
                case 8: {
                    n2 = 8;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            return n2;
        }

        public static String toString(int n) {
            String string;
            switch (n) {
                case 1: {
                    string = "Single";
                    break;
                }
                case 2: {
                    string = "Multiple";
                    break;
                }
                case 3: {
                    string = "Alternate";
                    break;
                }
                case 4: {
                    string = "Ligature";
                    break;
                }
                case 5: {
                    string = "Contextual";
                    break;
                }
                case 6: {
                    string = "ChainedContextual";
                    break;
                }
                case 7: {
                    string = "Extension";
                    break;
                }
                case 8: {
                    string = "ReverseChainedSingle";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            return string;
        }
    }

    static final class GDEFLookupType {
        static final int GLYPH_CLASS = 1;
        static final int ATTACHMENT_POINT = 2;
        static final int LIGATURE_CARET = 3;
        static final int MARK_ATTACHMENT = 4;

        private GDEFLookupType() {
        }

        public static int getSubtableType(int n) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            return n2;
        }

        public static String toString(int n) {
            String string;
            switch (n) {
                case 1: {
                    string = "GlyphClass";
                    break;
                }
                case 2: {
                    string = "AttachmentPoint";
                    break;
                }
                case 3: {
                    string = "LigatureCaret";
                    break;
                }
                case 4: {
                    string = "MarkAttachment";
                    break;
                }
                default: {
                    string = "?";
                }
            }
            return string;
        }
    }
}

