/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;

public final class GlyphClassTable
extends GlyphMappingTable
implements GlyphClassMapping {
    public static final int GLYPH_CLASS_TYPE_EMPTY = 0;
    public static final int GLYPH_CLASS_TYPE_MAPPED = 1;
    public static final int GLYPH_CLASS_TYPE_RANGE = 2;
    public static final int GLYPH_CLASS_TYPE_COVERAGE_SET = 3;
    private GlyphClassMapping cm;

    private GlyphClassTable(GlyphClassMapping glyphClassMapping) {
        assert (glyphClassMapping != null);
        assert (glyphClassMapping instanceof GlyphMappingTable);
        this.cm = glyphClassMapping;
    }

    public int getType() {
        return ((GlyphMappingTable)((Object)this.cm)).getType();
    }

    public List getEntries() {
        return ((GlyphMappingTable)((Object)this.cm)).getEntries();
    }

    public int getClassSize(int n) {
        return this.cm.getClassSize(n);
    }

    public int getClassIndex(int n, int n2) {
        return this.cm.getClassIndex(n, n2);
    }

    public static GlyphClassTable createClassTable(List list) {
        GlyphMappingTable glyphMappingTable = list == null || list.size() == 0 ? new EmptyClassTable(list) : (GlyphClassTable.isMappedClass(list) ? new MappedClassTable(list) : (GlyphClassTable.isRangeClass(list) ? new RangeClassTable(list) : (GlyphClassTable.isCoverageSetClass(list) ? new CoverageSetClassTable(list) : null)));
        assert (glyphMappingTable != null) : "unknown class type";
        return new GlyphClassTable((GlyphClassMapping)((Object)glyphMappingTable));
    }

    private static boolean isMappedClass(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (Object e : list) {
            if (e instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static boolean isRangeClass(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (Object e : list) {
            if (e instanceof GlyphMappingTable.MappingRange) continue;
            return false;
        }
        return true;
    }

    private static boolean isCoverageSetClass(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (Object e : list) {
            if (e instanceof GlyphCoverageTable) continue;
            return false;
        }
        return true;
    }

    private static class CoverageSetClassTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphClassMapping {
        public CoverageSetClassTable(List list) {
            throw new UnsupportedOperationException("coverage set class table not yet supported");
        }

        public int getType() {
            return 3;
        }

        public int getClassSize(int n) {
            return 0;
        }

        public int getClassIndex(int n, int n2) {
            return -1;
        }
    }

    private static class RangeClassTable
    extends GlyphMappingTable.RangeMappingTable
    implements GlyphClassMapping {
        public RangeClassTable(List list) {
            super(list);
        }

        public int getMappedIndex(int n, int n2, int n3) {
            return n3;
        }

        public int getClassSize(int n) {
            return this.getMappingSize();
        }

        public int getClassIndex(int n, int n2) {
            return this.getMappedIndex(n);
        }
    }

    private static class MappedClassTable
    extends GlyphMappingTable.MappedMappingTable
    implements GlyphClassMapping {
        private int firstGlyph;
        private int[] gca;
        private int gcMax = -1;

        public MappedClassTable(List list) {
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(this.firstGlyph);
            if (this.gca != null) {
                int n = this.gca.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.gca[i]);
                }
            }
            return arrayList;
        }

        public int getMappingSize() {
            return this.gcMax + 1;
        }

        public int getMappedIndex(int n) {
            int n2 = n - this.firstGlyph;
            if (n2 >= 0 && n2 < this.gca.length) {
                return this.gca[n2];
            }
            return -1;
        }

        public int getClassSize(int n) {
            return this.getMappingSize();
        }

        public int getClassIndex(int n, int n2) {
            return this.getMappedIndex(n);
        }

        private void populate(List list) {
            Iterator iterator = list.iterator();
            int n = 0;
            if (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Integer) {
                    n = (Integer)e;
                } else {
                    throw new AdvancedTypographicTableFormatException("illegal entry, first entry must be Integer denoting first glyph value, but is: " + e);
                }
            }
            int n2 = 0;
            int n3 = list.size() - 1;
            int n4 = -1;
            int[] nArray = new int[n3];
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Integer) {
                    int n5 = (Integer)e;
                    nArray[n2++] = n5;
                    if (n5 <= n4) continue;
                    n4 = n5;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal mapping entry, must be Integer: " + e);
            }
            assert (n2 == n3);
            assert (this.gca == null);
            this.firstGlyph = n;
            this.gca = nArray;
            this.gcMax = n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{ firstGlyph = " + this.firstGlyph + ", classes = {");
            int n = this.gca.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(Integer.toString(this.gca[i]));
            }
            stringBuffer.append("} }");
            return stringBuffer.toString();
        }
    }

    private static class EmptyClassTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphClassMapping {
        public EmptyClassTable(List list) {
            super(list);
        }

        public int getClassSize(int n) {
            return 0;
        }

        public int getClassIndex(int n, int n2) {
            return -1;
        }
    }
}

