/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.fop.area.inline.Anchor;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class InlineRun {
    private InlineArea inline;
    private int[] levels;
    private int minLevel;
    private int maxLevel;
    private int reversals;

    public InlineRun(InlineArea inlineArea, int[] nArray) {
        assert (inlineArea != null);
        assert (nArray != null);
        this.inline = inlineArea;
        this.levels = nArray;
        this.setMinMax(nArray);
    }

    public InlineRun(InlineArea inlineArea, int n, int n2) {
        this(inlineArea, InlineRun.makeLevels(n, n2));
    }

    public InlineArea getInline() {
        return this.inline;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    private void setMinMax(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        if (nArray != null && nArray.length > 0) {
            for (int n3 : nArray) {
                if (n3 < n) {
                    n = n3;
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
        } else {
            n2 = -1;
            n = -1;
        }
        this.minLevel = n;
        this.maxLevel = n2;
    }

    public boolean isHomogenous() {
        return this.minLevel == this.maxLevel;
    }

    public List split() {
        Vector<InlineRun> vector = new Vector<InlineRun>();
        int n = 0;
        int n2 = this.levels.length;
        while (n < n2) {
            int n3;
            int n4;
            int n5 = this.levels[n];
            for (n4 = n3 = n; n4 < n2 && this.levels[n4] == n5; ++n4) {
            }
            if (n3 < n4) {
                vector.add(new InlineRun(this.inline, n5, n4 - n3));
            }
            n = n4;
        }
        assert (vector.size() < 2) : "heterogeneous inlines not yet supported!!";
        return vector;
    }

    public void updateMinMax(int[] nArray) {
        if (this.minLevel < nArray[0]) {
            nArray[0] = this.minLevel;
        }
        if (this.maxLevel > nArray[1]) {
            nArray[1] = this.maxLevel;
        }
    }

    public boolean maybeNeedsMirroring() {
        return this.minLevel == this.maxLevel && (this.minLevel & 1) != 0;
    }

    public void reverse() {
        ++this.reversals;
    }

    public void maybeReverseWord(boolean bl) {
        WordArea wordArea;
        if (this.inline instanceof WordArea && !(wordArea = (WordArea)this.inline).isReversed()) {
            if ((this.reversals & 1) != 0) {
                wordArea.reverse(bl);
            } else if (bl && this.maybeNeedsMirroring()) {
                wordArea.mirror();
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof InlineRun) {
            InlineRun inlineRun = (InlineRun)object;
            if (inlineRun.inline != this.inline) {
                return false;
            }
            if (inlineRun.minLevel != this.minLevel) {
                return false;
            }
            if (inlineRun.maxLevel != this.maxLevel) {
                return false;
            }
            if (inlineRun.levels != null && this.levels != null) {
                if (inlineRun.levels.length != this.levels.length) {
                    return false;
                }
                int n = this.levels.length;
                for (int i = 0; i < n; ++i) {
                    if (inlineRun.levels[i] == this.levels[i]) continue;
                    return false;
                }
                return true;
            }
            return inlineRun.levels == null && this.levels == null;
        }
        return false;
    }

    public int hashCode() {
        int n = this.inline != null ? this.inline.hashCode() : 0;
        n = (n ^ this.minLevel) + (n << 19);
        n = (n ^ this.maxLevel) + (n << 11);
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("RR: { type = '");
        String string = null;
        if (this.inline instanceof WordArea) {
            n = 87;
            string = ((WordArea)this.inline).getWord();
        } else if (this.inline instanceof SpaceArea) {
            n = 83;
            string = ((SpaceArea)this.inline).getSpace();
        } else if (this.inline instanceof Anchor) {
            n = 65;
        } else if (this.inline instanceof Leader) {
            n = 76;
        } else if (this.inline instanceof Space) {
            n = 83;
        } else if (this.inline instanceof UnresolvedPageNumber) {
            n = 35;
            string = ((UnresolvedPageNumber)this.inline).getText();
        } else {
            n = this.inline instanceof InlineBlockParent ? 66 : (this.inline instanceof InlineViewport ? 86 : (this.inline instanceof InlineParent ? 73 : 63));
        }
        stringBuffer.append((char)n);
        stringBuffer.append("', levels = '");
        stringBuffer.append(this.generateLevels(this.levels));
        stringBuffer.append("', min = ");
        stringBuffer.append(this.minLevel);
        stringBuffer.append(", max = ");
        stringBuffer.append(this.maxLevel);
        stringBuffer.append(", reversals = ");
        stringBuffer.append(this.reversals);
        stringBuffer.append(", content = <");
        stringBuffer.append(CharUtilities.toNCRefs(string));
        stringBuffer.append("> }");
        return stringBuffer.toString();
    }

    private String generateLevels(int[] nArray) {
        StringBuffer stringBuffer;
        block7: {
            int n;
            int n2;
            stringBuffer = new StringBuffer();
            int n3 = -1;
            int n4 = nArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                n = nArray[n2];
                if (n <= n3) continue;
                n3 = n;
            }
            if (n3 < 0) break block7;
            if (n3 < 10) {
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuffer.append((char)(48 + nArray[n2]));
                }
            } else {
                n2 = 1;
                for (n = 0; n < n4; ++n) {
                    if (n2 != 0) {
                        n2 = 0;
                    } else {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(nArray[n]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static int[] makeLevels(int n, int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, n);
        return nArray;
    }
}

