/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.complexscripts.bidi.InlineRun;
import org.apache.fop.complexscripts.bidi.UnflattenProcessor;
import org.apache.fop.fo.pagination.PageSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BidiResolver {
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    private BidiResolver() {
    }

    public static void resolveInlineDirectionality(PageSequence pageSequence) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("BD: RESOLVE: " + pageSequence));
        }
        List list = BidiResolver.pruneEmptyRanges(pageSequence.collectDelimitedTextRanges(new Stack()));
        BidiResolver.resolveInlineDirectionality(list);
    }

    public static void reorder(LineArea lineArea) {
        int n;
        List list = BidiResolver.collectRuns(lineArea.getInlineAreas(), new Vector());
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: INPUT:", list);
        }
        list = BidiResolver.splitRuns(list);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: SPLIT INLINES:", list);
        }
        int[] nArray = BidiResolver.computeMinMaxLevel(list, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("BD: REORDER: { min = " + nArray[0] + ", max = " + nArray[1] + "}"));
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n3 > 0) {
            int n4;
            int n5 = n4 = (n2 & 1) == 0 ? n2 + 1 : n2;
            for (n = n3; n >= n4; --n) {
                list = BidiResolver.reorderRuns(list, n);
            }
        }
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED RUNS:", list);
        }
        n = 1;
        BidiResolver.reverseWords(list, n != 0);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED WORDS:", list);
        }
        BidiResolver.replaceInlines(lineArea, BidiResolver.replicateSplitWords(list));
    }

    private static void resolveInlineDirectionality(List list) {
        for (DelimitedTextRange delimitedTextRange : list) {
            delimitedTextRange.resolve();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)delimitedTextRange);
        }
    }

    private static List collectRuns(List list, List list2) {
        for (InlineArea inlineArea : list) {
            list2 = inlineArea.collectInlineRuns(list2);
        }
        return list2;
    }

    private static List splitRuns(List vector) {
        Vector<InlineRun> vector2 = new Vector<InlineRun>();
        for (InlineRun inlineRun : vector) {
            if (inlineRun.isHomogenous()) {
                vector2.add(inlineRun);
                continue;
            }
            vector2.addAll(inlineRun.split());
        }
        if (!vector2.equals(vector)) {
            vector = vector2;
        }
        return vector;
    }

    private static int[] computeMinMaxLevel(List list, int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        }
        for (InlineRun inlineRun : list) {
            inlineRun.updateMinMax(nArray);
        }
        return nArray;
    }

    private static List reorderRuns(List vector, int n) {
        assert (n >= 0);
        Vector<InlineRun> vector2 = new Vector<InlineRun>();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            InlineRun inlineRun;
            int n4;
            InlineRun inlineRun2 = (InlineRun)vector.get(i);
            if (inlineRun2.getMinLevel() < n) {
                vector2.add(inlineRun2);
                continue;
            }
            for (n4 = n3 = i; n4 < n2 && (inlineRun = (InlineRun)vector.get(n4)).getMinLevel() >= n; ++n4) {
            }
            if (n3 < n4) {
                vector2.addAll(BidiResolver.reverseRuns(vector, n3, n4));
            }
            i = n4 - 1;
        }
        if (!vector2.equals(vector)) {
            vector = vector2;
        }
        return vector;
    }

    private static List reverseRuns(List list, int n, int n2) {
        int n3 = n2 - n;
        Vector<InlineRun> vector = new Vector<InlineRun>(n3);
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n3 - i - 1;
                InlineRun inlineRun = (InlineRun)list.get(n + n4);
                inlineRun.reverse();
                vector.add(inlineRun);
            }
        }
        return vector;
    }

    private static void reverseWords(List list, boolean bl) {
        for (InlineRun inlineRun : list) {
            inlineRun.maybeReverseWord(bl);
        }
    }

    private static List replicateSplitWords(List list) {
        return list;
    }

    private static void replaceInlines(LineArea lineArea, List list) {
        ArrayList<InlineArea> arrayList = new ArrayList<InlineArea>();
        for (InlineRun inlineRun : list) {
            arrayList.add(inlineRun.getInline());
        }
        lineArea.setInlineAreas(BidiResolver.unflattenInlines(arrayList));
    }

    private static List unflattenInlines(List<InlineArea> list) {
        return new UnflattenProcessor(list).unflatten();
    }

    private static void dumpRuns(String string, List list) {
        log.debug((Object)string);
        for (InlineRun inlineRun : list) {
            log.debug((Object)inlineRun);
        }
    }

    private static List pruneEmptyRanges(Stack stack) {
        Vector<DelimitedTextRange> vector = new Vector<DelimitedTextRange>();
        for (DelimitedTextRange delimitedTextRange : stack) {
            if (delimitedTextRange.isEmpty()) continue;
            vector.add(delimitedTextRange);
        }
        return vector;
    }
}

