/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.awt.viewer.Renderable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class InputHandler
implements ErrorListener,
Renderable {
    protected File sourcefile;
    private File stylesheet;
    private Vector xsltParams;
    private EntityResolver entityResolver = null;
    private URIResolver uriResolver = null;
    protected Log log = LogFactory.getLog(InputHandler.class);

    public InputHandler(File file, File file2, Vector vector) {
        this.sourcefile = file;
        this.stylesheet = file2;
        this.xsltParams = vector;
    }

    public InputHandler(File file) {
        this.sourcefile = file;
    }

    public void renderTo(FOUserAgent fOUserAgent, String string, OutputStream outputStream) throws FOPException {
        Object object;
        FopFactory fopFactory = fOUserAgent.getFactory();
        Fop fop = outputStream != null ? fopFactory.newFop(string, fOUserAgent, outputStream) : fopFactory.newFop(string, fOUserAgent);
        if (fop.getUserAgent().getBaseURL() == null && this.sourcefile != null) {
            object = null;
            try {
                object = new File(this.sourcefile.getAbsolutePath()).getParentFile().toURI().toURL().toExternalForm();
            }
            catch (Exception exception) {
                object = "";
            }
            fop.getUserAgent().setBaseURL((String)object);
        }
        object = new SAXResult(fop.getDefaultHandler());
        this.transformTo((Result)object);
    }

    public void renderTo(FOUserAgent fOUserAgent, String string) throws FOPException {
        this.renderTo(fOUserAgent, string, null);
    }

    public void transformTo(OutputStream outputStream) throws FOPException {
        StreamResult streamResult = new StreamResult(outputStream);
        this.transformTo(streamResult);
    }

    protected Source createMainSource() {
        Source source;
        String string;
        InputStream inputStream;
        if (this.sourcefile != null) {
            try {
                inputStream = new FileInputStream(this.sourcefile);
                string = this.sourcefile.toURI().toASCIIString();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return new StreamSource(this.sourcefile);
            }
        } else {
            inputStream = System.in;
            string = null;
        }
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            XMLReader xMLReader = this.getXMLReader();
            if (this.entityResolver != null) {
                xMLReader.setEntityResolver(this.entityResolver);
            }
            source = new SAXSource(xMLReader, inputSource);
        }
        catch (SAXException sAXException) {
            source = this.sourcefile != null ? new StreamSource(this.sourcefile) : new StreamSource(inputStream, string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            source = this.sourcefile != null ? new StreamSource(this.sourcefile) : new StreamSource(inputStream, string);
        }
        return source;
    }

    public void createCatalogResolver(FOUserAgent fOUserAgent) {
        String[] stringArray = new String[]{"org.apache.xml.resolver.tools.CatalogResolver", "com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver"};
        ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(fOUserAgent.getEventBroadcaster());
        Class<?> clazz = null;
        for (int i = 0; i < stringArray.length && clazz == null; ++i) {
            try {
                clazz = Class.forName(stringArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            resourceEventProducer.catalogResolverNotFound(this);
            return;
        }
        try {
            this.entityResolver = (EntityResolver)clazz.newInstance();
            this.uriResolver = (URIResolver)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.log.error((Object)("Error creating the catalog resolver: " + instantiationException.getMessage()));
            resourceEventProducer.catalogResolverNotCreated(this, instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.error((Object)("Error creating the catalog resolver: " + illegalAccessException.getMessage()));
            resourceEventProducer.catalogResolverNotCreated(this, illegalAccessException.getMessage());
        }
    }

    protected Source createXSLTSource() {
        Source source = null;
        if (this.stylesheet != null) {
            if (this.entityResolver != null) {
                try {
                    InputSource inputSource = new InputSource(this.stylesheet.getPath());
                    XMLReader xMLReader = this.getXMLReader();
                    xMLReader.setEntityResolver(this.entityResolver);
                    source = new SAXSource(xMLReader, inputSource);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            if (source == null) {
                source = new StreamSource(this.stylesheet);
            }
        }
        return source;
    }

    private XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        sAXParserFactory.setFeature("http://apache.org/xml/features/xinclude", true);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        return xMLReader;
    }

    protected void transformTo(Result result) throws FOPException {
        try {
            Transformer transformer;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Source source = this.createXSLTSource();
            if (source == null) {
                transformer = transformerFactory.newTransformer();
            } else {
                transformer = transformerFactory.newTransformer(source);
                if (this.xsltParams != null) {
                    for (int i = 0; i < this.xsltParams.size(); i += 2) {
                        transformer.setParameter((String)this.xsltParams.elementAt(i), (String)this.xsltParams.elementAt(i + 1));
                    }
                }
                if (this.uriResolver != null) {
                    transformer.setURIResolver(this.uriResolver);
                }
            }
            transformer.setErrorListener(this);
            Source source2 = this.createMainSource();
            transformer.transform(source2, result);
        }
        catch (Exception exception) {
            throw new FOPException(exception);
        }
    }

    public void warning(TransformerException transformerException) {
        this.log.warn((Object)transformerException.getLocalizedMessage());
    }

    public void error(TransformerException transformerException) {
        this.log.error((Object)transformerException.toString());
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }
}

