/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.Arrays;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class TextArea
extends AbstractTextArea {
    private static final long serialVersionUID = 7315900267242540809L;

    public TextArea() {
    }

    public TextArea(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public void removeText() {
        this.inlines.clear();
    }

    public void addWord(String string, int n) {
        this.addWord(string, 0, null, null, null, n);
    }

    public void addWord(String string, int n, int n2) {
        this.addWord(string, 0, null, this.makeLevels(n2, string.length()), null, n);
    }

    public void addWord(String string, int n, int[] nArray, int[] nArray2, int[][] nArray3, int n2) {
        int n3 = TextArea.findMinLevel(nArray2);
        WordArea wordArea = new WordArea(n2, n3, string, nArray, nArray2, nArray3);
        wordArea.setIPD(n);
        this.addChildArea(wordArea);
        wordArea.setParentArea(this);
        this.updateLevel(n3);
    }

    public void addSpace(char c, int n, boolean bl, int n2, int n3) {
        SpaceArea spaceArea = new SpaceArea(n2, n3, c, bl);
        spaceArea.setIPD(n);
        this.addChildArea(spaceArea);
        spaceArea.setParentArea(this);
        this.updateLevel(n3);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (InlineArea inlineArea : this.inlines) {
            if (inlineArea instanceof WordArea) {
                stringBuffer.append(((WordArea)inlineArea).getWord());
                continue;
            }
            stringBuffer.append(((SpaceArea)inlineArea).getSpace());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" {text=\"");
        stringBuffer.append(CharUtilities.toNCRefs(this.getText()));
        stringBuffer.append("\"");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void updateLevel(int n) {
        if (n >= 0) {
            int n2 = this.getBidiLevel();
            if (n2 >= 0) {
                if (n < n2) {
                    this.setBidiLevel(n);
                }
            } else {
                this.setBidiLevel(n);
            }
        }
    }

    private static int findMinLevel(int[] nArray) {
        if (nArray != null) {
            int n = Integer.MAX_VALUE;
            for (int n2 : nArray) {
                if (n2 < 0 || n2 >= n) continue;
                n = n2;
            }
            if (n == Integer.MAX_VALUE) {
                return -1;
            }
            return n;
        }
        return -1;
    }

    private int[] makeLevels(int n, int n2) {
        if (n >= 0) {
            int[] nArray = new int[n2];
            Arrays.fill(nArray, n);
            return nArray;
        }
        return null;
    }
}

