/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.io.Serializable;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;
import org.apache.fop.complexscripts.bidi.InlineRun;

public class InlineArea
extends Area {
    private static final long serialVersionUID = -8940066479810170980L;
    protected int blockProgressionOffset = 0;
    private Area parentArea = null;
    private int storedIPDVariation = 0;
    protected InlineAdjustingInfo adjustingInfo = null;

    public InlineArea() {
        this(0, -1);
    }

    protected InlineArea(int n, int n2) {
        this.blockProgressionOffset = n;
        this.setBidiLevel(n2);
    }

    public InlineAdjustingInfo getAdjustingInfo() {
        return this.adjustingInfo;
    }

    public void setAdjustingInfo(int n, int n2, int n3) {
        this.adjustingInfo = new InlineAdjustingInfo(n, n2, n3);
    }

    public void setAdjustment(int n) {
        if (this.adjustingInfo != null) {
            this.adjustingInfo.adjustment = n;
        }
    }

    public void increaseIPD(int n) {
        this.ipd += n;
    }

    public void setBlockProgressionOffset(int n) {
        this.blockProgressionOffset = n;
    }

    public int getBlockProgressionOffset() {
        return this.blockProgressionOffset;
    }

    public void setParentArea(Area area) {
        this.parentArea = area;
    }

    public Area getParentArea() {
        return this.parentArea;
    }

    public void addChildArea(Area area) {
        super.addChildArea(area);
        if (area instanceof InlineArea) {
            ((InlineArea)area).setParentArea(this);
        }
    }

    public boolean hasUnderline() {
        return this.getTraitAsBoolean(Trait.UNDERLINE);
    }

    public boolean hasOverline() {
        return this.getTraitAsBoolean(Trait.OVERLINE);
    }

    public boolean hasLineThrough() {
        return this.getTraitAsBoolean(Trait.LINETHROUGH);
    }

    public boolean isBlinking() {
        return this.getTraitAsBoolean(Trait.BLINK);
    }

    public boolean applyVariationFactor(double d, int n, int n2) {
        if (this.adjustingInfo != null) {
            this.setIPD(this.getIPD() + this.adjustingInfo.applyVariationFactor(d));
        }
        return false;
    }

    public void handleIPDVariation(int n) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling IPD variation for " + this.getClass().getSimpleName() + ": increase by " + n + " mpt."));
        }
        this.increaseIPD(n);
        this.notifyIPDVariation(n);
    }

    protected void notifyIPDVariation(int n) {
        if (this.getParentArea() instanceof InlineArea) {
            ((InlineArea)this.getParentArea()).handleIPDVariation(n);
        } else if (this.getParentArea() instanceof LineArea) {
            ((LineArea)this.getParentArea()).handleIPDVariation(n);
        } else if (this.getParentArea() == null) {
            this.storedIPDVariation += n;
        }
    }

    int getVirtualOffset() {
        return this.getBlockProgressionOffset();
    }

    int getVirtualBPD() {
        return this.getBPD();
    }

    public List collectInlineRuns(List list) {
        assert (list != null);
        list.add(new InlineRun(this, new int[]{this.getBidiLevel()}));
        return list;
    }

    public boolean isAncestorOrSelf(InlineArea inlineArea) {
        return inlineArea == this || this.isAncestor(inlineArea);
    }

    public boolean isAncestor(InlineArea inlineArea) {
        Area area = this.getParentArea();
        while (area != null) {
            if (area == inlineArea) {
                return true;
            }
            if (area instanceof InlineArea) {
                area = ((InlineArea)area).getParentArea();
                continue;
            }
            area = null;
        }
        return false;
    }

    protected class InlineAdjustingInfo
    implements Serializable {
        private static final long serialVersionUID = -5601387735459712149L;
        protected int availableStretch;
        protected int availableShrink;
        protected int adjustment;

        protected InlineAdjustingInfo(int n, int n2, int n3) {
            this.availableStretch = n;
            this.availableShrink = n2;
            this.adjustment = n3;
        }

        protected int applyVariationFactor(double d) {
            int n = this.adjustment;
            this.adjustment = (int)((double)this.adjustment * d);
            return this.adjustment - n;
        }
    }
}

