/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Color;
import java.io.Serializable;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.util.ColorUtil;
import org.apache.xmlgraphics.image.loader.ImageInfo;

public final class Trait
implements Serializable {
    private static final long serialVersionUID = 3234280285391611437L;
    public static final Integer INTERNAL_LINK = 1;
    public static final Integer EXTERNAL_LINK = 2;
    public static final Integer FONT = 3;
    public static final Integer FONT_SIZE = 4;
    public static final Integer COLOR = 7;
    public static final Integer PROD_ID = 8;
    public static final Integer BACKGROUND = 9;
    public static final Integer UNDERLINE = 10;
    public static final Integer OVERLINE = 11;
    public static final Integer LINETHROUGH = 12;
    public static final Integer BORDER_START = 15;
    public static final Integer BORDER_END = 16;
    public static final Integer BORDER_BEFORE = 17;
    public static final Integer BORDER_AFTER = 18;
    public static final Integer PADDING_START = 19;
    public static final Integer PADDING_END = 20;
    public static final Integer PADDING_BEFORE = 21;
    public static final Integer PADDING_AFTER = 22;
    public static final Integer SPACE_START = 23;
    public static final Integer SPACE_END = 24;
    public static final Integer START_INDENT = 27;
    public static final Integer END_INDENT = 28;
    public static final Integer SPACE_BEFORE = 29;
    public static final Integer SPACE_AFTER = 30;
    public static final Integer IS_REFERENCE_AREA = 31;
    public static final Integer IS_VIEWPORT_AREA = 32;
    public static final Integer BLINK = 33;
    public static final Integer UNDERLINE_COLOR = 34;
    public static final Integer OVERLINE_COLOR = 35;
    public static final Integer LINETHROUGH_COLOR = 36;
    public static final Integer STRUCTURE_TREE_ELEMENT = 37;
    public static final Integer WRITING_MODE = 38;
    public static final Integer INLINE_PROGRESSION_DIRECTION = 39;
    public static final Integer BLOCK_PROGRESSION_DIRECTION = 40;
    public static final Integer COLUMN_PROGRESSION_DIRECTION = 41;
    public static final Integer SHIFT_DIRECTION = 42;
    public static final int MAX_TRAIT_KEY = 42;
    private static final TraitInfo[] TRAIT_INFO = new TraitInfo[43];

    private Trait() {
    }

    private static void put(Integer n, TraitInfo traitInfo) {
        Trait.TRAIT_INFO[n.intValue()] = traitInfo;
    }

    public static String getTraitName(Object object) {
        return TRAIT_INFO[(Integer)object].getName();
    }

    public static Class getTraitClass(Object object) {
        return TRAIT_INFO[(Integer)object].getClazz();
    }

    static {
        Trait.put(STRUCTURE_TREE_ELEMENT, new TraitInfo("structure-tree-element", String.class));
        Trait.put(INTERNAL_LINK, new TraitInfo("internal-link", InternalLink.class));
        Trait.put(EXTERNAL_LINK, new TraitInfo("external-link", ExternalLink.class));
        Trait.put(FONT, new TraitInfo("font", FontTriplet.class));
        Trait.put(FONT_SIZE, new TraitInfo("font-size", Integer.class));
        Trait.put(COLOR, new TraitInfo("color", Color.class));
        Trait.put(PROD_ID, new TraitInfo("prod-id", String.class));
        Trait.put(BACKGROUND, new TraitInfo("background", Background.class));
        Trait.put(UNDERLINE, new TraitInfo("underline-score", Boolean.class));
        Trait.put(UNDERLINE_COLOR, new TraitInfo("underline-score-color", Color.class));
        Trait.put(OVERLINE, new TraitInfo("overline-score", Boolean.class));
        Trait.put(OVERLINE_COLOR, new TraitInfo("overline-score-color", Color.class));
        Trait.put(LINETHROUGH, new TraitInfo("through-score", Boolean.class));
        Trait.put(LINETHROUGH_COLOR, new TraitInfo("through-score-color", Color.class));
        Trait.put(BLINK, new TraitInfo("blink", Boolean.class));
        Trait.put(BORDER_START, new TraitInfo("border-start", BorderProps.class));
        Trait.put(BORDER_END, new TraitInfo("border-end", BorderProps.class));
        Trait.put(BORDER_BEFORE, new TraitInfo("border-before", BorderProps.class));
        Trait.put(BORDER_AFTER, new TraitInfo("border-after", BorderProps.class));
        Trait.put(PADDING_START, new TraitInfo("padding-start", Integer.class));
        Trait.put(PADDING_END, new TraitInfo("padding-end", Integer.class));
        Trait.put(PADDING_BEFORE, new TraitInfo("padding-before", Integer.class));
        Trait.put(PADDING_AFTER, new TraitInfo("padding-after", Integer.class));
        Trait.put(SPACE_START, new TraitInfo("space-start", Integer.class));
        Trait.put(SPACE_END, new TraitInfo("space-end", Integer.class));
        Trait.put(START_INDENT, new TraitInfo("start-indent", Integer.class));
        Trait.put(END_INDENT, new TraitInfo("end-indent", Integer.class));
        Trait.put(SPACE_BEFORE, new TraitInfo("space-before", Integer.class));
        Trait.put(SPACE_AFTER, new TraitInfo("space-after", Integer.class));
        Trait.put(IS_REFERENCE_AREA, new TraitInfo("is-reference-area", Boolean.class));
        Trait.put(IS_VIEWPORT_AREA, new TraitInfo("is-viewport-area", Boolean.class));
        Trait.put(WRITING_MODE, new TraitInfo("writing-mode", WritingMode.class));
        Trait.put(INLINE_PROGRESSION_DIRECTION, new TraitInfo("inline-progression-direction", Direction.class));
        Trait.put(BLOCK_PROGRESSION_DIRECTION, new TraitInfo("block-progression-direction", Direction.class));
        Trait.put(SHIFT_DIRECTION, new TraitInfo("shift-direction", Direction.class));
    }

    public static class Background
    implements Serializable {
        private static final long serialVersionUID = 8452078676273242870L;
        private Color color = null;
        private String url = null;
        private ImageInfo imageInfo = null;
        private int repeat;
        private int horiz;
        private int vertical;

        public Color getColor() {
            return this.color;
        }

        public int getHoriz() {
            return this.horiz;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public String getURL() {
            return this.url;
        }

        public ImageInfo getImageInfo() {
            return this.imageInfo;
        }

        public int getVertical() {
            return this.vertical;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setHoriz(int n) {
            this.horiz = n;
        }

        public void setRepeat(int n) {
            this.repeat = n;
        }

        public void setRepeat(String string) {
            this.setRepeat(Background.getConstantForRepeat(string));
        }

        public void setURL(String string) {
            this.url = string;
        }

        public void setImageInfo(ImageInfo imageInfo) {
            this.imageInfo = imageInfo;
        }

        public void setVertical(int n) {
            this.vertical = n;
        }

        private String getRepeatString() {
            switch (this.getRepeat()) {
                case 112: {
                    return "repeat";
                }
                case 113: {
                    return "repeat-x";
                }
                case 114: {
                    return "repeat-y";
                }
                case 96: {
                    return "no-repeat";
                }
            }
            throw new IllegalStateException("Illegal repeat style: " + this.getRepeat());
        }

        private static int getConstantForRepeat(String string) {
            if ("repeat".equalsIgnoreCase(string)) {
                return 112;
            }
            if ("repeat-x".equalsIgnoreCase(string)) {
                return 113;
            }
            if ("repeat-y".equalsIgnoreCase(string)) {
                return 114;
            }
            if ("no-repeat".equalsIgnoreCase(string)) {
                return 96;
            }
            throw new IllegalStateException("Illegal repeat style: " + string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.color != null) {
                stringBuffer.append("color=").append(ColorUtil.colorToString(this.color));
            }
            if (this.url != null) {
                if (this.color != null) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("url=").append(this.url);
                stringBuffer.append(",repeat=").append(this.getRepeatString());
                stringBuffer.append(",horiz=").append(this.horiz);
                stringBuffer.append(",vertical=").append(this.vertical);
            }
            return stringBuffer.toString();
        }
    }

    public static class ExternalLink
    implements Serializable {
        private static final long serialVersionUID = -3720707599232620946L;
        private String destination;
        private boolean newWindow;

        public ExternalLink(String string, boolean bl) {
            this.destination = string;
            this.newWindow = bl;
        }

        protected static ExternalLink makeFromTraitValue(String string) {
            String string2 = null;
            boolean bl = false;
            for (String string3 : string.split(",")) {
                if (string3.startsWith("dest=")) {
                    string2 = string3.substring(5);
                    continue;
                }
                if (string3.startsWith("newWindow=")) {
                    bl = Boolean.valueOf(string3.substring(10));
                    continue;
                }
                throw new IllegalArgumentException("Malformed trait value for Trait.ExternalLink: " + string);
            }
            return new ExternalLink(string2, bl);
        }

        public String getDestination() {
            return this.destination;
        }

        public boolean newWindow() {
            return this.newWindow;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("newWindow=").append(this.newWindow);
            stringBuffer.append(",dest=").append(this.destination);
            return stringBuffer.toString();
        }
    }

    public static class InternalLink
    implements Serializable {
        private static final long serialVersionUID = -8993505060996723039L;
        private String pvKey;
        private String idRef;

        public InternalLink(String string, String string2) {
            this.setPVKey(string);
            this.setIDRef(string2);
        }

        public InternalLink(String string) {
            String[] stringArray = InternalLink.parseXMLAttribute(string);
            this.setPVKey(stringArray[0]);
            this.setIDRef(stringArray[1]);
        }

        public void setPVKey(String string) {
            this.pvKey = string;
        }

        public String getPVKey() {
            return this.pvKey;
        }

        public void setIDRef(String string) {
            this.idRef = string;
        }

        public String getIDRef() {
            return this.idRef;
        }

        public String xmlAttribute() {
            return InternalLink.makeXMLAttribute(this.pvKey, this.idRef);
        }

        public static String makeXMLAttribute(String string, String string2) {
            return "(" + (string == null ? "" : string) + "," + (string2 == null ? "" : string2) + ")";
        }

        public static String[] parseXMLAttribute(String string) {
            String[] stringArray = new String[]{null, null};
            if (string != null) {
                int n = string.length();
                if (n >= 2 && string.charAt(0) == '(' && string.charAt(n - 1) == ')' && string.indexOf(44) != -1) {
                    String string2 = string.substring(1, n - 1);
                    int n2 = string2.indexOf(44);
                    stringArray[0] = string2.substring(0, n2).trim();
                    stringArray[1] = string2.substring(n2 + 1, string2.length()).trim();
                } else {
                    stringArray[0] = string;
                }
            }
            return stringArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("pvKey=").append(this.pvKey);
            stringBuffer.append(",idRef=").append(this.idRef);
            return stringBuffer.toString();
        }
    }

    private static class TraitInfo {
        private String name;
        private Class clazz;

        public TraitInfo(String string, Class clazz) {
            this.name = string;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Class getClazz() {
            return this.clazz;
        }
    }
}

