/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import org.apache.fop.area.Area;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.Trait;
import org.apache.fop.area.Viewport;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class RegionViewport
extends Area
implements Viewport {
    private static final long serialVersionUID = 505781815165102572L;
    private RegionReference regionReference;
    private Rectangle2D viewArea;
    private boolean clip = false;

    public RegionViewport(Rectangle2D rectangle2D) {
        this.viewArea = rectangle2D;
        this.addTrait(Trait.IS_VIEWPORT_AREA, Boolean.TRUE);
    }

    public void setRegionReference(RegionReference regionReference) {
        this.regionReference = regionReference;
    }

    public RegionReference getRegionReference() {
        return this.regionReference;
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    public boolean hasClip() {
        return this.clip;
    }

    public Rectangle getClipRectangle() {
        if (this.clip) {
            return new Rectangle(this.getIPD(), this.getBPD());
        }
        return null;
    }

    public Rectangle2D getViewArea() {
        return this.viewArea;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat((float)this.viewArea.getX());
        objectOutputStream.writeFloat((float)this.viewArea.getY());
        objectOutputStream.writeFloat((float)this.viewArea.getWidth());
        objectOutputStream.writeFloat((float)this.viewArea.getHeight());
        objectOutputStream.writeBoolean(this.clip);
        objectOutputStream.writeObject(this.traits);
        objectOutputStream.writeObject(this.regionReference);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.viewArea = new Rectangle2D.Float(objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat(), objectInputStream.readFloat());
        this.clip = objectInputStream.readBoolean();
        this.traits = (TreeMap)objectInputStream.readObject();
        this.setRegionReference((RegionReference)objectInputStream.readObject());
    }

    public Object clone() throws CloneNotSupportedException {
        RegionViewport regionViewport = (RegionViewport)super.clone();
        regionViewport.regionReference = (RegionReference)this.regionReference.clone();
        regionViewport.viewArea = (Rectangle2D)this.viewArea.clone();
        return regionViewport;
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
        if (this.regionReference != null) {
            this.regionReference.setWritingModeTraits(writingModeTraitsGetter);
        }
    }
}

