/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.CTM;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.pagination.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionReference
extends Area {
    private static final long serialVersionUID = -298980963268244238L;
    private int regionClass;
    private String regionName;
    private CTM ctm;
    private ArrayList<Area> blocks = new ArrayList();
    protected RegionViewport regionViewport;

    public RegionReference(Region region, RegionViewport regionViewport) {
        this(region.getNameId(), region.getRegionName(), regionViewport);
    }

    public RegionReference(int n, String string, RegionViewport regionViewport) {
        this.regionClass = n;
        this.regionName = string;
        this.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
        this.regionViewport = regionViewport;
    }

    @Override
    public void addChildArea(Area area) {
        this.blocks.add(area);
    }

    public void setCTM(CTM cTM) {
        this.ctm = cTM;
    }

    public RegionViewport getRegionViewport() {
        return this.regionViewport;
    }

    public CTM getCTM() {
        return this.ctm;
    }

    public List<Area> getBlocks() {
        return this.blocks;
    }

    public int getRegionClass() {
        return this.regionClass;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void addBlock(Block block) {
        this.addChildArea(block);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RegionReference regionReference = (RegionReference)super.clone();
        regionReference.blocks = (ArrayList)this.blocks.clone();
        return regionReference;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" {regionName=").append(this.regionName);
        stringBuffer.append(", regionClass=").append(this.regionClass);
        stringBuffer.append(", ctm=").append(this.ctm);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

