/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.AbstractOffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.fo.pagination.bookmarks.Bookmark;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkData
extends AbstractOffDocumentItem
implements Resolvable {
    private List<BookmarkData> subData = new ArrayList<BookmarkData>();
    private String bookmarkTitle = null;
    private boolean showChildren = true;
    private String idRef;
    private PageViewport pageRef = null;
    private Map<String, List<Resolvable>> unresolvedIDRefs = new HashMap<String, List<Resolvable>>();

    public BookmarkData(BookmarkTree bookmarkTree) {
        this.idRef = null;
        this.whenToProcess = 2;
        this.showChildren = true;
        for (int i = 0; i < bookmarkTree.getBookmarks().size(); ++i) {
            Bookmark bookmark = (Bookmark)bookmarkTree.getBookmarks().get(i);
            this.addSubData(this.createBookmarkData(bookmark));
        }
    }

    public BookmarkData(Bookmark bookmark) {
        this.bookmarkTitle = bookmark.getBookmarkTitle();
        this.showChildren = bookmark.showChildItems();
        this.idRef = bookmark.getInternalDestination();
    }

    private void putUnresolved(String string, BookmarkData bookmarkData) {
        List<Resolvable> list = this.unresolvedIDRefs.get(string);
        if (list == null) {
            list = new ArrayList<Resolvable>();
            this.unresolvedIDRefs.put(string, list);
        }
        list.add(bookmarkData);
    }

    public BookmarkData() {
        this.idRef = null;
        this.whenToProcess = 2;
        this.showChildren = true;
    }

    public BookmarkData(String string, boolean bl, PageViewport pageViewport, String string2) {
        this.bookmarkTitle = string;
        this.showChildren = bl;
        this.pageRef = pageViewport;
        this.idRef = string2;
    }

    public String getIDRef() {
        return this.idRef;
    }

    public void addSubData(BookmarkData bookmarkData) {
        this.subData.add(bookmarkData);
        if (bookmarkData.pageRef == null) {
            String[] stringArray;
            this.putUnresolved(bookmarkData.getIDRef(), bookmarkData);
            for (String string : stringArray = bookmarkData.getIDRefs()) {
                this.putUnresolved(string, bookmarkData);
            }
        }
    }

    public String getBookmarkTitle() {
        return this.bookmarkTitle;
    }

    public boolean showChildItems() {
        return this.showChildren;
    }

    public int getCount() {
        return this.subData.size();
    }

    public BookmarkData getSubData(int n) {
        return this.subData.get(n);
    }

    public PageViewport getPageViewport() {
        return this.pageRef;
    }

    @Override
    public boolean isResolved() {
        return this.unresolvedIDRefs == null || this.unresolvedIDRefs.size() == 0;
    }

    @Override
    public String[] getIDRefs() {
        return this.unresolvedIDRefs.keySet().toArray(new String[this.unresolvedIDRefs.keySet().size()]);
    }

    @Override
    public void resolveIDRef(String string, List<PageViewport> list) {
        List<Resolvable> list2;
        if (string.equals(this.idRef)) {
            this.pageRef = list.get(0);
        }
        if ((list2 = this.unresolvedIDRefs.get(string)) != null) {
            for (Resolvable resolvable : list2) {
                resolvable.resolveIDRef(string, list);
            }
        }
        this.unresolvedIDRefs.remove(string);
    }

    @Override
    public String getName() {
        return "Bookmarks";
    }

    private BookmarkData createBookmarkData(Bookmark bookmark) {
        BookmarkData bookmarkData = new BookmarkData(bookmark);
        for (int i = 0; i < bookmark.getChildBookmarks().size(); ++i) {
            Bookmark bookmark2 = (Bookmark)bookmark.getChildBookmarks().get(i);
            bookmarkData.addSubData(this.createBookmarkData(bookmark2));
        }
        return bookmarkData;
    }
}

