/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactoryConfigurator;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.render.ImageHandlerRegistry;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;
import org.apache.fop.util.ColorSpaceCache;
import org.apache.fop.util.ContentHandlerFactoryRegistry;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FopFactory
implements ImageContext {
    private static Log log = LogFactory.getLog(FopFactory.class);
    private RendererFactory rendererFactory;
    private XMLHandlerRegistry xmlHandlers;
    private ImageHandlerRegistry imageHandlers;
    private ElementMappingRegistry elementMappingRegistry;
    private ContentHandlerFactoryRegistry contentHandlerFactoryRegistry = new ContentHandlerFactoryRegistry();
    private HyphenationTreeResolver hyphResolver = null;
    private ColorSpaceCache colorSpaceCache = null;
    private ImageManager imageManager;
    private FontManager fontManager;
    private FopFactoryConfigurator config = new FopFactoryConfigurator(this);
    private String base = null;
    private boolean accessibility = false;
    private String hyphenBase = null;
    private Map hyphPatNames = null;
    private boolean strictFOValidation = true;
    private boolean strictUserConfigValidation = true;
    private float sourceResolution = 72.0f;
    private float targetResolution = 72.0f;
    private String pageHeight = "11in";
    private String pageWidth = "8.26in";
    private boolean useComplexScriptFeatures = true;
    private boolean breakIndentInheritanceOnReferenceAreaBoundary = false;
    private LayoutManagerMaker lmMakerOverride = null;
    private Set<String> ignoredNamespaces;
    private FOURIResolver foURIResolver;

    protected FopFactory() {
        this.elementMappingRegistry = new ElementMappingRegistry(this);
        this.foURIResolver = new FOURIResolver(this.validateUserConfigStrictly());
        this.fontManager = new FontManager(){

            public void setFontBaseURL(String string) throws MalformedURLException {
                super.setFontBaseURL(FopFactory.this.getFOURIResolver().checkBaseURL(string));
            }
        };
        this.colorSpaceCache = new ColorSpaceCache(this.foURIResolver);
        this.imageManager = new ImageManager((ImageContext)this);
        this.rendererFactory = new RendererFactory();
        this.xmlHandlers = new XMLHandlerRegistry();
        this.imageHandlers = new ImageHandlerRegistry();
        this.ignoredNamespaces = new HashSet<String>();
    }

    public static FopFactory newInstance() {
        return new FopFactory();
    }

    public FOUserAgent newFOUserAgent() {
        FOUserAgent fOUserAgent = new FOUserAgent(this);
        return fOUserAgent;
    }

    void setAccessibility(boolean bl) {
        this.accessibility = bl;
    }

    boolean isAccessibilityEnabled() {
        return this.accessibility;
    }

    void setComplexScriptFeaturesEnabled(boolean bl) {
        this.useComplexScriptFeatures = bl;
    }

    boolean isComplexScriptFeaturesEnabled() {
        return this.useComplexScriptFeatures;
    }

    public Fop newFop(String string) throws FOPException {
        return this.newFop(string, this.newFOUserAgent());
    }

    public Fop newFop(String string, FOUserAgent fOUserAgent) throws FOPException {
        return this.newFop(string, fOUserAgent, null);
    }

    public Fop newFop(String string, OutputStream outputStream) throws FOPException {
        return this.newFop(string, this.newFOUserAgent(), outputStream);
    }

    public Fop newFop(String string, FOUserAgent fOUserAgent, OutputStream outputStream) throws FOPException {
        if (fOUserAgent == null) {
            throw new NullPointerException("The userAgent parameter must not be null!");
        }
        return new Fop(string, fOUserAgent, outputStream);
    }

    public Fop newFop(FOUserAgent fOUserAgent) throws FOPException {
        if (fOUserAgent.getRendererOverride() == null && fOUserAgent.getFOEventHandlerOverride() == null && fOUserAgent.getDocumentHandlerOverride() == null) {
            throw new IllegalStateException("An overriding renderer, FOEventHandler or IFDocumentHandler must be set on the user agent when this factory method is used!");
        }
        return this.newFop(null, fOUserAgent);
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }

    public ImageHandlerRegistry getImageHandlerRegistry() {
        return this.imageHandlers;
    }

    public ElementMappingRegistry getElementMappingRegistry() {
        return this.elementMappingRegistry;
    }

    public ContentHandlerFactoryRegistry getContentHandlerFactoryRegistry() {
        return this.contentHandlerFactoryRegistry;
    }

    public ImageManager getImageManager() {
        return this.imageManager;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        this.elementMappingRegistry.addElementMapping(elementMapping);
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker layoutManagerMaker) {
        this.lmMakerOverride = layoutManagerMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    public void setBaseURL(String string) throws MalformedURLException {
        this.base = this.foURIResolver.checkBaseURL(string);
    }

    public String getBaseURL() {
        return this.base;
    }

    @Deprecated
    public void setFontBaseURL(String string) throws MalformedURLException {
        this.getFontManager().setFontBaseURL(string);
    }

    @Deprecated
    public String getFontBaseURL() {
        return this.getFontManager().getFontBaseURL();
    }

    public String getHyphenBaseURL() {
        return this.hyphenBase;
    }

    public void setHyphenBaseURL(final String string) throws MalformedURLException {
        if (string != null) {
            this.setHyphenationTreeResolver(new HyphenationTreeResolver(){

                public Source resolve(String string2) {
                    return FopFactory.this.resolveURI(string2, string);
                }
            });
        }
        this.hyphenBase = this.foURIResolver.checkBaseURL(string);
    }

    public Map getHyphPatNames() {
        return this.hyphPatNames;
    }

    public void setHyphPatNames(Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        this.hyphPatNames = hashMap;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.foURIResolver.setCustomURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.foURIResolver;
    }

    public FOURIResolver getFOURIResolver() {
        return this.foURIResolver;
    }

    public HyphenationTreeResolver getHyphenationTreeResolver() {
        return this.hyphResolver;
    }

    public void setHyphenationTreeResolver(HyphenationTreeResolver hyphenationTreeResolver) {
        this.hyphResolver = hyphenationTreeResolver;
    }

    public void setStrictValidation(boolean bl) {
        this.strictFOValidation = bl;
    }

    public boolean validateStrictly() {
        return this.strictFOValidation;
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.breakIndentInheritanceOnReferenceAreaBoundary;
    }

    public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean bl) {
        this.breakIndentInheritanceOnReferenceAreaBoundary = bl;
    }

    @Deprecated
    public boolean isBase14KerningEnabled() {
        return this.getFontManager().isBase14KerningEnabled();
    }

    @Deprecated
    public void setBase14KerningEnabled(boolean bl) {
        this.getFontManager().setBase14KerningEnabled(bl);
    }

    public float getSourceResolution() {
        return this.sourceResolution;
    }

    public float getSourcePixelUnitToMillimeter() {
        return 25.4f / this.getSourceResolution();
    }

    public void setSourceResolution(float f) {
        this.sourceResolution = f;
        if (log.isDebugEnabled()) {
            log.debug((Object)("source-resolution set to: " + this.sourceResolution + "dpi (px2mm=" + this.getSourcePixelUnitToMillimeter() + ")"));
        }
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public void setTargetResolution(float f) {
        this.targetResolution = f;
    }

    public void setSourceResolution(int n) {
        this.setSourceResolution((float)n);
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String string) {
        this.pageHeight = string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default page-height set to: " + string));
        }
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String string) {
        this.pageWidth = string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default page-width set to: " + string));
        }
    }

    public void ignoreNamespace(String string) {
        this.ignoredNamespaces.add(string);
    }

    public void ignoreNamespaces(Collection<String> collection) {
        this.ignoredNamespaces.addAll(collection);
    }

    public boolean isNamespaceIgnored(String string) {
        return this.ignoredNamespaces.contains(string);
    }

    public Set<String> getIgnoredNamespace() {
        return Collections.unmodifiableSet(this.ignoredNamespaces);
    }

    public void setUserConfig(File file) throws SAXException, IOException {
        this.config.setUserConfig(file);
    }

    public void setUserConfig(String string) throws SAXException, IOException {
        this.config.setUserConfig(string);
    }

    public void setUserConfig(Configuration configuration) throws FOPException {
        this.config.setUserConfig(configuration);
    }

    public void setUserConfigBaseURI(URI uRI) {
        this.config.setBaseURI(uRI);
    }

    public Configuration getUserConfig() {
        return this.config.getUserConfig();
    }

    public void setStrictUserConfigValidation(boolean bl) {
        this.strictUserConfigValidation = bl;
        this.foURIResolver.setThrowExceptions(bl);
    }

    public boolean validateUserConfigStrictly() {
        return this.strictUserConfigValidation;
    }

    @Deprecated
    public void setUseCache(boolean bl) {
        this.getFontManager().setUseCache(bl);
    }

    @Deprecated
    public boolean useCache() {
        return this.getFontManager().useCache();
    }

    @Deprecated
    public FontCache getFontCache() {
        return this.getFontManager().getFontCache();
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public Source resolveURI(String string, String string2) {
        Source source = null;
        try {
            source = this.foURIResolver.resolve(string, string2);
        }
        catch (TransformerException transformerException) {
            log.error((Object)("Attempt to resolve URI '" + string + "' failed: "), (Throwable)transformerException);
        }
        return source;
    }

    public ColorSpaceCache getColorSpaceCache() {
        return this.colorSpaceCache;
    }
}

