/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FOPException
extends SAXException {
    private static final String EXCEPTION_SEPARATOR = "\n---------\n";
    private String systemId;
    private int line;
    private int column;
    private String localizedMessage;

    public FOPException(String string) {
        super(string);
    }

    public FOPException(String string, String string2, int n, int n2) {
        super(string);
        this.systemId = string2;
        this.line = n;
        this.column = n2;
    }

    public FOPException(String string, Locator locator) {
        super(string);
        this.setLocator(locator);
    }

    public FOPException(Exception exception) {
        super(exception);
    }

    public FOPException(String string, Exception exception) {
        super(string, exception);
    }

    public void setLocator(Locator locator) {
        if (locator != null) {
            this.systemId = locator.getSystemId();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public void setLocation(String string, int n, int n2) {
        this.systemId = string;
        this.line = n;
        this.column = n2;
    }

    public boolean isLocationSet() {
        return this.line > 0;
    }

    public String getMessage() {
        if (this.isLocationSet()) {
            return this.systemId + ":" + this.line + ":" + this.column + ": " + super.getMessage();
        }
        return super.getMessage();
    }

    protected Throwable getRootException() {
        Throwable throwable = this.getException();
        if (throwable instanceof SAXException) {
            throwable = ((SAXException)throwable).getException();
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable != this.getException()) {
            return throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this.getException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getException().printStackTrace();
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (this.getException() != null) {
                printStream.println(EXCEPTION_SEPARATOR);
                this.getException().printStackTrace(printStream);
            }
            if (this.getRootException() != null) {
                printStream.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this.getException() != null) {
                printWriter.println(EXCEPTION_SEPARATOR);
                this.getException().printStackTrace(printWriter);
            }
            if (this.getRootException() != null) {
                printWriter.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(printWriter);
            }
        }
    }

    public void setLocalizedMessage(String string) {
        this.localizedMessage = string;
    }

    public String getLocalizedMessage() {
        if (this.localizedMessage != null) {
            return this.localizedMessage;
        }
        return super.getLocalizedMessage();
    }
}

