/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ptoca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.fonts.CharactersetEncoder;
import org.apache.fop.afp.modca.AxisOrientation;
import org.apache.fop.afp.ptoca.PtocaConstants;
import org.apache.fop.afp.ptoca.TransparentDataControlSequence;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public abstract class PtocaBuilder
implements PtocaConstants {
    private ByteArrayOutputStream baout = new ByteArrayOutputStream(256);
    private int currentX = -1;
    private int currentY = -1;
    private int currentFont = Integer.MIN_VALUE;
    private int currentOrientation = 0;
    private Color currentColor = Color.BLACK;
    private int currentVariableSpaceCharacterIncrement = 0;
    private int currentInterCharacterAdjustment = 0;

    protected abstract OutputStream getOutputStreamForControlSequence(int var1);

    private static byte chained(byte by) {
        return (byte)(by | 1);
    }

    private void newControlSequence() {
        this.baout.reset();
    }

    private void commit(byte by) throws IOException {
        int n = this.baout.size() + 2;
        assert (n < 256);
        OutputStream outputStream = this.getOutputStreamForControlSequence(n);
        outputStream.write(n);
        outputStream.write(by);
        this.baout.writeTo(outputStream);
    }

    private void writeBytes(int ... nArray) {
        for (int n : nArray) {
            this.baout.write(n);
        }
    }

    private void writeShort(int n) {
        this.baout.write(n >>> 8 & 0xFF);
        this.baout.write(n & 0xFF);
    }

    public void writeIntroducer() throws IOException {
        OutputStream outputStream = this.getOutputStreamForControlSequence(ESCAPE.length);
        outputStream.write(ESCAPE);
    }

    public void setCodedFont(byte by) throws IOException {
        if (this.currentFont == by) {
            return;
        }
        this.currentFont = by;
        this.newControlSequence();
        this.writeBytes(by);
        this.commit(PtocaBuilder.chained((byte)-16));
    }

    public void absoluteMoveInline(int n) throws IOException {
        if (n == this.currentX) {
            return;
        }
        this.newControlSequence();
        this.writeShort(n);
        this.commit(PtocaBuilder.chained((byte)-58));
        this.currentX = n;
    }

    public void relativeMoveInline(int n) throws IOException {
        this.newControlSequence();
        this.writeShort(n);
        this.commit(PtocaBuilder.chained((byte)-56));
    }

    public void absoluteMoveBaseline(int n) throws IOException {
        if (n == this.currentY) {
            return;
        }
        this.newControlSequence();
        this.writeShort(n);
        this.commit(PtocaBuilder.chained((byte)-46));
        this.currentY = n;
        this.currentX = -1;
    }

    public void addTransparentData(CharactersetEncoder.EncodedChars encodedChars) throws IOException {
        for (TransparentDataControlSequence.TransparentData transparentData : new TransparentDataControlSequence(encodedChars)) {
            this.newControlSequence();
            transparentData.writeTo((OutputStream)this.baout);
            this.commit(PtocaBuilder.chained((byte)-38));
        }
    }

    public void drawBaxisRule(int n, int n2) throws IOException {
        this.newControlSequence();
        this.writeShort(n);
        this.writeShort(n2);
        this.writeBytes(0);
        this.commit(PtocaBuilder.chained((byte)-26));
    }

    public void drawIaxisRule(int n, int n2) throws IOException {
        this.newControlSequence();
        this.writeShort(n);
        this.writeShort(n2);
        this.writeBytes(0);
        this.commit(PtocaBuilder.chained((byte)-28));
    }

    public void setTextOrientation(int n) throws IOException {
        if (n == this.currentOrientation) {
            return;
        }
        this.newControlSequence();
        AxisOrientation.getRightHandedAxisOrientationFor(n).writeTo((OutputStream)this.baout);
        this.commit(PtocaBuilder.chained((byte)-10));
        this.currentOrientation = n;
        this.currentX = -1;
        this.currentY = -1;
    }

    public void setExtendedTextColor(Color color) throws IOException {
        Object object;
        Object object2;
        if (ColorUtil.isSameColor((Color)color, (Color)this.currentColor)) {
            return;
        }
        if (color instanceof ColorWithAlternatives && (object2 = (object = (ColorWithAlternatives)color).getFirstAlternativeOfType(9)) != null) {
            color = object2;
        }
        object = color.getColorSpace();
        this.newControlSequence();
        if (color.getColorSpace().getType() == 9) {
            this.writeBytes(0, 4, 0, 0, 0, 0);
            this.writeBytes(8, 8, 8, 8);
            object2 = color.getColorComponents(null);
            assert (((Object)object2).length == 4);
            for (int i = 0; i < 4; ++i) {
                int n = Math.round((float)(object2[i] * 255.0f));
                this.writeBytes(n);
            }
        } else if (object instanceof CIELabColorSpace) {
            this.writeBytes(0, 8, 0, 0, 0, 0);
            this.writeBytes(8, 8, 8, 0);
            object2 = color.getColorComponents(null);
            int n = Math.round((float)(object2[0] * 255.0f));
            int n2 = Math.round((float)(object2[1] * 255.0f)) - 128;
            int n3 = Math.round((float)(object2[2] * 255.0f)) - 128;
            this.writeBytes(n, n2, n3);
        } else {
            this.writeBytes(0, 1, 0, 0, 0, 0);
            this.writeBytes(8, 8, 8, 0);
            this.writeBytes(color.getRed(), color.getGreen(), color.getBlue());
        }
        this.commit(PtocaBuilder.chained((byte)-128));
        this.currentColor = color;
    }

    public void setVariableSpaceCharacterIncrement(int n) throws IOException {
        if (n == this.currentVariableSpaceCharacterIncrement) {
            return;
        }
        assert (n >= 0 && n < 65536);
        this.newControlSequence();
        this.writeShort(Math.abs(n));
        this.commit(PtocaBuilder.chained((byte)-60));
        this.currentVariableSpaceCharacterIncrement = n;
    }

    public void setInterCharacterAdjustment(int n) throws IOException {
        if (n == this.currentInterCharacterAdjustment) {
            return;
        }
        assert (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE);
        this.newControlSequence();
        this.writeShort(Math.abs(n));
        this.writeBytes(n >= 0 ? 0 : 1);
        this.commit(PtocaBuilder.chained((byte)-62));
        this.currentInterCharacterAdjustment = n;
    }

    public void endChainedControlSequence() throws IOException {
        this.newControlSequence();
        this.commit((byte)-8);
    }
}

