/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ptoca;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaConstants;
import org.apache.fop.afp.ptoca.PtocaProducer;

public class LineDataInfoProducer
implements PtocaProducer,
PtocaConstants {
    private static final Log LOG = LogFactory.getLog(LineDataInfoProducer.class);
    private AFPLineDataInfo lineDataInfo;

    public LineDataInfoProducer(AFPLineDataInfo aFPLineDataInfo) {
        this.lineDataInfo = aFPLineDataInfo;
    }

    public void produce(PtocaBuilder ptocaBuilder) throws IOException {
        ptocaBuilder.setTextOrientation(this.lineDataInfo.getRotation());
        int n = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getX1());
        int n2 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getY1());
        ptocaBuilder.absoluteMoveBaseline(n2);
        ptocaBuilder.absoluteMoveInline(n);
        ptocaBuilder.setExtendedTextColor(this.lineDataInfo.getColor());
        int n3 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getX2());
        int n4 = LineDataInfoProducer.ensurePositive(this.lineDataInfo.getY2());
        int n5 = this.lineDataInfo.getThickness();
        if (n2 == n4) {
            ptocaBuilder.drawIaxisRule(n3 - n, n5);
        } else if (n == n3) {
            ptocaBuilder.drawBaxisRule(n4 - n2, n5);
        } else {
            LOG.error((Object)"Invalid axis rule: unable to draw line");
            return;
        }
    }

    private static int ensurePositive(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }
}

