/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPTextDataInfo;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.PresentationTextData;
import org.apache.fop.afp.ptoca.LineDataInfoProducer;
import org.apache.fop.afp.ptoca.PtocaBuilder;
import org.apache.fop.afp.ptoca.PtocaProducer;
import org.apache.fop.afp.ptoca.TextDataInfoProducer;

public class PresentationTextObject
extends AbstractNamedAFPObject {
    private PresentationTextData currentPresentationTextData = null;
    private List presentationTextDataList = null;
    private PtocaBuilder builder = new DefaultBuilder();

    public PresentationTextObject(String string) {
        super(string);
    }

    public void createTextData(AFPTextDataInfo aFPTextDataInfo) throws UnsupportedEncodingException {
        this.createControlSequences(new TextDataInfoProducer(aFPTextDataInfo));
    }

    public void createControlSequences(PtocaProducer ptocaProducer) throws UnsupportedEncodingException {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            ptocaProducer.produce(this.builder);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.endPresentationTextData();
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            this.endPresentationTextData();
            this.handleUnexpectedIOError(iOException);
        }
    }

    public void createLineData(AFPLineDataInfo aFPLineDataInfo) {
        try {
            this.createControlSequences(new LineDataInfoProducer(aFPLineDataInfo));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.handleUnexpectedIOError(unsupportedEncodingException);
        }
    }

    private void startPresentationTextData() {
        if (this.presentationTextDataList == null) {
            this.presentationTextDataList = new ArrayList();
        }
        this.currentPresentationTextData = this.presentationTextDataList.size() == 0 ? new PresentationTextData(true) : new PresentationTextData();
        this.presentationTextDataList.add(this.currentPresentationTextData);
    }

    private void endPresentationTextData() {
        this.currentPresentationTextData = null;
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-101);
        outputStream.write(byArray);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        this.writeObjects(this.presentationTextDataList, outputStream);
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-101);
        outputStream.write(byArray);
    }

    public void endControlSequence() {
        if (this.currentPresentationTextData == null) {
            this.startPresentationTextData();
        }
        try {
            this.builder.endChainedControlSequence();
        }
        catch (IOException iOException) {
            this.endPresentationTextData();
            this.handleUnexpectedIOError(iOException);
        }
    }

    private void handleUnexpectedIOError(IOException iOException) {
        throw new RuntimeException("Unexpected I/O error: " + iOException.getMessage(), iOException);
    }

    public String toString() {
        if (this.presentationTextDataList != null) {
            return this.presentationTextDataList.toString();
        }
        return super.toString();
    }

    private class DefaultBuilder
    extends PtocaBuilder {
        private DefaultBuilder() {
        }

        protected OutputStream getOutputStreamForControlSequence(int n) {
            if (n > PresentationTextObject.this.currentPresentationTextData.getBytesAvailable()) {
                PresentationTextObject.this.endPresentationTextData();
                PresentationTextObject.this.startPresentationTextData();
            }
            return PresentationTextObject.this.currentPresentationTextData.getOutputStream();
        }
    }
}

