/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.util.BinaryUtils;

public class ObjectAreaPosition
extends AbstractAFPObject {
    public static final byte REFCSYS_PAGE_SEGMENT_RELATIVE = 0;
    public static final byte REFCSYS_PAGE_RELATIVE = 1;
    private final int x;
    private final int y;
    private final int rotation;
    private int xOffset;
    private int yOffset;
    private byte refCSys = 1;

    public ObjectAreaPosition(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public ObjectAreaPosition(int n, int n2, int n3, byte by) {
        this.x = n;
        this.y = n2;
        this.rotation = n3;
        this.setReferenceCoordinateSystem(by);
    }

    public void setReferenceCoordinateSystem(byte by) {
        this.refCSys = by;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte by;
        byte by2;
        byte[] byArray = new byte[33];
        this.copySF(byArray, (byte)-84, (byte)107);
        byte[] byArray2 = BinaryUtils.convert(32, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[9] = 1;
        byArray[10] = 23;
        byte[] byArray3 = BinaryUtils.convert(this.x, 3);
        byArray[11] = byArray3[0];
        byArray[12] = byArray3[1];
        byArray[13] = byArray3[2];
        byte[] byArray4 = BinaryUtils.convert(this.y, 3);
        byArray[14] = byArray4[0];
        byArray[15] = byArray4[1];
        byArray[16] = byArray4[2];
        byArray[17] = by2 = (byte)(this.rotation / 2);
        byArray[19] = by = (byte)(this.rotation / 2 + 45);
        byte[] byArray5 = BinaryUtils.convert(this.xOffset, 3);
        byArray[22] = byArray5[0];
        byArray[23] = byArray5[1];
        byArray[24] = byArray5[2];
        byte[] byArray6 = BinaryUtils.convert(this.yOffset, 3);
        byArray[25] = byArray6[0];
        byArray[26] = byArray6[1];
        byArray[27] = byArray6[2];
        byArray[28] = 0;
        byArray[29] = 0;
        byArray[30] = 45;
        byArray[31] = 0;
        byArray[32] = this.refCSys;
        outputStream.write(byArray);
    }

    public String toString() {
        return "ObjectAreaPosition{x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", rotation=" + this.rotation + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset;
    }
}

