/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.util.BinaryUtils;

public class MapPageSegment
extends AbstractAFPObject {
    private static final int MAX_SIZE = 127;
    private Set pageSegments = null;

    private Set getPageSegments() {
        if (this.pageSegments == null) {
            this.pageSegments = new HashSet();
        }
        return this.pageSegments;
    }

    public void addPageSegment(String string) throws MaximumSizeExceededException {
        if (this.getPageSegments().size() > 127) {
            throw new MaximumSizeExceededException();
        }
        if (string.length() > 8) {
            throw new IllegalArgumentException("The name of page segment " + string + " must not be longer than 8 characters");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addPageSegment():: adding page segment " + string));
        }
        this.getPageSegments().add(string);
    }

    public boolean isFull() {
        return this.pageSegments.size() >= 127;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        int n = this.getPageSegments().size();
        int n2 = 12;
        int n3 = n * n2;
        byte[] byArray = new byte[n3 + 12 + 1];
        byArray[0] = 90;
        byte[] byArray2 = BinaryUtils.convert(byArray.length - 1, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[3] = -45;
        byArray[4] = -79;
        byArray[5] = 95;
        byArray[6] = 0;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = n2;
        byArray[10] = 0;
        byArray[11] = 0;
        byArray[12] = 0;
        int n4 = 13;
        Iterator iterator = this.pageSegments.iterator();
        while (iterator.hasNext()) {
            n4 += 4;
            String string = (String)iterator.next();
            try {
                byte[] byArray3 = string.getBytes("Cp1146");
                System.arraycopy(byArray3, 0, byArray, n4, byArray3.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error((Object)("UnsupportedEncodingException translating the name " + string));
            }
            n4 += 8;
        }
        outputStream.write(byArray);
    }
}

