/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.AxisOrientation;
import org.apache.fop.afp.modca.triplets.MappingOptionTriplet;
import org.apache.fop.afp.modca.triplets.MeasurementUnitsTriplet;
import org.apache.fop.afp.modca.triplets.ObjectAreaSizeTriplet;
import org.apache.fop.afp.util.BinaryUtils;

public class IncludeObject
extends AbstractNamedAFPObject {
    public static final byte TYPE_PAGE_SEGMENT = 95;
    public static final byte TYPE_OTHER = -110;
    public static final byte TYPE_GRAPHIC = -69;
    public static final byte TYPE_BARCODE = -21;
    public static final byte TYPE_IMAGE = -5;
    private byte objectType = (byte)-110;
    private int xoaOset = 0;
    private int yoaOset = 0;
    private AxisOrientation oaOrent = AxisOrientation.RIGHT_HANDED_0;
    private int xocaOset = -1;
    private int yocaOset = -1;

    public IncludeObject(String string) {
        super(string);
    }

    public void setObjectAreaOrientation(int n) {
        this.oaOrent = AxisOrientation.getRightHandedAxisOrientationFor(n);
    }

    public void setObjectAreaOffset(int n, int n2) {
        this.xoaOset = n;
        this.yoaOset = n2;
    }

    public void setContentAreaOffset(int n, int n2) {
        this.xocaOset = n;
        this.yocaOset = n2;
    }

    public void setObjectType(byte by) {
        this.objectType = by;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[36];
        super.copySF(byArray, (byte)-81, (byte)-61);
        int n = this.getTripletDataLength();
        byte[] byArray2 = BinaryUtils.convert(35 + n, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        byArray[17] = 0;
        byArray[18] = this.objectType;
        IncludeObject.writeOsetTo(byArray, 19, this.xoaOset);
        IncludeObject.writeOsetTo(byArray, 22, this.yoaOset);
        this.oaOrent.writeTo(byArray, 25);
        IncludeObject.writeOsetTo(byArray, 29, this.xocaOset);
        IncludeObject.writeOsetTo(byArray, 32, this.yocaOset);
        byArray[35] = 1;
        outputStream.write(byArray);
        this.writeTriplets(outputStream);
    }

    private static void writeOsetTo(byte[] byArray, int n, int n2) {
        if (n2 > -1) {
            byte[] byArray2 = BinaryUtils.convert(n2, 3);
            byArray[n] = byArray2[0];
            byArray[n + 1] = byArray2[1];
            byArray[n + 2] = byArray2[2];
        } else {
            byArray[n] = -1;
            byArray[n + 1] = -1;
            byArray[n + 2] = -1;
        }
    }

    private String getObjectTypeName() {
        String string = null;
        if (this.objectType == 95) {
            string = "page segment";
        } else if (this.objectType == -110) {
            string = "other";
        } else if (this.objectType == -69) {
            string = "graphic";
        } else if (this.objectType == -21) {
            string = "barcode";
        } else if (this.objectType == -5) {
            string = "image";
        }
        return string;
    }

    public String toString() {
        return "IncludeObject{name=" + this.getName() + ", objectType=" + this.getObjectTypeName() + ", xoaOset=" + this.xoaOset + ", yoaOset=" + this.yoaOset + ", oaOrent" + (Object)((Object)this.oaOrent) + ", xocaOset=" + this.xocaOset + ", yocaOset=" + this.yocaOset + "}";
    }

    public void setMappingOption(byte by) {
        this.addTriplet(new MappingOptionTriplet(by));
    }

    public void setObjectAreaSize(int n, int n2) {
        this.addTriplet(new ObjectAreaSizeTriplet(n, n2));
    }

    public void setMeasurementUnits(int n, int n2) {
        this.addTriplet(new MeasurementUnitsTriplet(n, n));
    }
}

