/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.AbstractDescriptor;
import org.apache.fop.afp.util.BinaryUtils;

public class GraphicsDataDescriptor
extends AbstractDescriptor {
    private final int xlwind;
    private final int xrwind;
    private final int ybwind;
    private final int ytwind;
    private static final int ABS = 64;
    private static final int IMGRES = 16;

    public GraphicsDataDescriptor(int n, int n2, int n3, int n4, int n5, int n6) {
        this.xlwind = n;
        this.xrwind = n2;
        this.ybwind = n3;
        this.ytwind = n4;
        this.widthRes = n5;
        this.heightRes = n6;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[9];
        this.copySF(byArray, (byte)-90, (byte)-69);
        byte[] byArray2 = this.getDrawingOrderSubset();
        byte[] byArray3 = this.getWindowSpecification();
        byte[] byArray4 = BinaryUtils.convert(byArray.length + byArray2.length + byArray3.length - 1, 2);
        byArray[1] = byArray4[0];
        byArray[2] = byArray4[1];
        outputStream.write(byArray);
        outputStream.write(byArray2);
        outputStream.write(byArray3);
    }

    private byte[] getDrawingOrderSubset() {
        byte[] byArray = new byte[]{-9, 7, -80, 0, 0, 2, 0, 1, 0};
        return byArray;
    }

    private byte[] getWindowSpecification() {
        byte[] byArray = BinaryUtils.convert(this.xlwind, 2);
        byte[] byArray2 = BinaryUtils.convert(this.xrwind, 2);
        byte[] byArray3 = BinaryUtils.convert(this.ybwind, 2);
        byte[] byArray4 = BinaryUtils.convert(this.ytwind, 2);
        byte[] byArray5 = BinaryUtils.convert(this.widthRes * 10, 2);
        byte[] byArray6 = BinaryUtils.convert(this.heightRes * 10, 2);
        byte[] byArray7 = byArray5;
        byte[] byArray8 = new byte[]{-10, 18, 80, 0, 0, 0, byArray5[0], byArray5[1], byArray6[0], byArray6[1], byArray7[0], byArray7[1], byArray[0], byArray[1], byArray2[0], byArray2[1], byArray3[0], byArray3[1], byArray4[0], byArray4[1]};
        return byArray8;
    }
}

