/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.fop.afp.Completable;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.modca.AbstractPageObject;
import org.apache.fop.afp.modca.ResourceGroup;

public abstract class AbstractResourceGroupContainer
extends AbstractPageObject
implements Streamable {
    protected boolean started = false;
    protected ResourceGroup resourceGroup = null;

    public AbstractResourceGroupContainer(Factory factory) {
        super(factory);
    }

    public AbstractResourceGroupContainer(Factory factory, String string) {
        super(factory, string);
    }

    public AbstractResourceGroupContainer(Factory factory, String string, int n, int n2, int n3, int n4, int n5) {
        super(factory, string, n, n2, n3, n4, n5);
    }

    protected int getResourceCount() {
        if (this.resourceGroup != null) {
            return this.resourceGroup.getResourceCount();
        }
        return 0;
    }

    protected boolean hasResources() {
        return this.resourceGroup != null && this.resourceGroup.getResourceCount() > 0;
    }

    public ResourceGroup getResourceGroup() {
        if (this.resourceGroup == null) {
            this.resourceGroup = this.factory.createResourceGroup();
        }
        return this.resourceGroup;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        if (!this.started) {
            this.writeStart(outputStream);
            this.started = true;
        }
        this.writeContent(outputStream);
        if (this.complete) {
            this.writeEnd(outputStream);
        }
    }

    protected void writeObjects(Collection collection, OutputStream outputStream) throws IOException {
        this.writeObjects(collection, outputStream, false);
    }

    protected void writeObjects(Collection collection, OutputStream outputStream, boolean bl) throws IOException {
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AbstractAFPObject abstractAFPObject = (AbstractAFPObject)iterator.next();
                if (!bl && !this.canWrite(abstractAFPObject)) break;
                abstractAFPObject.writeToStream(outputStream);
                iterator.remove();
            }
        }
    }

    protected boolean canWrite(AbstractAFPObject abstractAFPObject) {
        if (abstractAFPObject instanceof Completable) {
            return ((Completable)((Object)abstractAFPObject)).isComplete();
        }
        return this.isComplete();
    }
}

