/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.util.BinaryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAFPObject
implements Streamable {
    protected static final Log LOG = LogFactory.getLog(AbstractAFPObject.class);
    protected static final byte SF_CLASS = -45;
    private static final byte[] SF_HEADER = new byte[]{90, 0, 16, -45, 0, 0, 0, 0, 0};
    protected static final int SF_HEADER_LENGTH = SF_HEADER.length;

    protected void copySF(byte[] byArray, byte by, byte by2) {
        AbstractAFPObject.copySF(byArray, (byte)-45, by, by2);
    }

    protected static void copySF(byte[] byArray, byte by, byte by2, byte by3) {
        System.arraycopy(SF_HEADER, 0, byArray, 0, SF_HEADER_LENGTH);
        byArray[3] = by;
        byArray[4] = by2;
        byArray[5] = by3;
    }

    protected <S extends Streamable> void writeObjects(Collection<S> collection, OutputStream outputStream) throws IOException {
        if (collection != null) {
            Iterator<S> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Streamable streamable = (Streamable)iterator.next();
                streamable.writeToStream(outputStream);
                iterator.remove();
            }
        }
    }

    protected static void writeChunksToStream(byte[] byArray, byte[] byArray2, int n, int n2, OutputStream outputStream) throws IOException {
        byte[] byArray3;
        int n3 = byArray.length;
        int n4 = n3 / n2;
        int n5 = n3 % n2;
        int n6 = byArray2.length - n;
        if (n6 == 2) {
            n6 = 0;
        }
        int n7 = 0;
        if (n4 > 0) {
            byArray3 = BinaryUtils.convert(n6 + n2, 2);
            byArray2[n] = byArray3[0];
            byArray2[n + 1] = byArray3[1];
            int n8 = 0;
            while (n8 < n4) {
                outputStream.write(byArray2);
                outputStream.write(byArray, n7, n2);
                ++n8;
                n7 += n2;
            }
        }
        if (n5 > 0) {
            byArray3 = BinaryUtils.convert(n6 + n5, 2);
            byArray2[n] = byArray3[0];
            byArray2[n + 1] = byArray3[1];
            outputStream.write(byArray2);
            outputStream.write(byArray, n7, n5);
        }
    }

    protected static String truncate(String string, int n) {
        if (string.length() > n) {
            string = string.substring(0, n);
            LOG.warn((Object)("truncated character string '" + string + "', longer than " + n + " chars"));
        }
        return string;
    }

    public static interface Category {
        public static final byte PAGE_SEGMENT = 95;
        public static final byte OBJECT_AREA = 107;
        public static final byte COLOR_ATTRIBUTE_TABLE = 119;
        public static final byte IM_IMAGE = 123;
        public static final byte MEDIUM = -120;
        public static final byte CODED_FONT = -118;
        public static final byte PROCESS_ELEMENT = -112;
        public static final byte OBJECT_CONTAINER = -110;
        public static final byte PRESENTATION_TEXT = -101;
        public static final byte INDEX = -89;
        public static final byte DOCUMENT = -88;
        public static final byte PAGE_GROUP = -83;
        public static final byte PAGE = -81;
        public static final byte GRAPHICS = -69;
        public static final byte DATA_RESOURCE = -61;
        public static final byte DOCUMENT_ENVIRONMENT_GROUP = -60;
        public static final byte RESOURCE_GROUP = -58;
        public static final byte OBJECT_ENVIRONMENT_GROUP = -57;
        public static final byte ACTIVE_ENVIRONMENT_GROUP = -55;
        public static final byte MEDIUM_MAP = -52;
        public static final byte FORM_MAP = -51;
        public static final byte NAME_RESOURCE = -50;
        public static final byte PAGE_OVERLAY = -40;
        public static final byte RESOURCE_ENVIROMENT_GROUP = -39;
        public static final byte OVERLAY = -33;
        public static final byte DATA_SUPRESSION = -22;
        public static final byte BARCODE = -21;
        public static final byte NO_OPERATION = -18;
        public static final byte IMAGE = -5;
    }

    public static interface Type {
        public static final byte ATTRIBUTE = -96;
        public static final byte COPY_COUNT = -94;
        public static final byte DESCRIPTOR = -90;
        public static final byte CONTROL = -89;
        public static final byte BEGIN = -88;
        public static final byte END = -87;
        public static final byte MAP = -85;
        public static final byte POSITION = -84;
        public static final byte PROCESS = -83;
        public static final byte INCLUDE = -81;
        public static final byte TABLE = -80;
        public static final byte MIGRATION = -79;
        public static final byte VARIABLE = -78;
        public static final byte LINK = -76;
        public static final byte DATA = -18;
    }
}

