/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.goca.AbstractGraphicsCoord;

public class GraphicsCharacterString
extends AbstractGraphicsCoord {
    protected static final int MAX_STR_LEN = 255;
    private final String str;
    private final CharacterSet charSet;

    public GraphicsCharacterString(String string, int n, int n2, CharacterSet characterSet) {
        super(n, n2);
        this.str = GraphicsCharacterString.truncate(string, 255);
        this.charSet = characterSet;
    }

    byte getOrderCode() {
        if (this.isRelative()) {
            return -125;
        }
        return -61;
    }

    public int getDataLength() {
        return super.getDataLength() + this.str.length();
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getData();
        byte[] byArray2 = this.getStringAsBytes();
        System.arraycopy(byArray2, 0, byArray, 6, byArray2.length);
        outputStream.write(byArray);
    }

    private byte[] getStringAsBytes() throws UnsupportedEncodingException, CharacterCodingException {
        return this.charSet.encodeChars(this.str).getBytes();
    }

    public String toString() {
        return "GraphicsCharacterString{" + (this.coords != null ? "x=" + this.coords[0] + ", y=" + this.coords[1] : "") + "str='" + this.str + "'" + "}";
    }
}

