/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.Streamable;
import org.apache.fop.afp.modca.ResourceGroup;
import org.apache.fop.afp.modca.StreamedResourceGroup;

public class AFPStreamer
implements Streamable {
    private static final Log LOG = LogFactory.getLog(AFPStreamer.class);
    private static final String AFPDATASTREAM_TEMP_FILE_PREFIX = "AFPDataStream_";
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_EXTERNAL_RESOURCE_FILENAME = "resources.afp";
    private final Factory factory;
    private final Map pathResourceGroupMap = new HashMap();
    private StreamedResourceGroup printFileResourceGroup;
    private String defaultResourceGroupFilePath = "resources.afp";
    private File tempFile;
    private OutputStream documentOutputStream;
    private OutputStream outputStream;
    private RandomAccessFile documentFile;
    private DataStream dataStream;

    public AFPStreamer(Factory factory) {
        this.factory = factory;
    }

    public DataStream createDataStream(AFPPaintingState aFPPaintingState) throws IOException {
        this.tempFile = File.createTempFile(AFPDATASTREAM_TEMP_FILE_PREFIX, null);
        this.documentFile = new RandomAccessFile(this.tempFile, "rw");
        this.documentOutputStream = new BufferedOutputStream(new FileOutputStream(this.documentFile.getFD()));
        this.dataStream = this.factory.createDataStream(aFPPaintingState, this.documentOutputStream);
        return this.dataStream;
    }

    public void setDefaultResourceGroupFilePath(String string) {
        this.defaultResourceGroupFilePath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroup getResourceGroup(AFPResourceLevel aFPResourceLevel) {
        ResourceGroup resourceGroup = null;
        if (aFPResourceLevel.isInline()) {
            return null;
        }
        if (aFPResourceLevel.isExternal()) {
            String string = aFPResourceLevel.getExternalFilePath();
            if (string == null) {
                LOG.warn((Object)"No file path provided for external resource, using default.");
                string = this.defaultResourceGroupFilePath;
            }
            if ((resourceGroup = (ResourceGroup)this.pathResourceGroupMap.get(string)) == null) {
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.error((Object)("Failed to create/open external resource group file '" + string + "'"));
                }
                finally {
                    if (bufferedOutputStream != null) {
                        resourceGroup = this.factory.createStreamedResourceGroup(bufferedOutputStream);
                        this.pathResourceGroupMap.put(string, resourceGroup);
                    }
                }
            }
        } else if (aFPResourceLevel.isPrintFile()) {
            if (this.printFileResourceGroup == null) {
                this.printFileResourceGroup = this.factory.createStreamedResourceGroup(this.outputStream);
            }
            resourceGroup = this.printFileResourceGroup;
        } else {
            resourceGroup = this.dataStream.getResourceGroup(aFPResourceLevel);
        }
        return resourceGroup;
    }

    public void close() throws IOException {
        for (StreamedResourceGroup streamedResourceGroup : this.pathResourceGroupMap.values()) {
            streamedResourceGroup.close();
        }
        if (this.printFileResourceGroup != null) {
            this.printFileResourceGroup.close();
        }
        this.writeToStream(this.outputStream);
        this.outputStream.close();
        if (this.documentOutputStream != null) {
            this.documentOutputStream.close();
        }
        if (this.documentFile != null) {
            this.documentFile.close();
        }
        this.tempFile.delete();
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n = (int)this.documentFile.length();
        int n2 = n / 4096;
        int n3 = n % 4096;
        this.documentFile.seek(0L);
        if (n2 > 0) {
            byArray = new byte[4096];
            for (int i = 0; i < n2; ++i) {
                this.documentFile.read(byArray, 0, 4096);
                outputStream.write(byArray, 0, 4096);
            }
        } else {
            byArray = new byte[n3];
        }
        if (n3 > 0) {
            this.documentFile.read(byArray, 0, n3);
            outputStream.write(byArray, 0, n3);
        }
        outputStream.flush();
    }
}

