/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.modca.GraphicsObject;
import org.apache.fop.afp.svg.AFPGraphicsConfiguration;
import org.apache.fop.afp.util.CubicBezierApproximator;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.afp.AFPImageHandlerRenderedImage;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.StrokingTextHandler;
import org.apache.xmlgraphics.java2d.TextHandler;

public class AFPGraphics2D
extends AbstractGraphics2D
implements NativeImageHandler {
    private static final Log LOG = LogFactory.getLog(AFPGraphics2D.class);
    private static final int X = 0;
    private static final int Y = 1;
    private static final int X1 = 0;
    private static final int Y1 = 1;
    private static final int X2 = 2;
    private static final int Y2 = 3;
    private static final int X3 = 4;
    private static final int Y3 = 5;
    private GraphicsObject graphicsObj = null;
    protected TextHandler fallbackTextHandler = new StrokingTextHandler();
    protected TextHandler customTextHandler = null;
    private AFPResourceManager resourceManager = null;
    private AFPResourceInfo resourceInfo = null;
    private AFPPaintingState paintingState = null;
    private final AFPGraphicsConfiguration graphicsConfig = new AFPGraphicsConfiguration();
    private FontInfo fontInfo;

    public AFPGraphics2D(boolean bl, AFPPaintingState aFPPaintingState, AFPResourceManager aFPResourceManager, AFPResourceInfo aFPResourceInfo, FontInfo fontInfo) {
        super(bl);
        this.setPaintingState(aFPPaintingState);
        this.setResourceManager(aFPResourceManager);
        this.setResourceInfo(aFPResourceInfo);
        this.setFontInfo(fontInfo);
    }

    public AFPGraphics2D(AFPGraphics2D aFPGraphics2D) {
        super((AbstractGraphics2D)aFPGraphics2D);
        this.paintingState = aFPGraphics2D.paintingState;
        this.resourceManager = aFPGraphics2D.resourceManager;
        this.resourceInfo = aFPGraphics2D.resourceInfo;
        this.fontInfo = aFPGraphics2D.fontInfo;
        this.graphicsObj = aFPGraphics2D.graphicsObj;
        this.fallbackTextHandler = aFPGraphics2D.fallbackTextHandler;
        this.customTextHandler = aFPGraphics2D.customTextHandler;
    }

    private void setResourceManager(AFPResourceManager aFPResourceManager) {
        this.resourceManager = aFPResourceManager;
    }

    public AFPResourceManager getResourceManager() {
        return this.resourceManager;
    }

    private void setResourceInfo(AFPResourceInfo aFPResourceInfo) {
        this.resourceInfo = aFPResourceInfo;
    }

    public GraphicsObject getGraphicsObject() {
        return this.graphicsObj;
    }

    public void setGraphicsObject(GraphicsObject graphicsObject) {
        this.graphicsObj = graphicsObject;
    }

    private void setPaintingState(AFPPaintingState aFPPaintingState) {
        this.paintingState = aFPPaintingState;
    }

    public AFPPaintingState getPaintingState() {
        return this.paintingState;
    }

    private void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    private int getResolution() {
        return this.paintingState.getResolution();
    }

    public double convertToAbsoluteLength(double d) {
        AffineTransform affineTransform = this.getTransform();
        double d2 = (double)this.getResolution() / 72.0;
        double d3 = -affineTransform.getScaleY() / d2;
        return d * d3;
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float f = basicStroke.getLineWidth();
            float f2 = this.paintingState.getLineWidthCorrection();
            this.graphicsObj.setLineWidth(f * f2);
            float[] fArray = basicStroke.getDashArray();
            if (this.paintingState.setDashArray(fArray)) {
                int n = 0;
                if (fArray != null) {
                    n = 1;
                    if (fArray.length == 2) {
                        if (fArray[0] < fArray[1]) {
                            n = 2;
                        } else if (fArray[0] > fArray[1]) {
                            n = 5;
                        }
                    } else if (fArray.length == 4) {
                        if (fArray[0] > fArray[1] && fArray[2] < fArray[3]) {
                            n = 3;
                        } else if (fArray[0] < fArray[1] && fArray[2] < fArray[3]) {
                            n = 4;
                        }
                    } else if (fArray.length == 6 && fArray[0] > fArray[1] && fArray[2] < fArray[3] && fArray[4] < fArray[5]) {
                        n = 6;
                    }
                }
                this.graphicsObj.setLineType((byte)n);
            }
        } else {
            LOG.warn((Object)("Unsupported Stroke: " + stroke.getClass().getName()));
        }
    }

    private boolean applyPaint(Paint paint, boolean bl) {
        if (paint instanceof Color) {
            return true;
        }
        LOG.debug((Object)("NYI: applyPaint() " + paint + " fill=" + bl));
        if (paint instanceof TexturePaint) {
            // empty if block
        }
        return false;
    }

    private void doDrawing(Shape shape, boolean bl) {
        if (!bl) {
            this.graphicsObj.newSegment();
        }
        this.graphicsObj.setColor(this.gc.getColor());
        this.applyPaint(this.gc.getPaint(), bl);
        if (bl) {
            this.graphicsObj.beginArea();
        } else {
            this.applyStroke(this.gc.getStroke());
        }
        AffineTransform affineTransform = this.gc.getTransform();
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        if (shape instanceof Line2D) {
            double[] dArray = new double[6];
            pathIterator.currentSegment(dArray);
            int[] nArray = new int[4];
            nArray[0] = (int)Math.round(dArray[0]);
            nArray[1] = (int)Math.round(dArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(dArray);
            nArray[2] = (int)Math.round(dArray[0]);
            nArray[3] = (int)Math.round(dArray[1]);
            this.graphicsObj.addLine(nArray);
        } else if (shape instanceof Rectangle2D) {
            double[] dArray = new double[6];
            pathIterator.currentSegment(dArray);
            int[] nArray = new int[4];
            nArray[2] = (int)Math.round(dArray[0]);
            nArray[3] = (int)Math.round(dArray[1]);
            pathIterator.next();
            pathIterator.next();
            pathIterator.currentSegment(dArray);
            nArray[0] = (int)Math.round(dArray[0]);
            nArray[1] = (int)Math.round(dArray[1]);
            this.graphicsObj.addBox(nArray);
        } else if (shape instanceof Ellipse2D) {
            double[] dArray = new double[6];
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            double d = affineTransform.getScaleX();
            double d2 = ellipse2D.getWidth() / 2.0;
            double d3 = ellipse2D.getHeight() / 2.0;
            this.graphicsObj.setArcParams((int)Math.round(d2 * d), (int)Math.round(d3 * d), 0, 0);
            double[] dArray2 = new double[]{ellipse2D.getCenterX(), ellipse2D.getCenterY()};
            affineTransform.transform(dArray2, 0, dArray, 0, 1);
            this.graphicsObj.addFullArc((int)Math.round(dArray[0]), (int)Math.round(dArray[1]), 1, 0);
        } else {
            this.processPathIterator(pathIterator);
        }
        if (bl) {
            this.graphicsObj.endArea();
        }
    }

    private void processPathIterator(PathIterator pathIterator) {
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        int[] nArray = new int[2];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 1: {
                    this.graphicsObj.addLine(new int[]{(int)Math.round(dArray[0]), (int)Math.round(dArray[1])}, true);
                    dArray2 = new double[]{dArray[0], dArray[1]};
                    break;
                }
                case 2: {
                    this.graphicsObj.addFillet(new int[]{(int)Math.round(dArray[0]), (int)Math.round(dArray[1]), (int)Math.round(dArray[2]), (int)Math.round(dArray[3])}, true);
                    dArray2 = new double[]{dArray[2], dArray[3]};
                    break;
                }
                case 3: {
                    double[] dArray3 = new double[]{dArray2[0], dArray2[1], dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]};
                    double[][] dArray4 = CubicBezierApproximator.fixedMidPointApproximation(dArray3);
                    if (dArray4.length < 4) break;
                    for (int i = 0; i < dArray4.length; ++i) {
                        double[] dArray5 = dArray4[i];
                        if (dArray5 == null || dArray5.length != 4) continue;
                        this.graphicsObj.addFillet(new int[]{(int)Math.round(dArray5[0]), (int)Math.round(dArray5[1]), (int)Math.round(dArray5[2]), (int)Math.round(dArray5[3])}, true);
                        dArray2 = new double[]{dArray5[2], dArray5[3]};
                    }
                    break;
                }
                case 0: {
                    nArray = new int[]{(int)Math.round(dArray[0]), (int)Math.round(dArray[1])};
                    dArray2 = new double[]{dArray[0], dArray[1]};
                    this.graphicsObj.setCurrentPosition(nArray);
                    break;
                }
                case 4: {
                    this.graphicsObj.addLine(nArray, true);
                    dArray2 = new double[]{nArray[0], nArray[1]};
                    break;
                }
                default: {
                    LOG.debug((Object)"Unrecognised path iterator type");
                }
            }
            pathIterator.next();
        }
    }

    public void draw(Shape shape) {
        LOG.debug((Object)("draw() shape=" + shape));
        this.doDrawing(shape, false);
    }

    public void fill(Shape shape) {
        LOG.debug((Object)("fill() shape=" + shape));
        this.doDrawing(shape, true);
    }

    public void handleIOException(IOException iOException) {
        LOG.error((Object)iOException.getMessage());
        iOException.printStackTrace();
    }

    public void drawString(String string, float f, float f2) {
        try {
            if (this.customTextHandler != null && !this.textAsShapes) {
                this.customTextHandler.drawString((Graphics2D)((Object)this), string, f, f2);
            } else {
                this.fallbackTextHandler.drawString((Graphics2D)((Object)this), string, f, f2);
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public Graphics create() {
        return new AFPGraphics2D(this);
    }

    public void dispose() {
        this.graphicsObj = null;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    private BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawBufferedImage(Image image, BufferedImage bufferedImage, int n, int n2, ImageObserver imageObserver) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.SrcOver);
            Color color = new Color(1, 1, 1, 0);
            graphics2D.setBackground(color);
            graphics2D.setPaint(color);
            graphics2D.fillRect(0, 0, n, n2);
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n3, n4);
            graphics2D.clip(rectangle);
            graphics2D.setComposite(this.gc.getComposite());
            boolean bl = graphics2D.drawImage(image, 0, 0, n3, n4, imageObserver);
            return bl;
        }
        finally {
            graphics2D.dispose();
        }
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Dimension dimension = new Dimension(n3, n4);
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        boolean bl = this.drawBufferedImage(image, bufferedImage, n3, n4, imageObserver);
        if (bl) {
            this.drawRenderedImage(bufferedImage, new AffineTransform());
        }
        return false;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        AffineTransform affineTransform2 = this.gc.getTransform();
        int n3 = this.graphicsObj.getObjectEnvironmentGroup().getObjectAreaDescriptor().getHeight();
        double d = 72000.0 / (double)this.paintingState.getResolution();
        double d2 = affineTransform2.getTranslateX();
        double d3 = -(affineTransform2.getTranslateY() - (double)n3);
        d2 = d * d2;
        d3 = d * d3;
        double d4 = d * (double)n * affineTransform2.getScaleX();
        double d5 = d * (double)n2 * -affineTransform2.getScaleY();
        AFPImageHandlerRenderedImage aFPImageHandlerRenderedImage = new AFPImageHandlerRenderedImage();
        ImageInfo imageInfo = new ImageInfo(null, null);
        imageInfo.setSize(new ImageSize(renderedImage.getWidth(), renderedImage.getHeight(), (double)this.paintingState.getResolution()));
        imageInfo.getSize().calcSizeFromPixels();
        ImageRendered imageRendered = new ImageRendered(imageInfo, renderedImage, null);
        Rectangle rectangle = new Rectangle((int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5));
        AFPRenderingContext aFPRenderingContext = new AFPRenderingContext(null, this.resourceManager, this.paintingState, this.fontInfo, null);
        try {
            aFPImageHandlerRenderedImage.handleImage(aFPRenderingContext, (org.apache.xmlgraphics.image.loader.Image)imageRendered, rectangle);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public void setCustomTextHandler(TextHandler textHandler) {
        this.customTextHandler = textHandler;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        LOG.debug((Object)("drawRenderableImage() NYI: img=" + renderableImage + ", xform=" + affineTransform));
    }

    public FontMetrics getFontMetrics(Font font) {
        LOG.debug((Object)("getFontMetrics() NYI: f=" + font));
        return null;
    }

    public void setXORMode(Color color) {
        LOG.debug((Object)("setXORMode() NYI: col=" + color));
    }

    public void addNativeImage(org.apache.xmlgraphics.image.loader.Image image, float f, float f2, float f3, float f4) {
        LOG.debug((Object)("NYI: addNativeImage() image=" + image + ",x=" + f + ",y=" + f2 + ",width=" + f3 + ",height=" + f4));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        LOG.debug((Object)"copyArea() NYI: ");
    }
}

