/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.PaintingInfo;
import org.apache.fop.afp.RectanglePaintingInfo;
import org.apache.fop.util.bitmap.DitherUtil;
import org.apache.xmlgraphics.image.loader.ImageSize;

public class AFPDitheredRectanglePainter
extends AbstractAFPPainter {
    private AFPResourceManager resourceManager;

    public AFPDitheredRectanglePainter(AFPPaintingState aFPPaintingState, DataStream dataStream, AFPResourceManager aFPResourceManager) {
        super(aFPPaintingState, dataStream);
        this.resourceManager = aFPResourceManager;
    }

    public void paint(PaintingInfo paintingInfo) throws IOException {
        RectanglePaintingInfo rectanglePaintingInfo = (RectanglePaintingInfo)paintingInfo;
        if (rectanglePaintingInfo.getWidth() <= 0.0f || rectanglePaintingInfo.getHeight() <= 0.0f) {
            return;
        }
        int n = 8;
        Dimension dimension = new Dimension(n, n);
        AFPImageObjectInfo aFPImageObjectInfo = new AFPImageObjectInfo();
        aFPImageObjectInfo.setMimeType("image/x-afp+fs10");
        aFPImageObjectInfo.getResourceInfo().setLevel(new AFPResourceLevel(0));
        aFPImageObjectInfo.getResourceInfo().setImageDimension(dimension);
        aFPImageObjectInfo.setBitsPerPixel(1);
        aFPImageObjectInfo.setColor(false);
        aFPImageObjectInfo.setMappingOption((byte)80);
        int n2 = this.paintingState.getResolution();
        ImageSize imageSize = new ImageSize(dimension.width, dimension.height, (double)n2);
        aFPImageObjectInfo.setDataHeightRes((int)Math.round(imageSize.getDpiHorizontal() * 10.0));
        aFPImageObjectInfo.setDataWidthRes((int)Math.round(imageSize.getDpiVertical() * 10.0));
        aFPImageObjectInfo.setDataWidth(dimension.width);
        aFPImageObjectInfo.setDataHeight(dimension.height);
        Color color = this.paintingState.getColor();
        byte[] byArray = DitherUtil.getBayerDither(n, color, false);
        aFPImageObjectInfo.setData(byArray);
        int n3 = this.paintingState.getRotation();
        AffineTransform affineTransform = this.paintingState.getData().getTransform();
        Point2D point2D = affineTransform.transform(new Point2D.Float(rectanglePaintingInfo.getX() * 1000.0f, rectanglePaintingInfo.getY() * 1000.0f), null);
        AFPUnitConverter aFPUnitConverter = this.paintingState.getUnitConverter();
        float f = aFPUnitConverter.pt2units(rectanglePaintingInfo.getWidth());
        float f2 = aFPUnitConverter.pt2units(rectanglePaintingInfo.getHeight());
        AFPObjectAreaInfo aFPObjectAreaInfo = new AFPObjectAreaInfo((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()), Math.round(f), Math.round(f2), n2, n3);
        aFPImageObjectInfo.setObjectAreaInfo(aFPObjectAreaInfo);
        this.resourceManager.createObject(aFPImageObjectInfo);
    }
}

