/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.accessibility.fo.FOEventRecorder;
import org.apache.fop.accessibility.fo.StructureTreeEventTrigger;
import org.apache.fop.fo.DelegatingFOEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;

public class FO2StructureTreeConverter
extends DelegatingFOEventHandler {
    private FOEventHandler converter;
    private final Stack<FOEventHandler> converters = new Stack();
    private final Stack<FOEventRecorder> tableFooterRecorders = new Stack();
    private final FOEventHandler structureTreeEventTrigger;
    private final FOEventHandler eventSwallower = new FOEventHandler(){};

    public FO2StructureTreeConverter(StructureTreeEventHandler structureTreeEventHandler, FOEventHandler fOEventHandler) {
        super(fOEventHandler);
        this.converter = this.structureTreeEventTrigger = new StructureTreeEventTrigger(structureTreeEventHandler);
    }

    public void startDocument() throws SAXException {
        this.converter.startDocument();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.converter.endDocument();
        super.endDocument();
    }

    public void startRoot(Root root) {
        this.converter.startRoot(root);
        super.startRoot(root);
    }

    public void endRoot(Root root) {
        this.converter.endRoot(root);
        super.endRoot(root);
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.converter.startPageSequence(pageSequence);
        super.startPageSequence(pageSequence);
    }

    public void endPageSequence(PageSequence pageSequence) {
        this.converter.endPageSequence(pageSequence);
        super.endPageSequence(pageSequence);
    }

    public void startPageNumber(PageNumber pageNumber) {
        this.converter.startPageNumber(pageNumber);
        super.startPageNumber(pageNumber);
    }

    public void endPageNumber(PageNumber pageNumber) {
        this.converter.endPageNumber(pageNumber);
        super.endPageNumber(pageNumber);
    }

    public void startPageNumberCitation(PageNumberCitation pageNumberCitation) {
        this.converter.startPageNumberCitation(pageNumberCitation);
        super.startPageNumberCitation(pageNumberCitation);
    }

    public void endPageNumberCitation(PageNumberCitation pageNumberCitation) {
        this.converter.endPageNumberCitation(pageNumberCitation);
        super.endPageNumberCitation(pageNumberCitation);
    }

    public void startPageNumberCitationLast(PageNumberCitationLast pageNumberCitationLast) {
        this.converter.startPageNumberCitationLast(pageNumberCitationLast);
        super.startPageNumberCitationLast(pageNumberCitationLast);
    }

    public void endPageNumberCitationLast(PageNumberCitationLast pageNumberCitationLast) {
        this.converter.endPageNumberCitationLast(pageNumberCitationLast);
        super.endPageNumberCitationLast(pageNumberCitationLast);
    }

    public void startFlow(Flow flow) {
        this.converter.startFlow(flow);
        super.startFlow(flow);
    }

    public void endFlow(Flow flow) {
        this.converter.endFlow(flow);
        super.endFlow(flow);
    }

    public void startBlock(Block block) {
        this.converter.startBlock(block);
        super.startBlock(block);
    }

    public void endBlock(Block block) {
        this.converter.endBlock(block);
        super.endBlock(block);
    }

    public void startBlockContainer(BlockContainer blockContainer) {
        this.converter.startBlockContainer(blockContainer);
        super.startBlockContainer(blockContainer);
    }

    public void endBlockContainer(BlockContainer blockContainer) {
        this.converter.endBlockContainer(blockContainer);
        super.endBlockContainer(blockContainer);
    }

    public void startInline(Inline inline) {
        this.converter.startInline(inline);
        super.startInline(inline);
    }

    public void endInline(Inline inline) {
        this.converter.endInline(inline);
        super.endInline(inline);
    }

    public void startTable(Table table) {
        this.converter.startTable(table);
        this.tableFooterRecorders.push(null);
        super.startTable(table);
    }

    public void endTable(Table table) {
        FOEventRecorder fOEventRecorder = this.tableFooterRecorders.pop();
        if (fOEventRecorder != null) {
            fOEventRecorder.replay(this.converter);
        }
        this.converter.endTable(table);
        super.endTable(table);
    }

    public void startColumn(TableColumn tableColumn) {
        this.converter.startColumn(tableColumn);
        super.startColumn(tableColumn);
    }

    public void endColumn(TableColumn tableColumn) {
        this.converter.endColumn(tableColumn);
        super.endColumn(tableColumn);
    }

    public void startHeader(TableHeader tableHeader) {
        this.converter.startHeader(tableHeader);
        super.startHeader(tableHeader);
    }

    public void endHeader(TableHeader tableHeader) {
        this.converter.endHeader(tableHeader);
        super.endHeader(tableHeader);
    }

    public void startFooter(TableFooter tableFooter) {
        this.converters.push(this.converter);
        this.converter = new FOEventRecorder();
        this.converter.startFooter(tableFooter);
        super.startFooter(tableFooter);
    }

    public void endFooter(TableFooter tableFooter) {
        this.converter.endFooter(tableFooter);
        this.tableFooterRecorders.pop();
        this.tableFooterRecorders.push((FOEventRecorder)this.converter);
        this.converter = this.converters.pop();
        super.endFooter(tableFooter);
    }

    public void startBody(TableBody tableBody) {
        this.converter.startBody(tableBody);
        super.startBody(tableBody);
    }

    public void endBody(TableBody tableBody) {
        this.converter.endBody(tableBody);
        super.endBody(tableBody);
    }

    public void startRow(TableRow tableRow) {
        this.converter.startRow(tableRow);
        super.startRow(tableRow);
    }

    public void endRow(TableRow tableRow) {
        this.converter.endRow(tableRow);
        super.endRow(tableRow);
    }

    public void startCell(TableCell tableCell) {
        this.converter.startCell(tableCell);
        super.startCell(tableCell);
    }

    public void endCell(TableCell tableCell) {
        this.converter.endCell(tableCell);
        super.endCell(tableCell);
    }

    public void startList(ListBlock listBlock) {
        this.converter.startList(listBlock);
        super.startList(listBlock);
    }

    public void endList(ListBlock listBlock) {
        this.converter.endList(listBlock);
        super.endList(listBlock);
    }

    public void startListItem(ListItem listItem) {
        this.converter.startListItem(listItem);
        super.startListItem(listItem);
    }

    public void endListItem(ListItem listItem) {
        this.converter.endListItem(listItem);
        super.endListItem(listItem);
    }

    public void startListLabel(ListItemLabel listItemLabel) {
        this.converter.startListLabel(listItemLabel);
        super.startListLabel(listItemLabel);
    }

    public void endListLabel(ListItemLabel listItemLabel) {
        this.converter.endListLabel(listItemLabel);
        super.endListLabel(listItemLabel);
    }

    public void startListBody(ListItemBody listItemBody) {
        this.converter.startListBody(listItemBody);
        super.startListBody(listItemBody);
    }

    public void endListBody(ListItemBody listItemBody) {
        this.converter.endListBody(listItemBody);
        super.endListBody(listItemBody);
    }

    public void startStatic(StaticContent staticContent) {
        this.handleStartArtifact(staticContent);
        this.converter.startStatic(staticContent);
        super.startStatic(staticContent);
    }

    public void endStatic(StaticContent staticContent) {
        this.converter.endStatic(staticContent);
        this.handleEndArtifact(staticContent);
        super.endStatic(staticContent);
    }

    public void startMarkup() {
        this.converter.startMarkup();
        super.startMarkup();
    }

    public void endMarkup() {
        this.converter.endMarkup();
        super.endMarkup();
    }

    public void startLink(BasicLink basicLink) {
        this.converter.startLink(basicLink);
        super.startLink(basicLink);
    }

    public void endLink(BasicLink basicLink) {
        this.converter.endLink(basicLink);
        super.endLink(basicLink);
    }

    public void image(ExternalGraphic externalGraphic) {
        this.converter.image(externalGraphic);
        super.image(externalGraphic);
    }

    public void pageRef() {
        this.converter.pageRef();
        super.pageRef();
    }

    public void startInstreamForeignObject(InstreamForeignObject instreamForeignObject) {
        this.converter.startInstreamForeignObject(instreamForeignObject);
        super.startInstreamForeignObject(instreamForeignObject);
    }

    public void endInstreamForeignObject(InstreamForeignObject instreamForeignObject) {
        this.converter.endInstreamForeignObject(instreamForeignObject);
        super.endInstreamForeignObject(instreamForeignObject);
    }

    public void startFootnote(Footnote footnote) {
        this.converter.startFootnote(footnote);
        super.startFootnote(footnote);
    }

    public void endFootnote(Footnote footnote) {
        this.converter.endFootnote(footnote);
        super.endFootnote(footnote);
    }

    public void startFootnoteBody(FootnoteBody footnoteBody) {
        this.converter.startFootnoteBody(footnoteBody);
        super.startFootnoteBody(footnoteBody);
    }

    public void endFootnoteBody(FootnoteBody footnoteBody) {
        this.converter.endFootnoteBody(footnoteBody);
        super.endFootnoteBody(footnoteBody);
    }

    public void startLeader(Leader leader) {
        this.converters.push(this.converter);
        this.converter = this.eventSwallower;
        this.converter.startLeader(leader);
        super.startLeader(leader);
    }

    public void endLeader(Leader leader) {
        this.converter.endLeader(leader);
        this.converter = this.converters.pop();
        super.endLeader(leader);
    }

    public void startWrapper(Wrapper wrapper) {
        this.handleStartArtifact(wrapper);
        this.converter.startWrapper(wrapper);
        super.startWrapper(wrapper);
    }

    public void endWrapper(Wrapper wrapper) {
        this.converter.endWrapper(wrapper);
        this.handleEndArtifact(wrapper);
        super.endWrapper(wrapper);
    }

    public void character(Character character) {
        this.converter.character(character);
        super.character(character);
    }

    public void characters(FOText fOText) {
        this.converter.characters(fOText);
        super.characters(fOText);
    }

    public void startExternalDocument(ExternalDocument externalDocument) {
        this.converter.startExternalDocument(externalDocument);
        super.startExternalDocument(externalDocument);
    }

    public void endExternalDocument(ExternalDocument externalDocument) {
        this.converter.endExternalDocument(externalDocument);
        super.endExternalDocument(externalDocument);
    }

    private void handleStartArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        if (this.isArtifact(commonAccessibilityHolder)) {
            this.converters.push(this.converter);
            this.converter = this.eventSwallower;
        }
    }

    private void handleEndArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        if (this.isArtifact(commonAccessibilityHolder)) {
            this.converter = this.converters.pop();
        }
    }

    private boolean isArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        CommonAccessibility commonAccessibility = commonAccessibilityHolder.getCommonAccessibility();
        return "artifact".equalsIgnoreCase(commonAccessibility.getRole());
    }
}

