/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public interface TransitionTarget {
    public void paintTarget(Graphics2D var1);

    public void init();

    public Dimension getTargetSize();

    public static class EmptyTransitionTarget
    implements TransitionTarget {
        @Override
        public void paintTarget(Graphics2D graphics2D) {
        }

        @Override
        public void init() {
        }

        @Override
        public Dimension getTargetSize() {
            return new Dimension(0, 0);
        }
    }

    public static final class StateChangeTransitionTarget
    extends ComponentTransitionTarget {
        private final TransitionTarget fEndTarget;
        private final Runnable fStateChangeRunnable;
        private boolean fInitialized;

        public StateChangeTransitionTarget(JComponent jComponent, Runnable runnable) {
            super(jComponent);
            this.fStateChangeRunnable = runnable;
            this.fEndTarget = new ComponentTransitionTarget(jComponent);
        }

        @Override
        public void init() {
            super.init();
            this.fStateChangeRunnable.run();
        }

        public TransitionTarget getEndTransitionTarget() {
            return this.fEndTarget;
        }
    }

    public static class ComponentTransitionTarget
    implements TransitionTarget {
        private final Component fComponent;
        private BufferedImage fImage;

        public ComponentTransitionTarget(Component component) {
            this.fComponent = component;
        }

        @Override
        public void init() {
            this.updateRender();
        }

        private BufferedImage paintComponentIntoImage(BufferedImage bufferedImage, Component component) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            component.paint(graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        public void paintTarget(Graphics2D graphics2D) {
            if (this.fImage == null) {
                return;
            }
            graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        }

        @Override
        public Dimension getTargetSize() {
            return this.fImage != null ? new Dimension(this.fImage.getWidth(), this.fImage.getHeight()) : new Dimension(0, 0);
        }

        protected void updateRender() {
            this.fImage = this.fComponent.getWidth() > 0 && this.fComponent.getHeight() > 0 ? this.paintComponentIntoImage(new BufferedImage(this.fComponent.getWidth(), this.fComponent.getHeight(), 2), this.fComponent) : null;
        }
    }
}

