/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.verification;

import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.logui.LogMessage;
import com.mathworks.project.impl.logui.LogMessageType;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.DefaultTestHarnessAdapter;
import com.mathworks.toolbox.coder.app.PopupBarContent;
import com.mathworks.toolbox.coder.app.TestHarness;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.wfa.core.CustomCommandWindow;
import com.mathworks.toolbox.coder.wfa.core.PopupBarOptionPanel;
import com.mathworks.toolbox.coder.wfa.verification.TestOutputArea;

public abstract class TestOptionPanel
extends PopupBarOptionPanel
implements PopupBarContent {
    private final CoderApp fApp;
    private final CustomCommandWindow fCommandWindow;
    private final TestOutputArea fOutputArea;
    private final TestHarness fTestHarness;

    public TestOptionPanel(CoderApp coderApp, MJToggleButton mJToggleButton, TestOutputArea testOutputArea) {
        super(mJToggleButton);
        this.fApp = coderApp;
        this.fOutputArea = testOutputArea;
        this.fCommandWindow = new CustomCommandWindow(coderApp.getModel().getTestSnippets()){

            @Override
            protected void run(String string, Runnable runnable) {
                TestOptionPanel.this.runAction(runnable);
            }
        };
        this.fTestHarness = new TestHarness(this.fApp.getModel(), new DefaultTestHarnessAdapter(this.fCommandWindow));
    }

    protected final CoderApp getApp() {
        return this.fApp;
    }

    protected final CustomCommandWindow getCommandWindow() {
        return this.fCommandWindow;
    }

    @Override
    public void runAction() {
        this.fCommandWindow.run();
    }

    protected void runAction(Runnable runnable) {
        String string = this.fCommandWindow.getText().trim();
        if (string.isEmpty()) {
            return;
        }
        TestOutputArea.Mode mode = this.getMode();
        this.fOutputArea.display(mode);
        if (mode == TestOutputArea.Mode.BOTH) {
            final Runnable runnable2 = runnable;
            runnable = new Runnable(){
                private int count;

                @Override
                public void run() {
                    if (++this.count == 2 && runnable2 != null) {
                        runnable2.run();
                    }
                }
            };
        }
        if (mode == TestOutputArea.Mode.ORIGINAL_OUTPUT || mode == TestOutputArea.Mode.BOTH) {
            this.fOutputArea.getOriginalOutput().write(new LogMessage(">> " + string, LogMessageType.COMMAND));
            this.fTestHarness.run(string, this.fOutputArea.getOriginalOutput(), TestBenchRunMode.RUN_ORIGINAL, runnable);
        }
        if (mode == TestOutputArea.Mode.GENERATED_OUTPUT || mode == TestOutputArea.Mode.BOTH) {
            this.fTestHarness.run(string, this.fOutputArea.getGeneratedOutput(), TestBenchRunMode.RUN_COMPILED, runnable);
            this.fOutputArea.getGeneratedOutput().write(new LogMessage(">> " + string, LogMessageType.COMMAND));
        }
    }

    @Override
    public final void activate() {
        this.updateOptions();
        this.fCommandWindow.activate();
    }

    @Override
    public final String getCloseButtonText() {
        return BuiltInResources.getString((String)"button.close");
    }

    protected void updateOptions() {
    }

    protected abstract TestOutputArea.Mode getMode();
}

