/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.toolbar;

import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JComponent;

public final class ToolbarUtils {
    public static final Color DISABLED_COLOR = new Color(200, 200, 200);
    private static final String CONFIGURED_PROPERTY = "_ToolbarUtils_configured";

    private ToolbarUtils() {
    }

    public static void configure(final ToolbarButton toolbarButton) {
        JComponent jComponent = (JComponent)((Object)toolbarButton);
        if (jComponent.getClientProperty(CONFIGURED_PROPERTY) == null) {
            jComponent.setBorder(null);
            jComponent.setOpaque(false);
            toolbarButton.setCursor(Cursor.getPredefinedCursor(toolbarButton.isEnabled() ? 12 : 0));
            toolbarButton.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    toolbarButton.setCursor(Cursor.getPredefinedCursor(toolbarButton.isEnabled() ? 12 : 0));
                }
            });
            jComponent.putClientProperty(CONFIGURED_PROPERTY, true);
        }
    }

    public static void paint(ToolbarButton toolbarButton, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, toolbarButton.getWidth(), toolbarButton.getHeight());
        graphics2D.setColor(toolbarButton.isEnabled() ? Color.WHITE : DISABLED_COLOR);
        toolbarButton.paintContent(graphics2D);
        graphics2D.dispose();
    }

    public static int getTextWidth(String string) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(CoderApp.getFont());
        double d = graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
        graphics2D.dispose();
        return (int)Math.ceil(d);
    }

    public static void drawString(Component component, Graphics2D graphics2D, String string, double d) {
        graphics2D.setFont(CoderApp.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.drawString(string, (float)d, (float)(component.getHeight() / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent()));
    }

    public static String getTestButtonToolTip(CoderApp coderApp) {
        String string = coderApp.getModel().getTestSnippets().getLastCommand();
        if (string != null) {
            return MessageFormat.format(CoderResources.getString("wfa.test.tooltip"), string);
        }
        return null;
    }
}

