/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.synthesis;

import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.app.Artifact;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEView;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.build.SettingsPanel;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.synthesis.CreateProjectButton;
import com.mathworks.toolbox.coder.wfa.synthesis.PlaceAndRouteButton;
import com.mathworks.toolbox.coder.wfa.synthesis.SynthesizeButton;
import com.mathworks.toolbox.coder.wfa.toolbar.SaveButton;
import com.mathworks.toolbox.coder.wfa.toolbar.Separator;
import com.mathworks.toolbox.coder.wfa.toolbar.SettingsButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SynthesisView
extends AbstractCoderStepView {
    private final MJToggleButton fSettings;
    private final SettingsPanel fSettingsPanel;
    private final SaveButton fSaveButton;
    private final CreateProjectButton fCreateProjectButton;
    private final SynthesizeButton fSynthesizeButton;
    private final PlaceAndRouteButton fPlaceAndRouteButton;
    private final List<Component> fToolbarComponents;
    private final IDEContext fContext = new Context();
    private ToolbarContext fToolbarContext;

    public SynthesisView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fSaveButton = new SaveButton(coderApp);
        this.fToolbarComponents = new ArrayList<Component>();
        this.fSettings = new SettingsButton();
        this.fSettings.setToolTipText(CoderResources.getString("app.action.settings"));
        this.fSettings.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SynthesisView.this.startSettingsExpandOrCollapse();
            }
        });
        this.fCreateProjectButton = new CreateProjectButton();
        this.fSynthesizeButton = new SynthesizeButton();
        this.fPlaceAndRouteButton = new PlaceAndRouteButton();
        this.updateToolbarComponents();
        this.fSettingsPanel = new SettingsPanel(this.getApp(), new Runnable(){

            @Override
            public void run() {
                SynthesisView.this.closeSheet(SynthesisView.this.fSettingsPanel.getComponent());
            }
        });
        this.getApp().getIDEView().getFileSets().addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.getApp().getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "generic-artifact" || propertyChangeEvent.getPropertyName() == "artifact" || propertyChangeEvent.getPropertyName().equals("param.UseECoderFeatures")) {
                    SynthesisView.this.updateToolbarComponents();
                }
            }
        });
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        this.fToolbarContext = toolbarContext;
        toolbarContext.setStepComponents(this.fToolbarComponents);
        this.installIDEView(this.fContext);
        IDEView iDEView = this.getApp().getIDEView();
        this.fContext.clearBanner();
        if (iDEView.getFileSets().getSelectedFile() == null) {
            iDEView.getFileSets().select((File)this.getApp().getModel().getEntryPointFileSet().getFiles().iterator().next());
        }
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    protected String getHelpKey() {
        return "help_button_synthesis";
    }

    private boolean isSilSupported() {
        return this.getApp().getModel().getConfiguration().getParamAsBoolean("param.UseECoderFeatures") && this.getApp().getModel().getArtifact() == Artifact.STATIC_LIBRARY;
    }

    private void updateToolbarComponents() {
        this.fToolbarComponents.clear();
        this.fToolbarComponents.add((Component)((Object)this.fSaveButton));
        this.fToolbarComponents.add((Component)((Object)new Separator()));
        this.fToolbarComponents.add((Component)this.fSettings);
        this.fToolbarComponents.add((Component)((Object)this.fCreateProjectButton));
        this.fToolbarComponents.add((Component)((Object)this.fSynthesizeButton));
        this.fToolbarComponents.add((Component)((Object)this.fPlaceAndRouteButton));
        if (this.fToolbarContext != null) {
            this.fToolbarContext.setStepComponents(this.fToolbarComponents);
        }
    }

    private void startSettingsExpandOrCollapse() {
        if (this.fSettings.isSelected()) {
            this.displaySheet((Component)this.fSettingsPanel.getComponent(), 0, false, true, new Runnable(){

                @Override
                public void run() {
                    SynthesisView.this.fSettings.setSelected(false);
                }
            });
        } else {
            this.closeSheet(this.fSettingsPanel.getComponent());
        }
    }

    private class Context
    extends IDEContext {
        private Context() {
        }

        @Override
        public CodePopupController createCodePopupController(Window window, EditorView editorView) {
            return null;
        }
    }
}

