/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.setup;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.HintPopupFrame;
import com.mathworks.toolbox.coder.model.BuildErrorSeverity;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.CoderWorkflowFrame;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.DescriptionLabel;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.widgets.Widgets;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestFilter;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class ProjectLocationSelector {
    private final MJPanel fComponent;
    private final CoderApp fApp;
    private final StepModel fModel;
    private final MJTextField fProjectLocationField;
    private final RequestFilter fRenameProjectFile;
    private final MJPanel fContentWrapper;
    private HintPopupFrame fMessagePopUp;
    private MJPanel fWarning;
    private File fPresumptiveProjectFile;
    private boolean fOverrideListener;
    private boolean fAttempted;
    private double fWarningExpansionPhase;
    public static final String SELECTOR_PROPERTY = "ProjectLocationSelector";

    public ProjectLocationSelector(CoderApp coderApp, StepModel stepModel) {
        this.fApp = coderApp;
        this.fModel = stepModel;
        this.fContentWrapper = new MJPanel((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu, fill:d, 3dlu:grow", "3dlu, fill:d, 3dlu"));
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                Dimension dimension = ProjectLocationSelector.this.fContentWrapper.getPreferredSize();
                ProjectLocationSelector.this.fContentWrapper.setBounds(0, this.getHeight() - dimension.height, dimension.width, dimension.height);
                if (ProjectLocationSelector.this.fWarningExpansionPhase >= 1.0 && ProjectLocationSelector.this.fWarning != null) {
                    Dimension dimension2 = ProjectLocationSelector.this.fWarning.getPreferredSize();
                    ProjectLocationSelector.this.fWarning.setBounds(this.getWidth() / 2 - dimension2.width / 2, 6, dimension2.width, dimension2.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension dimension = ProjectLocationSelector.this.fContentWrapper.getPreferredSize();
                if (ProjectLocationSelector.this.fWarning != null) {
                    Dimension dimension2 = ProjectLocationSelector.this.fWarning.getPreferredSize();
                    return new Dimension(Math.max(dimension.width, dimension2.width), (int)((double)dimension.height + (double)(dimension2.height + 12) * ProjectLocationSelector.this.fWarningExpansionPhase));
                }
                return new Dimension(dimension.width, dimension.height);
            }
        };
        this.fComponent.setName("projectfile.selector.panel");
        this.fComponent.putClientProperty((Object)SELECTOR_PROPERTY, (Object)this);
        this.fComponent.setLayout(null);
        this.fComponent.add((Component)this.fContentWrapper);
        this.fProjectLocationField = new MJTextField();
        this.fProjectLocationField.setName("projectfile.textfield");
        this.fProjectLocationField.setColumns(30);
        this.update();
        CellConstraints cellConstraints = new CellConstraints();
        MJLabel mJLabel = new MJLabel(CoderResources.getString("wfa.projectfile.prompt"));
        mJLabel.setFont(DescriptionLabel.FONT);
        this.fProjectLocationField.setFont(CoderApp.getFont());
        this.fContentWrapper.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
        this.fContentWrapper.add((Component)this.fProjectLocationField, (Object)cellConstraints.xy(4, 2));
        this.fRenameProjectFile = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectLocationSelector.this.fOverrideListener = true;
                        if (ProjectLocationSelector.this.fPresumptiveProjectFile != null) {
                            ProjectLocationSelector.this.fApp.getModel().setProjectFile(ProjectLocationSelector.this.fPresumptiveProjectFile);
                        }
                        ProjectLocationSelector.this.fOverrideListener = false;
                    }
                });
            }
        }, 500);
        this.fProjectLocationField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProjectLocationSelector.this.hideMessage();
                ProjectLocationSelector.this.tryRenameProjectLocation();
            }
        });
        this.fProjectLocationField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ProjectLocationSelector.this.hideMessage();
                if (keyEvent.getKeyCode() == 10) {
                    ProjectLocationSelector.this.tryRenameProjectLocation();
                } else if (keyEvent.getKeyCode() == 27) {
                    ProjectLocationSelector.this.update();
                } else {
                    ProjectLocationSelector.this.fAttempted = false;
                }
            }
        });
        this.fApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProjectLocationSelector.this.update();
                if (propertyChangeEvent.getPropertyName().equals("overwrite-warning")) {
                    ProjectLocationSelector.this.updateWarningAndCompletionStatus();
                }
            }
        });
        Widgets.makeComponentLoseFocusOnClicks((Component)this.fProjectLocationField, new Runnable(){

            @Override
            public void run() {
                ProjectLocationSelector.this.fProjectLocationField.getParent().requestFocusInWindow();
            }
        });
        this.updateWarningAndCompletionStatus();
    }

    private void tryRenameProjectLocation() {
        if (this.fAttempted) {
            return;
        }
        this.fAttempted = true;
        String string = this.fProjectLocationField.getText().trim();
        if (string.isEmpty()) {
            this.update();
            return;
        }
        if (!new FileLocation(string).checkExtension(new String[]{"prj"})) {
            String string2 = MessageFormat.format(CoderResources.getString("wfa.entryPoint.unsupportedProjectExtension"), new FileLocation(string).getExtension());
            this.showMessage(string2);
            this.fProjectLocationField.setText(this.getProjectFilePath());
            return;
        }
        File file = new File(this.getProjectFilePath());
        File file2 = new File(string);
        if (!file2.getParent().equals(file.getParent())) {
            String string3 = CoderResources.getString("wfa.entryPoint.folderRestriction");
            this.showMessage(string3);
            this.fProjectLocationField.setText(this.getProjectFilePath());
            this.fPresumptiveProjectFile = null;
            return;
        }
        this.fPresumptiveProjectFile = file2;
        this.fRenameProjectFile.request();
    }

    void setEnabled(boolean bl) {
        this.fProjectLocationField.setEditable(bl);
        this.updateWarningAndCompletionStatus();
        if (!bl) {
            this.closeOverwriteWarning();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProjectLocationSelector.this.fOverrideListener) {
                    return;
                }
                String string = ProjectLocationSelector.this.getProjectFilePath();
                if (!string.isEmpty()) {
                    ProjectLocationSelector.this.fProjectLocationField.setText(string);
                }
            }
        });
    }

    private String getProjectFilePath() {
        if (this.fApp.getModel().getExplicitProjectFile() != null) {
            return this.fApp.getModel().getExplicitProjectFile().getAbsolutePath();
        }
        if (!this.fApp.getModel().getEntryPointFileSet().getFiles().isEmpty()) {
            if (this.fApp.getModel().hasOverwriteWarning()) {
                return this.fApp.getModel().getDefaultProjectFile().getAbsolutePath();
            }
            return this.fApp.getModel().getConfiguration().getFile().getAbsolutePath();
        }
        return "";
    }

    private void updateWarningAndCompletionStatus() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ProjectLocationSelector.this.fApp.getModel().hasOverwriteWarning()) {
                    ProjectLocationSelector.this.showOverwriteWarning();
                } else {
                    ProjectLocationSelector.this.closeOverwriteWarning();
                }
                ProjectLocationSelector.this.fModel.refreshCompletion(CoderStepModel.CHOOSE_SOURCE_FILES_STEP);
                ProjectLocationSelector.this.fModel.refreshCompletion(CoderStepModel.REVIEW_POTENTIAL_ISSUES_STEP);
                ProjectLocationSelector.this.fModel.refreshCompletion(CoderStepModel.CONVERT_TO_FIXED_POINT_STEP);
            }
        });
    }

    public void chooseOverwrite() {
        this.fApp.getModel().ignoreOverwriteWarning();
    }

    public void chooseReopen() {
        this.fApp.close();
        CoderApp.open(CoderWorkflowFrame.class, new File(this.fProjectLocationField.getText()));
    }

    public void showOverwriteWarning() {
        this.fWarning = new MJPanel();
        this.fWarning.setBackground(new Color(254, 253, 179));
        this.fWarning.add((Component)new HyperlinkTextLabel(CoderResources.getString("wfa.projectfile.overwrite"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                if (string.equals("overwrite")) {
                    ProjectLocationSelector.this.chooseOverwrite();
                } else {
                    ProjectLocationSelector.this.chooseReopen();
                }
            }
        }, false, "projectfile.overwrite.warning", CoderResources.getString("wfa.projectfile.overwrite")).getComponent());
        this.fComponent.add((Component)this.fWarning);
        this.fApp.getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

            @Override
            public void step(double d) {
                ProjectLocationSelector.this.fWarningExpansionPhase = d;
                ProjectLocationSelector.this.forceRepaint();
            }
        });
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void closeOverwriteWarning() {
        if (this.fWarning != null) {
            this.fApp.getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d) {
                    ProjectLocationSelector.this.fWarningExpansionPhase = 1.0 - d;
                    ProjectLocationSelector.this.forceRepaint();
                    if (ProjectLocationSelector.this.fWarningExpansionPhase == 0.0 && ProjectLocationSelector.this.fWarning != null) {
                        ProjectLocationSelector.this.fComponent.remove((Component)ProjectLocationSelector.this.fWarning);
                        ProjectLocationSelector.this.fWarning = null;
                    }
                }
            });
        }
    }

    private void forceRepaint() {
        Object object = this.fComponent;
        while (true) {
            ((Component)object).invalidate();
            if (((Component)object).getParent() == null) break;
            object = ((Component)object).getParent();
        }
        ((Component)object).revalidate();
        ((Component)object).repaint();
    }

    public void hideMessage() {
        if (this.fMessagePopUp != null) {
            this.fMessagePopUp.close();
            this.fMessagePopUp = null;
        }
    }

    public void showMessage(String string) {
        if (PlatformInfo.isLinux()) {
            MJOptionPane.showMessageDialog((Component)this.getComponent(), (Object)string, (String)CoderResources.getString("wfa.entryPoints.title"), (int)0);
        } else {
            this.fMessagePopUp = new HintPopupFrame(SwingUtilities.windowForComponent(this.getComponent()), this.getComponent(), StringUtils.stripLinks((String)string), BuildErrorSeverity.ERROR.getIcon(), true, false, new ReturnRunnable<Point>(){

                public Point run() {
                    Point point = new Point(ProjectLocationSelector.this.getComponent().getWidth() / 2, ProjectLocationSelector.this.getComponent().getHeight());
                    SwingUtilities.convertPointToScreen(point, ProjectLocationSelector.this.getComponent());
                    return point;
                }
            });
        }
    }
}

