/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.setup;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.project.impl.DocumentCellRenderer;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.EntryPointWatchService;
import com.mathworks.toolbox.coder.model.CoderFileSupport;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.CoderStepModel;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.FunctionNamePrompt;
import com.mathworks.toolbox.coder.wfa.core.ListEntryButton;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.setup.ProjectLocationSelector;
import com.mathworks.toolbox.coder.wfa.setup.ScreenerSummary;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.util.Holder;
import com.mathworks.util.Log;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.ButtonFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.Nullable;

public final class ChooseSourceCodeView
extends AbstractCoderStepView {
    private final MJLabel fPrompt = new MJLabel();
    private final FunctionNamePrompt fFunctionNamePrompt;
    private final ListEntryButton fGroupedBrowseButton;
    private final ListEntryButton fFreeBrowseButton;
    private final ListEntryButton fAddButton;
    private final ListEntryButton fRemoveButton;
    private final MJList fListBox;
    private final DefaultListModel<File> fListModel;
    private final MJScrollPane fListScroller;
    private final BusyAffordance fBusyAffordance;
    private final MJPanel fPromptArea;
    private final MJPanel fFunctionNameWrapper;
    private final MJPanel fWrapper;
    private final MJCheckBox fMultiFunctionCheckBox;
    private final JComponent fEnterButton;
    private final FileSetInstance fEntryPoints;
    private final PropertyChangeListener fEntryPointListener;
    private ScreenerSummary fScreenerSummary;
    private ProjectLocationSelector fProjectLocationSelector;
    private double fExpansionRatio = 0.0;
    private boolean fSuppressTextFieldReaction;
    private boolean fLockedOut;
    private static final int PROMPT_AREA_WIDTH = PlatformInfo.isMacintosh() || PlatformInfo.isLinux() ? 585 : 535;

    public ChooseSourceCodeView(CoderApp coderApp, final StepModel stepModel, final Step step) {
        super(coderApp, stepModel, step);
        this.fPrompt.setFont(CoderApp.getFont().deriveFont(16.0f));
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fBusyAffordance.getComponent().setName("entrypoint.wheel");
        this.fAddButton = new ListEntryButton(ListEntryButton.ButtonType.ADD);
        this.fAddButton.setName("button.entrypoint.add");
        this.fRemoveButton = new ListEntryButton(ListEntryButton.ButtonType.REMOVE);
        this.fRemoveButton.setName("button.entrypoint.remove");
        this.fListModel = new DefaultListModel();
        this.fListBox = new MJList(this.fListModel);
        this.fListBox.setName("entrypoint.list");
        this.fListBox.setCellRenderer((ListCellRenderer)((Object)new Renderer()));
        this.fListScroller = new MJScrollPane((Component)this.fListBox);
        this.fListScroller.setName("entrypoint.list.scroller");
        this.fListScroller.setBorder((Border)new LineBorder(new Color(200, 200, 200)));
        this.fFunctionNamePrompt = new FunctionNamePrompt(new ParameterRunnable<String>(){

            public void run(String string) {
                ChooseSourceCodeView.this.checkAndAdd(string);
            }
        });
        this.fFunctionNamePrompt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!(ChooseSourceCodeView.this.fSuppressTextFieldReaction || ChooseSourceCodeView.this.fMultiFunctionCheckBox.isSelected() || ChooseSourceCodeView.this.getSelectedFiles().equals(ChooseSourceCodeView.this.getApp().getModel().getEntryPointFileSet().getFiles()))) {
                    ChooseSourceCodeView.this.fListModel.removeAllElements();
                }
            }
        });
        this.fFunctionNamePrompt.getComponent().setBorder(new LineBorder(new Color(185, 185, 185)));
        this.fFunctionNamePrompt.setFont(CoderApp.getFont().deriveFont(16.0f));
        this.fFunctionNamePrompt.setName("entrypoint.textfield");
        this.fEnterButton = this.createEnterButton(new Runnable(){

            @Override
            public void run() {
                ChooseSourceCodeView.this.fFunctionNamePrompt.doEnter();
            }
        });
        this.fFunctionNameWrapper = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fFunctionNameWrapper.setBorder((Border)new LineBorder(new Color(200, 200, 200)));
        this.fFunctionNameWrapper.add((Component)this.fFunctionNamePrompt.getComponent());
        this.fFunctionNameWrapper.add((Component)this.fEnterButton, (Object)"East");
        this.fFreeBrowseButton = this.createBrowseButton(true);
        this.fGroupedBrowseButton = this.createBrowseButton(false);
        this.fAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChooseSourceCodeView.this.fFunctionNamePrompt.getText().trim().isEmpty()) {
                    ChooseSourceCodeView.this.doBrowse();
                } else {
                    ChooseSourceCodeView.this.checkAndAdd(ChooseSourceCodeView.this.fFunctionNamePrompt.getText());
                }
            }
        });
        this.fRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChooseSourceCodeView.this.fListBox.getSelectedIndex() == -1) {
                    if (!ChooseSourceCodeView.this.fListModel.isEmpty()) {
                        ChooseSourceCodeView.this.fListModel.removeElement(ChooseSourceCodeView.this.fListModel.getElementAt(ChooseSourceCodeView.this.fListModel.size() - 1));
                    }
                } else {
                    for (Object e : new ArrayList(ChooseSourceCodeView.this.fListBox.getSelectedValuesList())) {
                        ChooseSourceCodeView.this.fListModel.removeElement(e);
                    }
                }
            }
        });
        this.fMultiFunctionCheckBox = new MJCheckBox(CoderResources.getString("wfa.chooseSource.multiple"));
        this.fMultiFunctionCheckBox.setName("wfa.entrypoint.multi.check");
        coderApp.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("multiple-entry-points-supported")) {
                    ChooseSourceCodeView.this.rebuildPromptArea();
                }
            }
        });
        this.fPromptArea = new MJPanel();
        this.fWrapper = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                Dimension dimension = ChooseSourceCodeView.this.fPromptArea.getPreferredSize();
                int n = 20;
                int n2 = this.getHeight() / 2 - dimension.height / 2;
                if (ChooseSourceCodeView.this.fExpansionRatio >= 1.0) {
                    Dimension dimension2 = ChooseSourceCodeView.this.fScreenerSummary.getComponent().getPreferredSize();
                    Dimension dimension3 = ChooseSourceCodeView.this.fProjectLocationSelector.getComponent().getPreferredSize();
                    int n3 = PROMPT_AREA_WIDTH;
                    if (ChooseSourceCodeView.this.getApp().getModel().supportsMultipleEntryPoints()) {
                        n3 += ((ChooseSourceCodeView)ChooseSourceCodeView.this).fMultiFunctionCheckBox.getPreferredSize().width;
                    }
                    ChooseSourceCodeView.this.fPromptArea.setBounds(this.getWidth() / 2 - PROMPT_AREA_WIDTH / 2, (int)((double)n2 - (double)(n2 - n) * ChooseSourceCodeView.this.fExpansionRatio), n3, dimension.height);
                    ChooseSourceCodeView.this.fProjectLocationSelector.getComponent().setBounds(this.getWidth() / 2 - dimension3.width / 2, this.getHeight() - 12 - dimension3.height, dimension3.width, dimension3.height);
                    ChooseSourceCodeView.this.fScreenerSummary.getComponent().setBounds(this.getWidth() / 2 - dimension2.width / 2, ChooseSourceCodeView.this.getTopLineY() + (ChooseSourceCodeView.this.getBottomLineY() - ChooseSourceCodeView.this.getTopLineY()) / 2 - dimension2.height / 2, dimension2.width, dimension2.height);
                } else {
                    ChooseSourceCodeView.this.fPromptArea.setBounds(this.getWidth() / 2 - PROMPT_AREA_WIDTH / 2, (int)((double)n2 - (double)(n2 - n) * ChooseSourceCodeView.this.fExpansionRatio), PROMPT_AREA_WIDTH, dimension.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension dimension = ChooseSourceCodeView.this.fPromptArea.getPreferredSize();
                dimension.width = PROMPT_AREA_WIDTH;
                if (ChooseSourceCodeView.this.fExpansionRatio >= 1.0 && ChooseSourceCodeView.this.getApp().getModel().supportsMultipleEntryPoints()) {
                    dimension.width += ((ChooseSourceCodeView)ChooseSourceCodeView.this).fMultiFunctionCheckBox.getPreferredSize().width;
                }
                return new Dimension(dimension.width, dimension.height);
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (ChooseSourceCodeView.this.fExpansionRatio >= 1.0) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(UIManager.getColor("control"));
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("control"), this.getWidth() / 2, 0.0f, new Color(180, 180, 180), true));
                    graphics2D.fill(new Rectangle2D.Double(10.0, ChooseSourceCodeView.this.getTopLineY(), this.getWidth() - 21, 1.0));
                    graphics2D.fill(new Rectangle2D.Double(10.0, ChooseSourceCodeView.this.getBottomLineY(), this.getWidth() - 21, 1.0));
                    graphics2D.dispose();
                }
            }
        };
        this.fWrapper.setLayout(null);
        this.fWrapper.add((Component)this.fPromptArea);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)this.fWrapper);
        this.rebuildPromptArea();
        this.fMultiFunctionCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ChooseSourceCodeView.this.fMultiFunctionCheckBox.isSelected()) {
                    if (ChooseSourceCodeView.this.textFieldContainsEntryPointName()) {
                        ChooseSourceCodeView.this.fFunctionNamePrompt.setText("");
                    }
                } else {
                    if (!ChooseSourceCodeView.this.fListModel.isEmpty()) {
                        ChooseSourceCodeView.this.fFunctionNamePrompt.setText(new FileLocation((File)ChooseSourceCodeView.this.fListModel.get(0)).getNameBeforeDot());
                    }
                    while (ChooseSourceCodeView.this.fListModel.size() > 1) {
                        ChooseSourceCodeView.this.fListModel.remove(1);
                    }
                }
                ChooseSourceCodeView.this.rebuildPromptArea();
            }
        });
        this.fEntryPoints = this.getApp().getModel().getEntryPointFileSet();
        for (File file : this.fEntryPoints.getFiles()) {
            this.fListModel.addElement(file);
        }
        if (!this.fListModel.isEmpty()) {
            this.expandView(false);
            if (this.fListModel.size() > 1 && this.getApp().getModel().supportsMultipleEntryPoints()) {
                this.fMultiFunctionCheckBox.setSelected(true);
            } else {
                this.fFunctionNamePrompt.setText(new FileLocation(this.fListModel.get(0)).getNameBeforeDot());
            }
        }
        this.fListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.contentsChanged(listDataEvent);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                ChooseSourceCodeView.this.getApp().getModel().setEntryPoints(ChooseSourceCodeView.this.getSelectedFiles());
            }
        });
        this.fEntryPointListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ChooseSourceCodeView.this.fProjectLocationSelector != null) {
                            stepModel.refreshCompletion(step);
                            stepModel.refreshCompletion(CoderStepModel.REVIEW_POTENTIAL_ISSUES_STEP);
                            stepModel.refreshCompletion(CoderStepModel.CONVERT_TO_FIXED_POINT_STEP);
                            ChooseSourceCodeView.this.fMultiFunctionCheckBox.setEnabled(ChooseSourceCodeView.this.fEntryPoints.getFiles().size() <= 1);
                        }
                    }
                });
            }
        };
        this.fEntryPoints.addPropertyChangeListener(this.fEntryPointListener);
        this.installDropSupport(this.getContentPane());
        this.installDropSupport(this.fFunctionNamePrompt.getTextComponent());
        this.installDropSupport((Component)this.fListBox);
        this.getApp().getModel().getEntryPointWatcher().addEntryPointObserver(new EntryPointWatchService.EntryPointObserverAdapter(){

            @Override
            public void entryPointsValidityChanged(boolean bl) {
                ChooseSourceCodeView.this.disableIfValid();
            }
        });
        this.disableIfValid();
    }

    private void disableIfValid() {
        if (this.getApp().getModel().getEntryPoint() == null || !this.getModel().isCompleted(CoderStepModel.CHOOSE_SOURCE_FILES_STEP) || !this.getApp().getModel().getEntryPointWatcher().isAllValid() || this.fLockedOut) {
            return;
        }
        this.fLockedOut = true;
        this.fFunctionNamePrompt.setEditable(false);
        this.fEnterButton.setEnabled(false);
        this.fFreeBrowseButton.setEnabled(false);
        this.fGroupedBrowseButton.setEnabled(false);
        this.fAddButton.setEnabled(false);
        this.fRemoveButton.setEnabled(false);
        this.fEnterButton.setEnabled(false);
        this.fMultiFunctionCheckBox.setEnabled(false);
        if (this.fProjectLocationSelector != null) {
            this.fProjectLocationSelector.setEnabled(false);
        }
    }

    private boolean textFieldContainsEntryPointName() {
        return this.fListModel.size() == 1 && new FileLocation(this.fListModel.get(0)).getNameBeforeDot().equals(this.fFunctionNamePrompt.getText());
    }

    private int getTopLineY() {
        Dimension dimension = this.fPromptArea.getPreferredSize();
        return dimension.height + 40;
    }

    private int getBottomLineY() {
        return this.fProjectLocationSelector.getComponent().getY() - 16;
    }

    @Override
    public boolean shouldStretch() {
        return true;
    }

    @Override
    protected String getHelpKey() {
        return "help_button_select_source_files";
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        this.fFunctionNamePrompt.requestFocus();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fFunctionNamePrompt.dispose();
        this.fEntryPoints.removePropertyChangeListener(this.fEntryPointListener);
    }

    public Set<File> getSelectedFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < this.fListModel.size(); ++i) {
            hashSet.add(this.fListModel.get(i));
        }
        return hashSet;
    }

    private void doBrowse() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPathModel.getInstance().getCurrentFolder().toFile());
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)MatlabProductFileExtensionFilter.getMFileFilter());
        mJFileChooserPerPlatform.setMultiSelectionEnabled(this.getApp().getModel().supportsMultipleEntryPoints());
        mJFileChooserPerPlatform.showOpenDialog((Component)this.fFunctionNamePrompt.getComponent());
        if (mJFileChooserPerPlatform.getState() == 0) {
            if (mJFileChooserPerPlatform.getSelectedFiles() != null && mJFileChooserPerPlatform.getSelectedFiles().length > 1) {
                this.fMultiFunctionCheckBox.setSelected(true);
                for (File file : mJFileChooserPerPlatform.getSelectedFiles()) {
                    this.checkAndAdd(file.getAbsolutePath());
                }
            } else {
                File file = mJFileChooserPerPlatform.getSelectedFile();
                String string = new FileLocation(file).getNameBeforeDot();
                this.checkStarted();
                this.checkAndAddLocation(file.getAbsolutePath(), null, string);
            }
        }
    }

    private void checkAndAdd(String string) {
        this.which(string, new WhichResultHandler(){

            @Override
            public void checkPassed(String string, @Nullable String string2, String string3) {
                ChooseSourceCodeView.this.checkAndAddLocation(string, string2, string3);
            }
        });
    }

    private void which(String string, final WhichResultHandler whichResultHandler) {
        String string2;
        String string3 = string.trim();
        if (string3.isEmpty() && !this.fMultiFunctionCheckBox.isSelected()) {
            this.fListModel.removeAllElements();
        }
        this.checkStarted();
        if (string3.contains(".")) {
            string2 = string3;
            string3 = new FileLocation(string3).getNameBeforeDot();
        } else {
            string2 = null;
        }
        final String string4 = string3;
        new Matlab().feval("which", new Object[]{string3}, 1, new CompletionObserver(){

            public void completed(int n, Object object) {
                whichResultHandler.checkPassed((String)object, string2, string4);
            }
        });
    }

    private boolean performCheck(String string, @Nullable ParameterRunnable<CheckFailureType> parameterRunnable) {
        CheckFailureType checkFailureType = null;
        if (string == null || string.isEmpty() || !new File(string).exists()) {
            checkFailureType = CheckFailureType.FUNCTION_NOT_FOUND;
        } else {
            File file;
            File file2 = new File(string);
            if (!CoderFileSupport.isMatlabSourceFile(file2)) {
                checkFailureType = CheckFailureType.UNSUPPORTED_EXTENSION;
            } else if (!(this.getApp().getModel().supportsMultipleEntryPoints() || this.getApp().getModel().isTemporaryProjectFile() || this.getApp().getModel().hasOverwriteWarning() || (file = this.getApp().getModel().getConfiguration().getFile()).getParent().equals(file2.getParent()))) {
                checkFailureType = CheckFailureType.RESTRICTED_FOLDER;
            }
            if (checkFailureType == null && this.getSelectedFiles().contains(file2)) {
                checkFailureType = CheckFailureType.PRE_EXISTING_FUNCTION;
            }
        }
        if (checkFailureType != null && parameterRunnable != null) {
            parameterRunnable.run((Object)checkFailureType);
        }
        return checkFailureType == null;
    }

    private void checkAndAddLocation(final String string, final @Nullable String string2, final String string3) {
        boolean bl = this.performCheck(string, new ParameterRunnable<CheckFailureType>(){

            public void run(CheckFailureType checkFailureType) {
                String string2 = null;
                if (checkFailureType != null) {
                    switch (checkFailureType) {
                        case FUNCTION_NOT_FOUND: {
                            string2 = MessageFormat.format(checkFailureType.getErrorMessage(), string3);
                            break;
                        }
                        case UNSUPPORTED_EXTENSION: {
                            string2 = MessageFormat.format(checkFailureType.getErrorMessage(), new FileLocation(string).getExtension());
                            break;
                        }
                        case RESTRICTED_FOLDER: {
                            string2 = checkFailureType.getErrorMessage();
                            break;
                        }
                        case PRE_EXISTING_FUNCTION: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ChooseSourceCodeView.this.checkEnded();
                                }
                            });
                        }
                    }
                }
                if (string2 != null) {
                    ChooseSourceCodeView.this.rejectFilenameChange(string2);
                }
            }
        });
        if (!bl) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file = new File(string);
                if (string2 != null && !ChooseSourceCodeView.checkExpectedFileName(string2, file)) {
                    MJOptionPane.showMessageDialog((Component)ChooseSourceCodeView.this.getContentPane(), (Object)MessageFormat.format(CoderResources.getString("wfa.entrypoint.shadow"), file.getAbsolutePath()), (String)CoderResources.getString("wfa.entrypoint.error.title"), (int)0);
                } else {
                    if (!ChooseSourceCodeView.this.fMultiFunctionCheckBox.isSelected()) {
                        ChooseSourceCodeView.this.fListModel.removeAllElements();
                        ChooseSourceCodeView.this.fSuppressTextFieldReaction = true;
                        ChooseSourceCodeView.this.fFunctionNamePrompt.setText(string3);
                        ChooseSourceCodeView.this.fSuppressTextFieldReaction = false;
                    }
                    ChooseSourceCodeView.this.fListModel.addElement(file);
                    ChooseSourceCodeView.this.expandView(true);
                }
                ChooseSourceCodeView.this.checkEnded();
            }
        });
    }

    private void rejectFilenameChange(final @Nullable String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChooseSourceCodeView.this.fListModel.removeAllElements();
                ChooseSourceCodeView.this.checkEnded();
                if (string != null) {
                    ChooseSourceCodeView.this.fFunctionNamePrompt.showMessage(string);
                }
            }
        });
    }

    private static boolean checkExpectedFileName(String string, File file) {
        return string.equalsIgnoreCase(file.getName()) || string.equalsIgnoreCase(file.getAbsolutePath());
    }

    private void checkStarted() {
        this.fBusyAffordance.start();
        this.fBusyAffordance.getComponent().setVisible(true);
    }

    private void checkEnded() {
        this.fBusyAffordance.stop();
        this.fBusyAffordance.getComponent().setVisible(false);
    }

    private void expandView(boolean bl) {
        if (this.fExpansionRatio <= 0.0) {
            if (bl) {
                this.getApp().getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                    @Override
                    public void step(double d) {
                        ChooseSourceCodeView.this.fExpansionRatio = d;
                        if (ChooseSourceCodeView.this.fExpansionRatio >= 1.0) {
                            ChooseSourceCodeView.this.viewExpanded();
                        }
                        ChooseSourceCodeView.this.fWrapper.revalidate();
                        ChooseSourceCodeView.this.fWrapper.repaint();
                    }
                });
            } else {
                this.viewExpanded();
            }
        }
    }

    private void viewExpanded() {
        this.fExpansionRatio = 1.0;
        this.fScreenerSummary = new ScreenerSummary(this.getApp());
        this.fProjectLocationSelector = new ProjectLocationSelector(this.getApp(), this.getModel());
        this.fWrapper.add((Component)this.fScreenerSummary.getComponent());
        this.fWrapper.add((Component)this.fProjectLocationSelector.getComponent());
        if (this.getApp().getModel().supportsMultipleEntryPoints()) {
            CellConstraints cellConstraints = new CellConstraints();
            this.fPromptArea.add((Component)this.fMultiFunctionCheckBox, (Object)cellConstraints.xy(10, 2));
            this.fPromptArea.revalidate();
            this.fPromptArea.repaint();
        }
        this.fWrapper.revalidate();
        this.fWrapper.repaint();
    }

    private void rebuildPromptArea() {
        this.fMultiFunctionCheckBox.setVisible(this.getApp().getModel().supportsMultipleEntryPoints());
        if (!this.fMultiFunctionCheckBox.isVisible()) {
            this.fMultiFunctionCheckBox.setSelected(false);
        }
        CellConstraints cellConstraints = new CellConstraints();
        this.fPromptArea.removeAll();
        this.fPrompt.setText(CoderResources.getString("wfa.entryPoints.prompt"));
        if (this.fMultiFunctionCheckBox.isSelected()) {
            this.fPromptArea.setLayout((LayoutManager)new FormLayout(PlatformInfo.isMacintosh() ? "0dlu, fill:p, 4dlu, fill:d:grow, 4dlu, p, 0dlu, 0dlu, 0dlu, 0dlu, 3dlu, 16px, 3dlu, fill:d, 0dlu" : "0dlu, fill:p, 4dlu, fill:d:grow, 4dlu, 24px, 4dlu, 24px, 3dlu, 24px, 3dlu, 16px, 3dlu, fill:d, 0dlu", "0dlu, fill:p, 4dlu, fill:d:grow, 0dlu"));
            this.fPromptArea.add((Component)this.fPrompt, (Object)cellConstraints.xy(2, 2));
            this.fPromptArea.add((Component)this.fFunctionNameWrapper, (Object)cellConstraints.xy(4, 2));
            if (PlatformInfo.isMacintosh()) {
                JComponent jComponent = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fGroupedBrowseButton, this.fAddButton, this.fRemoveButton});
                this.fPromptArea.add((Component)jComponent, (Object)cellConstraints.xy(6, 2));
            } else {
                this.fPromptArea.add((Component)((Object)this.fGroupedBrowseButton), (Object)cellConstraints.xy(6, 2));
                this.fPromptArea.add((Component)((Object)this.fAddButton), (Object)cellConstraints.xy(8, 2));
                this.fPromptArea.add((Component)((Object)this.fRemoveButton), (Object)cellConstraints.xy(10, 2));
            }
            this.fPromptArea.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(12, 2));
            this.fPromptArea.add((Component)this.fMultiFunctionCheckBox, (Object)cellConstraints.xy(14, 2));
            this.fPromptArea.add((Component)this.fListScroller, (Object)cellConstraints.xyw(4, 4, 7));
            this.fFunctionNamePrompt.setPrompt(CoderResources.getString("wfa.entrypoint.promptMultiple"));
        } else {
            this.fPromptArea.setLayout((LayoutManager)new FormLayout("0dlu, fill:p, 4dlu, fill:d:grow, 2dlu," + (PlatformInfo.isMacintosh() ? "30px" : "24px") + ", 4dlu, 16px, 4dlu, fill:d, 0dlu", PlatformInfo.isMacintosh() ? "3dlu, fill:p, 3dlu" : "0dlu, fill:p, 0dlu"));
            this.fPromptArea.add((Component)this.fPrompt, (Object)cellConstraints.xy(2, 2));
            this.fPromptArea.add((Component)this.fFunctionNameWrapper, (Object)cellConstraints.xy(4, 2));
            this.fPromptArea.add((Component)((Object)this.fFreeBrowseButton), (Object)(PlatformInfo.isMacintosh() ? cellConstraints.xywh(6, 1, 1, 3) : cellConstraints.xy(6, 2)));
            this.fPromptArea.add((Component)this.fBusyAffordance.getComponent(), (Object)cellConstraints.xy(8, 2));
            this.fFunctionNamePrompt.setPrompt(CoderResources.getString("wfa.entrypoint.prompt"));
            if (this.fExpansionRatio >= 1.0) {
                this.fPromptArea.add((Component)this.fMultiFunctionCheckBox, (Object)cellConstraints.xy(10, 2));
            }
        }
        this.fPromptArea.revalidate();
        this.fPromptArea.repaint();
        this.fWrapper.revalidate();
        this.fWrapper.repaint();
    }

    private ListEntryButton createBrowseButton(boolean bl) {
        ListEntryButton listEntryButton = new ListEntryButton(ListEntryButton.ButtonType.BROWSE);
        listEntryButton.setName("button.entrypoint.browse");
        listEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseSourceCodeView.this.doBrowse();
            }
        });
        if (bl) {
            listEntryButton.setGrouped(false);
        }
        return listEntryButton;
    }

    private void installDropSupport(Component component) {
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                this.dragOver(dropTargetDragEvent);
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                if (MJDataFlavor.isDecodableFileFlavor((DropTargetDragEvent)dropTargetDragEvent)) {
                    Transferable transferable = dropTargetDragEvent.getTransferable();
                    boolean bl = false;
                    if (!PlatformInfo.isMacintosh() && transferable != null) {
                        try {
                            File[] fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
                            if (fileArray != null && fileArray.length > 0 && !this.validateDrop(fileArray).isEmpty()) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        dropTargetDragEvent.acceptDrag(1);
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable != null) {
                    try {
                        File[] fileArray = MJDataFlavor.decodeJavaFileListFlavor((Transferable)transferable);
                        Set<File> set = this.validateDrop(fileArray);
                        if ((set.size() > 1 || ChooseSourceCodeView.this.fMultiFunctionCheckBox.isSelected()) && ChooseSourceCodeView.this.getApp().getModel().supportsMultipleEntryPoints()) {
                            ChooseSourceCodeView.this.fMultiFunctionCheckBox.setSelected(true);
                            for (File file : set) {
                                ChooseSourceCodeView.this.checkAndAdd(file.getAbsolutePath());
                            }
                        } else if (!set.isEmpty()) {
                            File file = set.iterator().next();
                            String string = new FileLocation(file).getNameBeforeDot();
                            ChooseSourceCodeView.this.checkStarted();
                            ChooseSourceCodeView.this.checkAndAddLocation(file.getAbsolutePath(), null, string);
                        }
                    }
                    catch (Exception exception) {
                        Log.logException((Exception)exception);
                    }
                }
            }

            private Set<File> validateDrop(File[] fileArray) {
                HashSet<File> hashSet = new HashSet<File>();
                for (File file : fileArray) {
                    HashSet<File> hashSet2 = new HashSet<File>();
                    hashSet2.add(file);
                    if (ChooseSourceCodeView.this.fEntryPoints.validateAdd(hashSet2) != null) continue;
                    hashSet.add(file);
                }
                return hashSet;
            }
        };
        component.setDropTarget(new DropTarget(component, 1, dropTargetAdapter, true));
    }

    private JComponent createEnterButton(final Runnable runnable) {
        Font font = this.fPrompt.getFont();
        if (PlatformInfo.isWindows()) {
            font = new Font("Lucida Sans Unicode", 0, font.getSize());
        } else if (PlatformInfo.isMacintosh()) {
            font = new Font("Arial Unicode MS", 0, font.getSize());
        }
        String string = PlatformInfo.isMacintosh() ? "\u21a9" : "\u21b5";
        final JButton jButton = new JButton(string);
        jButton.setUI(new BasicButtonUI());
        jButton.setFont(font);
        jButton.setBorder(null);
        jButton.setFocusPainted(false);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setForeground(new Color(150, 150, 150));
        jButton.setBackground(UIManager.getColor("TextField.background"));
        jButton.setBorder(new EmptyBorder(0, 0, 0, 2));
        jButton.setVisible(false);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ChooseSourceCodeView.swapColors(jButton);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ChooseSourceCodeView.swapColors(jButton);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
        final Runnable runnable2 = this.animateEnterButton(jButton);
        final WhichResultHandler whichResultHandler = new WhichResultHandler(){

            @Override
            public void checkPassed(final String string, @Nullable String string2, String string3) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = ChooseSourceCodeView.this.performCheck(string, (ParameterRunnable<CheckFailureType>)null);
                        jButton.setVisible(bl);
                        if (bl) {
                            runnable2.run();
                        }
                        ChooseSourceCodeView.this.checkEnded();
                    }
                });
            }
        };
        final Holder holder = new Holder();
        this.fFunctionNamePrompt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (holder.get() == null || !((String)holder.get()).endsWith(ChooseSourceCodeView.this.fFunctionNamePrompt.getText())) {
                    ChooseSourceCodeView.this.which(ChooseSourceCodeView.this.fFunctionNamePrompt.getText(), whichResultHandler);
                }
                holder.set((Object)ChooseSourceCodeView.this.fFunctionNamePrompt.getText());
            }
        });
        return jButton;
    }

    private static void swapColors(Component component) {
        Color color = component.getBackground();
        Color color2 = component.getForeground();
        component.setBackground(color2);
        component.setForeground(color);
    }

    private Runnable animateEnterButton(final Component component) {
        final Color color = component.getForeground();
        final Color color2 = component.getBackground();
        final Color color3 = new Color(0, 0, 0, 0);
        component.setForeground(color3);
        final Holder holder = new Holder((Object)Boolean.FALSE);
        final Animation animation = new Animation(){

            @Override
            public void step(double d) {
                component.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(d * 255.0)));
                component.setBackground(ChooseSourceCodeView.createIntermediateColor(color, color2, d));
                if (d >= 1.0) {
                    holder.set((Object)false);
                }
            }
        };
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                component.setForeground(color3);
            }
        });
        return new Runnable(){

            @Override
            public void run() {
                MJUtilities.assertEventDispatchThread();
                if (!((Boolean)holder.get()).booleanValue()) {
                    holder.set((Object)Boolean.TRUE);
                    ChooseSourceCodeView.this.getApp().getAnimator().animate(AnimationTrack.ACCELERATING, animation);
                }
            }
        };
    }

    private static Color createIntermediateColor(Color color, Color color2, double d) {
        float[] fArray = color.getRGBComponents(new float[4]);
        float[] fArray2 = color2.getRGBComponents(new float[4]);
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = (fArray2[i] - fArray[i]) * (float)d + fArray[i];
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
    }

    private static interface WhichResultHandler {
        public void checkPassed(String var1, @Nullable String var2, String var3);
    }

    private static enum CheckFailureType {
        FUNCTION_NOT_FOUND("wfa.entryPoint.functionNotFound"),
        UNSUPPORTED_EXTENSION("wfa.entryPoint.unsupportedExtension"),
        RESTRICTED_FOLDER("wfa.entryPoint.folderRestriction"),
        PRE_EXISTING_FUNCTION(null);

        private final String fMessageKey;

        private CheckFailureType(String string2) {
            this.fMessageKey = string2;
        }

        @Nullable
        String getErrorMessage() {
            return this.fMessageKey != null ? CoderResources.getString(this.fMessageKey) : null;
        }
    }

    private static class Renderer
    extends DocumentCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(new FileLocation((File)object).getNameBeforeDot());
            return component;
        }
    }
}

