/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.inputtypes;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.filesetui.FileChangeNotifier;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.DefaultTestHarnessAdapter;
import com.mathworks.toolbox.coder.app.EntryPointWatchService;
import com.mathworks.toolbox.coder.app.TestHarness;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.TestBenchRunMode;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.GlobalVariableList;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeEvent;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTable;
import com.mathworks.toolbox.coder.wfa.AbstractCoderStepView;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.CustomCommandWindow;
import com.mathworks.toolbox.coder.wfa.core.DescriptionLabel;
import com.mathworks.toolbox.coder.wfa.core.ExpandableWrapper;
import com.mathworks.toolbox.coder.wfa.core.HintLabel;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.toolbox.coder.wfa.inputtypes.InputTypesTree;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarContext;
import com.mathworks.toolbox.coder.widgets.CoderScrollPane;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DefineInputTypesView
extends AbstractCoderStepView {
    private final DescriptionLabel fCommandLabel;
    private final HyperlinkTextLabel fManualLabel;
    private final CustomCommandWindow fCommandWindow;
    private final MJPanel fGlobalVariablesPrompt;
    private final HintLabel fAutoDefineHint;
    private final InputTypesTree fTree;
    private final MJScrollPane fTreeScroller;
    private final TestHarness fTestHarness;
    private final FileChangeNotifier fChangeNotifier;
    private final FileSetInstance fEntryPointFileSet = this.getApp().getModel().getEntryPointFileSet();
    private final PropertyChangeListener fFileSetChangeListener;
    private final GlobalVariableList fGlobals;
    private final Component fGlobalsTableLabel;
    private final InputTable fGlobalsTable;
    private final Component fAddGlobalLink;
    private final IDPChangeListener fGlobalsChangeListener;
    private final ExpandableWrapper fGlobalsTableWrapper;
    private boolean fProjectHasInputVariables = false;
    private boolean fShowDefineManuallyLink;
    private boolean fExpanded = false;
    private boolean fGlobalsExpanded = false;

    public DefineInputTypesView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.determineIfProjectHasInputVariables();
        this.fShowDefineManuallyLink = true;
        this.fCommandLabel = new DescriptionLabel("", "wfa.inputTypes.prompt.single", new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
            }
        });
        this.fManualLabel = Utilities.createLink(CoderResources.getString("wfa.inputTypes.prompt.manual"), "wfa.manual.inputs.label", new Runnable(){

            @Override
            public void run() {
                DefineInputTypesView.this.doManualDefinition();
            }
        });
        this.updateLabels();
        this.fCommandWindow = new CustomCommandWindow(coderApp.getModel().getTestSnippets()){

            @Override
            protected void run(String string, Runnable runnable) {
                DefineInputTypesView.this.getApp().getModel().getTestSnippets().add(string);
                DefineInputTypesView.this.fTestHarness.run(string, null, TestBenchRunMode.RUN_FORTYPES, runnable);
            }

            @Override
            public void showError(String string) {
                DefineInputTypesView.this.fAutoDefineHint.setDisplayed(false);
                super.showError(string);
            }
        };
        this.fTestHarness = new TestHarness(coderApp.getModel(), new DefaultTestHarnessAdapter(this.fCommandWindow){

            @Override
            public void updateTypesWidget(File file, XmlReader xmlReader) {
                DefineInputTypesView.this.fTree.refresh(false);
                DefineInputTypesView.this.fTree.update(file, xmlReader);
                DefineInputTypesView.this.setDefineManuallyLinkVisible(false);
                DefineInputTypesView.this.fAutoDefineHint.setText(CoderResources.getString("wfa.inputTypes.autoDefineEnterPrompt"));
                DefineInputTypesView.this.fAutoDefineHint.setDisplayed(false);
                DefineInputTypesView.this.fCommandWindow.closeError();
                DefineInputTypesView.this.getContentPane().revalidate();
                DefineInputTypesView.this.getContentPane().repaint();
                DefineInputTypesView.this.expand(false);
                DefineInputTypesView.this.updateStatus(false);
            }
        });
        this.fGlobals = new GlobalVariableList();
        this.fGlobalsTableLabel = new DescriptionLabel(CoderResources.getString("wfa.inputTypes.globals")).getComponent();
        this.fGlobalsChangeListener = new IDPChangeListener(){

            @Override
            public void stateChanged(IDPChangeEvent<?> iDPChangeEvent) {
                DefineInputTypesView.this.changeEvent();
            }
        };
        this.loadGlobals();
        ReturnRunnable<String> returnRunnable = new ReturnRunnable<String>(){

            public String run() {
                return CoderApp.getHelpMapPath(DefineInputTypesView.this.getApp());
            }
        };
        this.fGlobalsTable = new InputTable(coderApp.getModel().getConfiguration(), this.fGlobals, false, this.fGlobalsChangeListener, new Runnable(){

            @Override
            public void run() {
                DefineInputTypesView.this.changeEvent();
            }
        }, returnRunnable);
        this.fAddGlobalLink = Utilities.createLink(CoderResources.getString("link.addglobal"), "link.addglobal", new Runnable(){

            @Override
            public void run() {
                DefineInputTypesView.this.addGlobal();
            }
        }).getComponent();
        this.fGlobalsTableWrapper = new ExpandableWrapper(this.fGlobalsTable.getComponent());
        this.fGlobalsTableWrapper.getComponent().setBorder(new LineBorder(new Color(180, 180, 180)));
        this.fAutoDefineHint = new HintLabel(this.getApp().getAnimator(), CoderResources.getString("wfa.inputTypes.autoDefineEnterPrompt"));
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        this.fTree = new InputTypesTree(this.getApp().getModel(), returnRunnable);
        this.fTreeScroller = new CoderScrollPane(this.fTree.getComponent()){

            public void doLayout() {
                super.doLayout();
                if (this.getParent() != null) {
                    this.getParent().revalidate();
                }
            }
        };
        this.fTreeScroller.setBorder((Border)new LineBorder(new Color(180, 180, 180)));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.setLayout((LayoutManager)new FormLayout("fill:d, 3dlu:grow, fill:d", "d"));
        mJPanel.add((Component)((Object)this.fAutoDefineHint), (Object)cellConstraints.xy(1, 1));
        this.fGlobalVariablesPrompt = new MJPanel();
        this.fGlobalVariablesPrompt.add((Component)new DescriptionLabel(CoderResources.getString("wfa.inputTypes.globalsPrompt")).getComponent());
        this.fGlobalVariablesPrompt.add(this.getApp().createWidget("param.UseGlobals"));
        this.fGlobalVariablesPrompt.setName("wfa.inputTypes.globals.label");
        this.getContentPane().setLayout((LayoutManager)new FormLayout("0dlu:grow, 500px, 0dlu:grow", "fill:d, 10dlu, fill:d, 3dlu, fill:d, 3dlu, fill:d"));
        this.getContentPane().add((Component)this.fCommandLabel.getComponent(), cellConstraints.xy(2, 1));
        this.getContentPane().add((Component)this.fCommandWindow.getComponent(), cellConstraints.xy(2, 3));
        this.getContentPane().add((Component)mJPanel, cellConstraints.xy(2, 5));
        this.getContentPane().add((Component)this.fManualLabel.getComponent(), cellConstraints.xy(2, 7));
        this.fCommandWindow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DefineInputTypesView.this.fAutoDefineHint.setDisplayed(!DefineInputTypesView.this.fCommandWindow.getText().trim().isEmpty());
            }
        });
        this.fTree.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DefineInputTypesView.this.updateStatus(false);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DefineInputTypesView.this.fCommandWindow.closeError();
            }
        };
        this.getComponent().addMouseListener(mouseAdapter);
        this.fTree.getComponent().addMouseListener(mouseAdapter);
        this.restore();
        if (this.isProjectHasGlobalVariables()) {
            this.setGlobalsVisible(true, true);
        }
        this.getApp().getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("param.UseGlobals")) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DefineInputTypesView.this.setGlobalsVisible(DefineInputTypesView.this.isProjectHasGlobalVariables(), false);
                            DefineInputTypesView.this.updateStatus(false);
                        }
                    });
                } else if (propertyChangeEvent.getPropertyName().equals("globals-supported")) {
                    boolean bl = DefineInputTypesView.this.isProjectSupportsGlobalVariables();
                    if (!bl && DefineInputTypesView.this.isGlobalsExpanded()) {
                        DefineInputTypesView.this.setGlobalsVisible(false, false);
                    } else if (bl && DefineInputTypesView.this.fGlobals.getVariables().isEmpty() && !DefineInputTypesView.this.isGlobalsExpanded()) {
                        DefineInputTypesView.this.setGlobalsVisible(true, false);
                    }
                }
            }
        });
        this.fChangeNotifier = new FileChangeNotifier(this.fEntryPointFileSet, (ParameterRunnable)new ParameterRunnable<File>(){

            public void run(final File file) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (file != null && DefineInputTypesView.this.fEntryPointFileSet.getFiles().contains(file)) {
                            DefineInputTypesView.this.fTree.fileChanged(file);
                        }
                    }
                });
            }
        });
        this.fFileSetChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefineInputTypesView.this.entryPointFilesChangeEvent(propertyChangeEvent);
            }
        };
        this.fEntryPointFileSet.addPropertyChangeListener(this.fFileSetChangeListener);
        this.getApp().getModel().getEntryPointWatcher().addEntryPointObserver(new EntryPointWatchService.EntryPointObserverAdapter(){

            @Override
            public void entryPointsValidityChanged(boolean bl) {
                DefineInputTypesView.this.determineIfProjectHasInputVariables();
                DefineInputTypesView.this.updateStatus(true);
            }
        });
        this.determineIfProjectHasInputVariables();
        this.updateStatus(true);
    }

    private void entryPointFilesChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (FileSetInstance.isCustomDataChange((PropertyChangeEvent)propertyChangeEvent)) {
            File file = new File(propertyChangeEvent.getPropertyName().substring("custom-data".length() + 1));
            this.fTree.update(file, this.fEntryPointFileSet.getCustomData(file));
        } else if (!FileSetInstance.isCustomDataChange((PropertyChangeEvent)propertyChangeEvent)) {
            this.fTree.refresh(true);
        }
        this.determineIfProjectHasInputVariables();
        this.updateStatus(false);
    }

    private void restore() {
        if (this.getApp().getModel().hasAnyInputTypeData()) {
            this.setDefineManuallyLinkVisible(false);
            this.expand(true);
        }
    }

    private void updateStatus(boolean bl) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefineInputTypesView.this.getModel().refreshCompletion(DefineInputTypesView.this.getStep());
                boolean bl = !DefineInputTypesView.this.isProjectHasInputVariables() && !DefineInputTypesView.this.isProjectHasGlobalVariables();
                DefineInputTypesView.this.getModel().setAutoSkip(DefineInputTypesView.this.getStep(), bl);
                if (!DefineInputTypesView.this.isProjectHasInputVariables()) {
                    DefineInputTypesView.this.doManualDefinition();
                }
                DefineInputTypesView.this.fCommandWindow.getComponent().setVisible(DefineInputTypesView.this.isProjectHasInputVariables());
            }
        };
        if (bl) {
            runnable.run();
        } else {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    runnable.run();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        this.updateLabels();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fChangeNotifier.dispose();
        this.fEntryPointFileSet.removePropertyChangeListener(this.fFileSetChangeListener);
    }

    @Override
    protected String getHelpKey() {
        return "help_button_define_input_types";
    }

    public void doManualDefinition() {
        this.fTree.refresh(false);
        this.expand(false);
        this.fTree.getComponent().requestFocus();
        this.fCommandWindow.closeError();
        this.setDefineManuallyLinkVisible(false);
    }

    @Override
    public void activate(ToolbarContext toolbarContext, boolean bl) {
        this.updateLabels();
        if (this.isProjectHasInputVariables()) {
            this.fCommandWindow.getComponent().setVisible(true);
            this.fCommandWindow.activate();
        } else {
            this.fCommandWindow.setText("");
            this.fCommandWindow.getComponent().setVisible(false);
        }
    }

    private void determineIfProjectHasInputVariables() {
        EntryPointWatchService entryPointWatchService = this.getApp().getModel().getEntryPointWatcher();
        this.setProjectHasInputVariables(false);
        for (File file : this.fEntryPointFileSet.getFiles()) {
            if (entryPointWatchService.getEntryPointInputs(file, false).isEmpty()) continue;
            this.setProjectHasInputVariables(true);
            break;
        }
    }

    private void updateLabels() {
        if (this.getApp().getModel().getEntryPoint() != null && this.getApp().getModel().getEntryPoint().exists()) {
            String string;
            String string2;
            if (this.isProjectHasInputVariables()) {
                string2 = "wfa.inputTypes.prompt";
                string = "wfa.inputTypes.prompt.manual";
            } else {
                string2 = "wfa.noInputTypes.prompt";
                string = "wfa.noInputTypes.prompt.manual";
            }
            this.fCommandLabel.setText(this.createEntryPointBasedPrompt(string2));
            String string3 = "";
            if (this.isProjectSupportsGlobalVariables()) {
                string3 = CoderResources.getString(string + ".global");
            }
            this.fManualLabel.setText(MessageFormat.format(CoderResources.getString(string), string3));
            this.fManualLabel.getComponent().setVisible(this.fShowDefineManuallyLink);
        } else {
            this.fCommandLabel.setText(this.createEntryPointBasedPrompt("wfa.inputTypes.missingFile"));
            this.fManualLabel.setText("");
            this.fManualLabel.getComponent().setVisible(false);
        }
    }

    private String createEntryPointBasedPrompt(String string) {
        Set set = this.fEntryPointFileSet.getFiles();
        if (set.size() == 1) {
            String string2 = new FileLocation((File)set.iterator().next()).getNameBeforeDot();
            return MessageFormat.format(CoderResources.getString(string + ".single"), string2);
        }
        return CoderResources.getString(string + ".multi");
    }

    private void expand(boolean bl) {
        if (this.fExpanded) {
            return;
        }
        this.fExpanded = true;
        this.fTree.setExpansionRatio(0.05);
        this.rebuild(this.isGlobalsExpanded());
        if (bl) {
            this.fTree.setExpansionRatio(1.0);
            this.fTree.getComponent().revalidate();
            this.fTree.getComponent().repaint();
            this.fTree.getComponent().requestFocus();
        }
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
        if (!bl) {
            this.getApp().getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                @Override
                public void step(double d) {
                    if (d > 0.05) {
                        DefineInputTypesView.this.fTree.setExpansionRatio(d);
                        DefineInputTypesView.this.fTree.getComponent().revalidate();
                        DefineInputTypesView.this.fTree.getComponent().repaint();
                        DefineInputTypesView.this.getContentPane().revalidate();
                        DefineInputTypesView.this.getContentPane().repaint();
                        if (d >= 1.0) {
                            DefineInputTypesView.this.fTree.getComponent().requestFocus();
                        }
                    }
                }
            });
        }
    }

    private void rebuild(boolean bl) {
        this.setGlobalsExpanded(bl);
        this.getContentPane().setLayout((LayoutManager)new FormLayout("0dlu:grow, 500px, 0dlu:grow", "fill:d, 10dlu, fill:d, 8dlu, fill:d, 12dlu, fill:d, 3dlu, fill:d" + (bl ? ", 3dlu, fill:d, 4dlu, fill:d, 4dlu, fill:d" : "")));
        CellConstraints cellConstraints = new CellConstraints();
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.fCommandLabel.getComponent(), cellConstraints.xy(2, 1));
        this.getContentPane().add((Component)this.fCommandWindow.getComponent(), cellConstraints.xy(2, 3));
        this.getContentPane().add((Component)this.fManualLabel.getComponent(), cellConstraints.xy(2, 5));
        this.getContentPane().add((Component)this.fTreeScroller, cellConstraints.xy(2, 7));
        if (this.isProjectSupportsGlobalVariables()) {
            this.getContentPane().add((Component)this.fGlobalVariablesPrompt, cellConstraints.xy(2, 9));
            if (bl) {
                this.getContentPane().add(this.fGlobalsTableLabel, cellConstraints.xy(2, 11));
                this.getContentPane().add((Component)this.fGlobalsTableWrapper.getComponent(), cellConstraints.xy(2, 13));
                this.getContentPane().add(this.fAddGlobalLink, cellConstraints.xy(2, 15));
            }
        }
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    private void setGlobalsVisible(boolean bl, boolean bl2) {
        if (bl) {
            this.setDefineManuallyLinkVisible(false);
            if (this.fGlobals.getVariables().isEmpty()) {
                this.addGlobal();
            }
            this.fGlobalsTableWrapper.setExpansionRatio(bl2 ? 1.0 : 0.0);
            this.rebuild(true);
            if (!bl2) {
                this.getApp().getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                    @Override
                    public void step(double d) {
                        if (d > 0.05) {
                            DefineInputTypesView.this.fGlobalsTableWrapper.setExpansionRatio(d);
                            DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().revalidate();
                            DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().repaint();
                        }
                        DefineInputTypesView.this.getContentPane().revalidate();
                        DefineInputTypesView.this.getContentPane().repaint();
                    }
                });
            }
        } else if (this.fGlobalsTableWrapper.getComponent().getParent() != null) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DefineInputTypesView.this.fGlobals.setVariables(new ArrayList<InputDataProperty>(0));
                    DefineInputTypesView.this.fGlobalsTable.reload();
                    DefineInputTypesView.this.rebuild(false);
                }
            };
            if (bl2) {
                runnable.run();
            } else {
                this.getApp().getAnimator().animate(AnimationTrack.ACCELERATING, new Animation(){

                    @Override
                    public void step(double d) {
                        double d2 = 1.0 - d;
                        if (d2 > 0.05) {
                            DefineInputTypesView.this.fGlobalsTableWrapper.setExpansionRatio(d2);
                            DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().revalidate();
                            DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().repaint();
                        }
                        if (d2 == 0.0) {
                            runnable.run();
                        }
                        DefineInputTypesView.this.getContentPane().revalidate();
                        DefineInputTypesView.this.getContentPane().repaint();
                    }
                });
            }
        }
    }

    private void setDefineManuallyLinkVisible(boolean bl) {
        this.fShowDefineManuallyLink = bl;
        this.updateLabels();
    }

    private void loadGlobals() {
        try {
            XmlReader xmlReader = this.getApp().getModel().getConfiguration().getParamReader("param.globals");
            this.fGlobals.setVariables(InputDataProperty.parse(xmlReader, this.fGlobalsChangeListener, null));
            if (!this.fGlobals.getVariables().isEmpty()) {
                this.getApp().getModel().setUseGlobalVariables(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeEvent() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().revalidate();
                DefineInputTypesView.this.fGlobalsTableWrapper.getComponent().repaint();
                DefineInputTypesView.this.getContentPane().revalidate();
                DefineInputTypesView.this.getContentPane().repaint();
                DefineInputTypesView.this.saveGlobals();
                DefineInputTypesView.this.updateStatus(false);
            }
        });
    }

    private void saveGlobals() {
        XmlWriter xmlWriter = XmlApi.getInstance().create("Globals");
        for (InputDataProperty inputDataProperty : this.fGlobals.getVariables()) {
            inputDataProperty.getData(xmlWriter);
        }
        try {
            this.getApp().getModel().getConfiguration().setParamAsXml("param.globals", XmlApi.getInstance().read(xmlWriter.getXML()));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(exception.getCause());
        }
    }

    private void addGlobal() {
        this.fGlobalsTable.addRootLevelItem();
        this.fGlobalsTableWrapper.getComponent().revalidate();
        this.fGlobalsTableWrapper.getComponent().repaint();
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    private boolean isGlobalsExpanded() {
        return this.fGlobalsExpanded;
    }

    private void setGlobalsExpanded(boolean bl) {
        this.fGlobalsExpanded = bl;
    }

    private boolean isProjectSupportsGlobalVariables() {
        return this.getApp().getModel().supportsGlobalVariables();
    }

    private boolean isProjectHasGlobalVariables() {
        return this.getApp().getModel().isUsingGlobalVariables();
    }

    private boolean isProjectHasInputVariables() {
        return this.fProjectHasInputVariables;
    }

    private void setProjectHasInputVariables(boolean bl) {
        this.fProjectHasInputVariables = bl;
    }
}

