/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputAdapter;

public final class SlidingPanel
extends MJPanel {
    private final ItemListener fItemListener;
    private final ComponentListener fComponentListener;
    private final int fPadding = 4;
    private final Animator fAnimator;
    private Component fActive;
    private Animation fAnimation;
    private Rectangle fRectangle;

    SlidingPanel() {
        super(null);
        this.setOpaque(false);
        this.fAnimator = new Animator();
        this.fItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    for (Component component : SlidingPanel.this.getComponents()) {
                        if (component != itemEvent.getSource()) continue;
                        SlidingPanel.this.switchActiveComponent((Component)itemEvent.getSource());
                        break;
                    }
                }
            }
        };
        this.fComponentListener = new ComponentAdapter(){

            private void remakeRectangle(ComponentEvent componentEvent) {
                if (SlidingPanel.this.fActive != null && componentEvent.getComponent() == SlidingPanel.this.fActive) {
                    SlidingPanel.this.fRectangle = SlidingPanel.this.fActive.getBounds();
                    SlidingPanel.this.fRectangle.grow(1, 1);
                    SlidingPanel.this.repaint();
                }
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.remakeRectangle(componentEvent);
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.remakeRectangle(componentEvent);
            }
        };
    }

    private void switchActiveComponent(Component component) {
        if (component == this.fActive) {
            return;
        }
        this.fActive = component;
        if (this.fRectangle == null) {
            this.fRectangle = component.getBounds();
            this.fRectangle.grow(1, 1);
            this.repaint();
            return;
        }
        final Rectangle rectangle = this.fRectangle;
        final Rectangle rectangle2 = component.getBounds();
        rectangle2.grow(1, 1);
        this.fAnimation = new Animation(){

            @Override
            public void step(double d) {
                if (this != SlidingPanel.this.fAnimation) {
                    return;
                }
                SlidingPanel.this.fRectangle = SlidingPanel.this.tweenRectangles(rectangle, rectangle2, d);
                SlidingPanel.this.repaint();
            }
        };
        this.fAnimator.animate(AnimationTrack.HILL, this.fAnimation);
    }

    private Rectangle tweenRectangles(Rectangle rectangle, Rectangle rectangle2, double d) {
        double d2 = (double)(rectangle2.width - rectangle.width) * d + (double)rectangle.width;
        double d3 = (double)(rectangle2.height - rectangle.height) * d + (double)rectangle.height;
        double d4 = (rectangle2.getCenterX() - rectangle.getCenterX()) * d + rectangle.getCenterX() - d2 / 2.0;
        double d5 = (rectangle2.getCenterY() - rectangle.getCenterY()) * d + rectangle.getCenterY() - d3 / 2.0;
        return new Rectangle2D.Double(d4, d5, d2, d3).getBounds();
    }

    protected void paintChildren(Graphics graphics) {
        if (this.fRectangle != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, this.getHeight(), 0.0f, 0.0f, new float[]{0.0f, 0.12f, 1.0f}, new Color[]{new Color(239, 243, 248, 10), new Color(239, 243, 248, 95), new Color(239, 243, 248, 110)});
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(this.fRectangle);
            Rectangle rectangle = new Rectangle(this.fRectangle.x + 1, this.fRectangle.y + 1, this.fRectangle.width - 1, this.fRectangle.height - 1);
            new Color(239, 243, 248, 100);
            graphics2D.draw(rectangle);
            graphics2D.dispose();
        }
        super.paintChildren(graphics);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.addItemListener(this.fItemListener);
            abstractButton.addComponentListener(this.fComponentListener);
            if (abstractButton.isSelected()) {
                this.switchActiveComponent(abstractButton);
            }
        }
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).removeItemListener(this.fItemListener);
            ((AbstractButton)component).removeComponentListener(this.fComponentListener);
        }
        super.remove(n);
    }

    public void doLayout() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        for (Component component : componentArray) {
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n, (this.getHeight() - dimension.height) / 2, dimension.width, dimension.height);
                n += 4 + dimension.width;
                continue;
            }
            component.setBounds(0, 0, 0, 0);
        }
    }

    public Dimension getPreferredSize() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = 0;
        for (Component component : componentArray) {
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.height);
            n2 += dimension.width;
        }
        return new Dimension(n2 + (componentArray.length - 1) * 4, n);
    }

    public static class MonochromeToggleButton
    extends MJToggleButton {
        private static final Color UNSELECTED_COLOR = new Color(150, 150, 150);
        private final int fCornerRadius;
        private final int fPadding;
        private Icon fUnselectedIcon;
        private boolean fHovered;

        MonochromeToggleButton(ActionListener actionListener) {
            this.fCornerRadius = 2;
            this.fPadding = 1;
            this.setOpaque(false);
            this.addActionListener(actionListener);
            this.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    MonochromeToggleButton.this.fHovered = true;
                    MonochromeToggleButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    MonochromeToggleButton.this.fHovered = false;
                    MonochromeToggleButton.this.repaint();
                }
            });
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.repaint();
        }

        public void setIcon(Icon icon) {
            if (icon != null) {
                this.setPreferredSize(new Dimension(icon.getIconWidth() + 2 * this.fPadding, icon.getIconHeight() + 2 * this.fPadding));
                BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                icon.paintIcon((Component)((Object)this), graphics2D, 0, 0);
                graphics2D.dispose();
                for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                    for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                        int n = bufferedImage.getRGB(i, j) >>> 24;
                        if (n <= 0) continue;
                        int n2 = UNSELECTED_COLOR.getRGB() | n << 24;
                        bufferedImage.setRGB(i, j, n2);
                    }
                }
                String string = icon instanceof ImageIcon ? ((ImageIcon)icon).getDescription() : null;
                this.fUnselectedIcon = new ImageIcon(bufferedImage, string);
            }
            super.setIcon(icon);
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getIcon() != null) {
                if (!this.isEnabled()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.36f));
                }
                Icon icon = this.isSelected() ? this.getIcon() : this.fUnselectedIcon;
                icon.paintIcon((Component)((Object)this), graphics2D, this.fPadding, this.fPadding);
            }
            graphics2D.dispose();
        }
    }
}

