/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.files.FileSetView;
import com.mathworks.toolbox.coder.wfa.files.MultiFileSetView;
import com.mathworks.toolbox.coder.widgets.CoderScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.border.Border;

public final class MultiViewUtils {
    private static final String RES_FLAT_VIEW_TOOLTIP = "wfa.sidebar.flatView.tooltip";
    private static final String RES_CALL_TREE_TOOLTIP = "wfa.sidebar.callTree.tooltip";

    private MultiViewUtils() {
    }

    public static void configureInputMultiView(MultiFileSetView multiFileSetView, FileSetView fileSetView, FileSetView fileSetView2) {
        multiFileSetView.getComponent().setPreferredSize(new Dimension(250, 200));
        multiFileSetView.setSubViewIcon(fileSetView, CoderResources.getIcon("sidebar.listView16.png"));
        multiFileSetView.setSubViewTooltip(fileSetView, CoderResources.getString(RES_FLAT_VIEW_TOOLTIP));
        multiFileSetView.setSubViewIcon(fileSetView2, CoderResources.getIcon("sidebar.treeView16.png"));
        multiFileSetView.setSubViewTooltip(fileSetView2, CoderResources.getString(RES_CALL_TREE_TOOLTIP));
        multiFileSetView.setDecorateSidebar(true);
    }

    public static MJScrollPane createBorderedScrollPane(JComponent jComponent) {
        CoderScrollPane coderScrollPane = new CoderScrollPane(jComponent);
        coderScrollPane.setBorder(new Border(){

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(new Color(220, 220, 220));
                graphics.drawLine(0, 0, component.getWidth(), 0);
                graphics.drawLine(component.getWidth() - 1, 0, component.getWidth() - 1, component.getHeight());
            }

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(1, 0, 0, 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
        return coderScrollPane;
    }

    static final class FunctionSelectionPolicy
    implements SelectionPolicy<Function> {
        FunctionSelectionPolicy() {
        }

        @Override
        public boolean select(FileSetView fileSetView, Function function) {
            return fileSetView.select(function);
        }
    }

    static final class FileSelectionPolicy
    implements SelectionPolicy<File> {
        FileSelectionPolicy() {
        }

        @Override
        public boolean select(FileSetView fileSetView, File file) {
            return fileSetView.select(file);
        }
    }

    static interface SelectionPolicy<T> {
        public boolean select(FileSetView var1, T var2);
    }
}

