/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.files;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.wfa.files.SidebarDecorationContext;
import com.mathworks.toolbox.coder.wfa.files.SidebarLayout;
import com.mathworks.toolbox.coder.widgets.TransitionPanel;
import com.mathworks.util.Predicate;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public final class FileSetSidebarWidget {
    private static final int Y_PADDING = 4;
    private final TransitionPanel fComponent;
    private final Configuration fConfiguration;
    private final Map<String, Component> fFileSetPanels;
    private final Map<String, Headline> fHeadlines;
    private final Map<String, SidebarDecorationContext> fContextMap;
    private final boolean fEnableExpansion;

    public FileSetSidebarWidget(Configuration configuration, boolean bl) {
        this.fConfiguration = configuration;
        this.fEnableExpansion = bl;
        this.fFileSetPanels = new LinkedHashMap<String, Component>();
        this.fHeadlines = new LinkedHashMap<String, Headline>();
        this.fContextMap = new LinkedHashMap<String, SidebarDecorationContext>();
        this.fComponent = new TransitionPanel(new SidebarLayout(new Predicate<Component>(){

            public boolean accept(Component component) {
                return component instanceof Headline;
            }
        }, 4));
    }

    public FileSetSidebarWidget(Configuration configuration) {
        this(configuration, true);
    }

    public SidebarDecorationContext getSidebarDecorationContext(String string) {
        return this.fContextMap.get(string);
    }

    private SidebarDecorationContext createDecorationTarget(final Headline headline) {
        return new SidebarDecorationContext(){

            @Override
            public void setHeadingWidget(Component component) {
                headline.setHeaderWidget(component);
            }

            @Override
            public void setHeadingSuffix(String string) {
                headline.setHeaderSuffix(string);
            }
        };
    }

    public void addFileSetPanel(String string, String string2, Component component) {
        if (!this.fFileSetPanels.containsKey(string)) {
            this.fFileSetPanels.put(string, component);
            Headline headline = new Headline(string2, component);
            this.fHeadlines.put(string, headline);
            this.fComponent.add((Component)((Object)headline));
            headline.setExpanded(true);
            this.fContextMap.put(string, this.createDecorationTarget(headline));
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public void removeFileSetPanel(String string) {
        if (this.fFileSetPanels.containsKey(string)) {
            this.fFileSetPanels.remove(string);
            Headline headline = this.fHeadlines.remove(string);
            headline.setExpanded(false);
            this.fComponent.remove((Component)((Object)headline));
            this.fContextMap.remove(string);
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    public void setVisibleFileSets(Set<String> set) {
        this.fComponent.removeAll();
        for (Map.Entry<String, Headline> entry : this.fHeadlines.entrySet()) {
            if (!set.contains(entry.getKey())) continue;
            this.fComponent.add((Component)((Object)entry.getValue()));
            this.fComponent.add(this.fFileSetPanels.get(entry.getKey()));
        }
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public List<String> getFileSetKeys() {
        return new ArrayList<String>(this.fFileSetPanels.keySet());
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private void expandOrCollapse(boolean bl, int n, Component component) {
        if (bl && component.getParent() == null) {
            this.fComponent.add(component, n);
            this.fComponent.revalidate();
            this.fComponent.repaint();
        } else if (!bl && component.getParent() != null) {
            this.fComponent.remove(component);
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    private static class TriangleButton
    extends MJToggleButton {
        private final int fInset;
        private boolean fCollapsed;
        private boolean fHovered;

        TriangleButton(boolean bl) {
            this.setBorderPainted(false);
            this.setSelected(bl);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.fInset = 1;
        }

        private void toggleHover(boolean bl) {
            if (this.fHovered == bl) {
                return;
            }
            this.fHovered = bl;
            this.getParent().repaint();
        }

        public void paint(Graphics graphics) {
            if (!this.isVisible()) {
                return;
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(this.fInset, this.fInset, this.getWidth() - this.fInset, this.fInset), true);
            generalPath.append(new Line2D.Double(this.getWidth() - this.fInset, this.fInset, this.getWidth() / 2, this.getHeight() - this.fInset), true);
            generalPath.append(new Line2D.Double(this.getWidth() / 2, this.getHeight() - this.fInset, this.fInset, this.fInset), true);
            if (this.isSelected()) {
                generalPath.transform(AffineTransform.getRotateInstance(4.71238898038469, this.getWidth() / 2, this.getHeight() / 2));
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(generalPath);
            graphics2D.dispose();
        }
    }

    private class Headline
    extends MJPanel {
        private final MJLabel fLabel;
        private final TriangleButton fButton;
        private final Component fInlineContent;
        private final MJPopupMenu fPopupMenu;
        private final MJToolBar fToolbar;
        private final String fText;
        private final int fButtonWidth;
        private Component fExtension;
        private boolean fExpanded;
        private boolean fPreviouslyExpanded;
        private boolean fHovered;

        Headline(String string, Component component) {
            this.fLabel = new MJLabel(string);
            this.fLabel.setFont(FontUtils.getSystemUIFont().deriveFont(12.0f));
            this.fLabel.setForeground(Color.WHITE);
            this.fInlineContent = component;
            this.fPopupMenu = new MJPopupMenu();
            this.fToolbar = new MJToolBar();
            this.fButton = FileSetSidebarWidget.this.fEnableExpansion ? new TriangleButton(false) : null;
            this.fText = string;
            this.fButtonWidth = 14;
            this.setLayout(null);
            this.add((Component)this.fLabel);
            if (this.fInlineContent != null && FileSetSidebarWidget.this.fEnableExpansion) {
                this.add((Component)((Object)this.fButton));
                this.fButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        FileSetSidebarWidget.this.expandOrCollapse(Headline.this.fExpanded = !Headline.this.fExpanded, Arrays.asList(FileSetSidebarWidget.this.fComponent.getComponents()).indexOf((Object)Headline.this) + 1, Headline.this.fInlineContent);
                    }
                });
            }
            if (this.fButton != null) {
                this.fButton.setVisible(this.fInlineContent != null);
            }
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (!bl) {
                this.fPreviouslyExpanded = this.fExpanded;
                this.setExpanded(false);
            } else if (this.fPreviouslyExpanded != this.fExpanded) {
                this.setExpanded(this.fPreviouslyExpanded);
            }
        }

        void setHeaderSuffix(String string) {
            this.fLabel.setText(string != null && !string.isEmpty() ? this.fText + " - " + string : this.fText);
        }

        void setHeaderWidget(Component component) {
            if (this.fExtension != null) {
                this.remove(this.fExtension);
            }
            this.add(component);
            this.fExtension = component;
            this.revalidate();
            this.repaint();
        }

        void setExpanded(boolean bl) {
            this.fExpanded = bl;
            FileSetSidebarWidget.this.expandOrCollapse(this.fExpanded, Arrays.asList(FileSetSidebarWidget.this.fComponent.getComponents()).indexOf((Object)this) + 1, this.fInlineContent);
        }

        public void doLayout() {
            Dimension dimension = this.fLabel.getPreferredSize();
            int n = this.fButtonWidth;
            int n2 = 6;
            if (this.fButton != null) {
                this.fButton.setBounds(n2, this.getHeight() / 2 - 5, n, 11);
            }
            n2 += 8 + n;
            int n3 = dimension.width;
            if (this.fExtension != null) {
                Dimension dimension2 = this.fExtension.getPreferredSize();
                this.fExtension.setBounds(this.getWidth() - dimension2.width - 2, (this.getHeight() - dimension2.height) / 2, dimension2.width, dimension2.height);
                n3 = this.fExtension.getX() - n2 - 3;
            } else {
                n3 = this.getWidth() - n2 - 3;
            }
            this.fLabel.setBounds(n2, (this.getHeight() - dimension.height) / 2, n3, dimension.height);
        }

        public Dimension getPreferredSize() {
            int n = this.fButtonWidth;
            Dimension dimension = this.fLabel.getPreferredSize();
            Dimension dimension2 = this.fExtension != null ? this.fExtension.getPreferredSize() : new Dimension();
            int n2 = 6 + n + 8 + dimension.width + 3 + dimension2.width + 2;
            int n3 = Math.max(dimension.height, Math.max(n, dimension2.height)) + 2;
            return new Dimension(n2, n3);
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint paint = this.createEmphasisPaint();
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.dispose();
        }

        private Paint createEmphasisPaint() {
            Color color = new Color(30, 68, 124);
            Color color2 = new Color(30, 89, 149);
            return new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getHeight(), new float[]{0.0f, 0.37f, 0.46f, 1.0f}, new Color[]{color, color2, color2, color});
        }
    }
}

