/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.wfa.core.Animation;
import com.mathworks.toolbox.coder.wfa.core.AnimationTrack;
import com.mathworks.toolbox.coder.wfa.core.Animator;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class HintLabel
extends MJLabel {
    private final Animator fAnimator;
    private boolean fDisplayed;
    private double fRatio;

    public HintLabel(Animator animator, String string) {
        super(string);
        this.fAnimator = animator;
        if (PlatformInfo.isMacintosh()) {
            this.setFont(CoderApp.getFont());
        } else {
            this.setFont(CoderApp.getFont().deriveFont(14.0f));
        }
        this.fRatio = 0.0;
    }

    public void setDisplayed(final boolean bl) {
        if (bl == this.fDisplayed) {
            return;
        }
        this.fDisplayed = bl;
        this.fAnimator.animate(AnimationTrack.SLOW_LINEAR, new Animation(){

            @Override
            public void step(double d) {
                HintLabel.this.fRatio = bl ? d : 1.0 - d;
                HintLabel.this.revalidate();
                HintLabel.this.repaint();
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.fRatio));
        super.paintComponent((Graphics)graphics2D);
        graphics2D.dispose();
    }
}

