/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarButton;
import com.mathworks.toolbox.coder.wfa.toolbar.ToolbarUtils;
import com.mathworks.toolbox.coder.wfa.toolbar.WorkflowToolbar;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public abstract class DropDownButton
extends MJToggleButton
implements ToolbarButton {
    public static final int DROP_DOWN_WIDTH = 18;
    private static final int ARROW_WIDTH = 9;
    private static final int ARROW_HEIGHT = 6;
    private Runnable fShortcutAction;
    private ReturnRunnable<Boolean> fReady;

    protected DropDownButton() {
        this.putClientProperty("mwjavaguitest.instance", new ComponentBuilder(){

            public JComponent getComponent() {
                return DropDownButton.this;
            }

            public Point getDropDownArrowCenter() {
                Point point = new Point(DropDownButton.this.getWidth() - 8, DropDownButton.this.getHeight() / 2);
                return point;
            }

            public Point getButtonAreaCenter() {
                Point point = new Point((DropDownButton.this.getWidth() - 18 - 1) / 2, DropDownButton.this.getHeight() / 2);
                return point;
            }
        });
    }

    public final void paintComponent(Graphics graphics) {
        ToolbarUtils.paint(this, graphics);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getX() >= this.getWidth() - 18 || this.fReady != null && !((Boolean)this.fReady.run()).booleanValue()) {
            super.processMouseEvent(mouseEvent);
        } else if (mouseEvent.getID() == 500 && this.isEnabled()) {
            this.fShortcutAction.run();
        }
    }

    public void setShortcutAction(Runnable runnable) {
        this.fShortcutAction = runnable;
    }

    public void setReady(ReturnRunnable<Boolean> returnRunnable) {
        this.fReady = returnRunnable;
    }

    @Override
    public final void paintContent(Graphics2D graphics2D) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.getHeight() / 2, this.getHeight() / 2);
        Area area = new Area(double_);
        area.subtract(new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth() - 18, this.getHeight())));
        if (this.isSelected()) {
            graphics2D.setColor(WorkflowToolbar.HOVER_BACKGROUND);
            graphics2D.fill(area);
            graphics2D.setColor(Color.WHITE);
        }
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.draw(double_);
        graphics2D.draw(new Line2D.Double(this.getWidth() - 18 - 1, 0.0, this.getWidth() - 18 - 1, this.getHeight()));
        graphics2D.setStroke(new BasicStroke(0.6f));
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Line2D.Double(this.getWidth() - 9 - 4 - 1, this.getHeight() / 2 - 3, this.getWidth() - 9 + 4 - 1, this.getHeight() / 2 - 3), true);
        generalPath.append(new Line2D.Double(this.getWidth() - 9 + 4 - 1, this.getHeight() / 2 - 3, this.getWidth() - 9 - 1, this.getHeight() / 2 + 3), true);
        generalPath.append(new Line2D.Double(this.getWidth() - 9 - 1, this.getHeight() / 2 + 3, this.getWidth() - 9 - 4 - 1, this.getHeight() / 2 - 3), true);
        graphics2D.fill(generalPath);
        this.paintMainContent(graphics2D);
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = this.getMainPreferredSize();
        dimension.width += 18;
        return dimension;
    }

    protected abstract void paintMainContent(Graphics2D var1);

    protected abstract Dimension getMainPreferredSize();
}

