/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.core;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.MRUList;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class CommandHistoryModel {
    private final MRUList<String> fCommands;
    private final Map<String, File> fAssociatedFiles;
    private final MulticastChangeListener fChangeListeners;

    public CommandHistoryModel(int n) {
        this.fCommands = new MRUList(n);
        this.fChangeListeners = new MulticastChangeListener();
        this.fAssociatedFiles = new HashMap<String, File>();
    }

    public void add(String string) {
        this.add(string, true);
    }

    public void add(File file) {
        String string = new FileLocation(file).getNameBeforeDot();
        if (!new HashSet<File>(this.fAssociatedFiles.values()).contains(file)) {
            this.registerAssociatedFile(string, file);
            this.add(string, false);
        }
    }

    public void add(String string, boolean bl) {
        if (this.fCommands.contains((Object)string)) {
            return;
        }
        this.fCommands.add((Object)string);
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        if (bl) {
            this.determineIfCommandIsFile(string);
        }
    }

    public boolean hasAssociatedFile(String string) {
        return this.fAssociatedFiles.containsKey(string);
    }

    public File getAssociatedFile(String string) {
        return this.fAssociatedFiles.get(string);
    }

    private void determineIfCommandIsFile(final String string) {
        Utilities.which(string, new ParameterRunnable<File>(){

            public void run(File file) {
                if (file != null) {
                    CommandHistoryModel.this.registerAssociatedFile(string, file);
                }
            }
        });
    }

    private void registerAssociatedFile(final String string, final File file) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CommandHistoryModel.isValidTestbenchFile(file) && CommandHistoryModel.this.fCommands.contains((Object)string)) {
                    CommandHistoryModel.this.fAssociatedFiles.put(string, file);
                    CommandHistoryModel.this.fChangeListeners.stateChanged(new ChangeEvent(CommandHistoryModel.this));
                }
            }
        });
    }

    private static boolean isValidTestbenchFile(File file) {
        return file != null && file.exists();
    }

    public boolean isEmpty() {
        return this.fCommands.size() == 0;
    }

    public List<String> getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.fCommands) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public Set<File> getTestFiles() {
        return new HashSet<File>(this.fAssociatedFiles.values());
    }

    public String getLastCommand() {
        return this.fCommands.size() == 0 ? null : (String)this.fCommands.iterator().next();
    }

    public void delete(String string) {
        this.fCommands.remove((Object)string);
        this.fAssociatedFiles.remove(string);
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }
}

