/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.ImportExportPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class SettingsPanel {
    private static final Color TABBED_PANE_BORDER_COLOR = new Color(180, 180, 180);
    private final CoderApp fApp;
    private final MJPanel fComponent;
    private final Configuration fConfiguration;
    private final BufferedImage fTempImage;
    private final Graphics2D fTempGraphics;
    private final TabbedPane fTabbedPane;
    private final PropertyChangeListener fConfigurationListener;
    private final Runnable fCloseRunnable;
    private JComponent fTablePanel;
    private PropertyTable<Param> fAllSettingsTable;

    public SettingsPanel(CoderApp coderApp, Runnable runnable) {
        this.fApp = coderApp;
        this.fCloseRunnable = runnable;
        this.fConfiguration = coderApp.getModel().getConfiguration();
        this.fTempImage = new BufferedImage(1, 1, 2);
        this.fTempGraphics = this.fTempImage.createGraphics();
        this.fTabbedPane = new TabbedPane();
        this.rebuildTabbedPane();
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.fComponent.addMouseListener((MouseListener)new MouseAdapter(){});
        this.fComponent.add((Component)((Object)this.fTabbedPane));
        this.fTabbedPane.selectFirstTab();
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Configuration.isParamSetVisibilityChange((PropertyChangeEvent)propertyChangeEvent) || propertyChangeEvent.getPropertyName() == "generic-artifact") {
                    SettingsPanel.this.rebuildTabbedPane();
                }
            }
        };
        coderApp.getModel().addPropertyChangeListener(this.fConfigurationListener);
    }

    private JComponent createCloseButton() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(14, 0, 14, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        TabButton tabButton = new TabButton(null, CoderResources.getString("wfa.settings.close"), CoderResources.getIcon("wfa.settings.closeIcon.png"));
        tabButton.setFillWhenSelected(false);
        tabButton.setSelectedOutlineColor(TABBED_PANE_BORDER_COLOR);
        tabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.fCloseRunnable.run();
            }
        });
        tabButton.setModel(new DefaultButtonModel(){

            @Override
            public void setSelected(boolean bl) {
            }

            @Override
            public boolean isSelected() {
                return true;
            }
        });
        mJPanel.add((Component)((Object)tabButton), gridBagConstraints);
        return mJPanel;
    }

    private void rebuildTabbedPane() {
        boolean bl = this.fTabbedPane.hasSelectedTab();
        ParamSet paramSet = this.fTabbedPane.getSelectedParamSet();
        this.fTabbedPane.reset();
        for (ParamSet paramSet2 : this.fConfiguration.getTarget().getParamSets()) {
            if (paramSet2.getIcon() == null || !this.fConfiguration.isParamSetVisible(paramSet2.getKey())) continue;
            this.fTabbedPane.add(new TabButton(paramSet2));
        }
        this.fTabbedPane.add(new AllSettingsButton());
        if (this.fApp.getModel().supportsImportAndExport()) {
            this.fTabbedPane.add(new ImportExportButton(), true);
        }
        this.fTabbedPane.revalidate();
        this.fTabbedPane.repaint();
        if (bl) {
            if (paramSet == null || this.fConfiguration.isParamSetVisible(paramSet.getKey())) {
                this.fTabbedPane.select(paramSet);
            } else {
                this.fTabbedPane.selectFirstTab();
            }
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public boolean hasSelectedTab() {
        return this.fTabbedPane.getParent() != null && this.fTabbedPane.hasSelectedTab();
    }

    private void expandOrCollapse(boolean bl, int n, Component component) {
        if (bl && component.getParent() == null) {
            this.fComponent.add(component, n);
            this.fComponent.revalidate();
            this.fComponent.repaint();
        } else if (!bl && component.getParent() != null) {
            this.fComponent.remove(component);
            this.fComponent.revalidate();
            this.fComponent.repaint();
        }
    }

    private List<ParamSet> getAllSettingsParamSets() {
        LinkedList<ParamSet> linkedList = new LinkedList<ParamSet>();
        for (ParamSet paramSet : this.fConfiguration.getTarget().getParamSets()) {
            if (!this.fConfiguration.isParamSetVisible(paramSet.getKey())) continue;
            linkedList.add(paramSet);
        }
        return linkedList;
    }

    private void createAllSettingsTable() {
        NameColumn nameColumn = new NameColumn();
        ValueColumn valueColumn = new ValueColumn(this.fConfiguration);
        this.fAllSettingsTable = SettingsTableUtils.createTable((Project)this.fConfiguration.getProject(), this.getAllSettingsParamSets(), Arrays.asList(nameColumn, valueColumn));
        this.fAllSettingsTable.getComponent().setName("settings.table");
        this.fAllSettingsTable.setPreferToShowAllRows(true);
        this.fTablePanel = SettingsTableUtils.bindWithFilter(this.fAllSettingsTable);
    }

    private class TabbedPane
    extends MJPanel {
        private final MJPanel fButtonBar;
        private final MJPanel fContent;
        private final ButtonGroup fGroup;
        private final GridBagConstraints fButtonBarConstraints = new GridBagConstraints();
        private final MJPanel fPadding;
        private final JComponent fCloseButton;

        TabbedPane() {
            this.fButtonBarConstraints.gridx = 0;
            this.fButtonBarConstraints.gridy = 0;
            this.fButtonBarConstraints.weightx = 1.0;
            this.fButtonBarConstraints.fill = 2;
            this.fButtonBarConstraints.insets = new Insets(6, 6, 6, 6);
            this.fPadding = new MJPanel();
            this.fPadding.setOpaque(false);
            this.fButtonBar = new MJPanel(new GridBagLayout()){

                public void paintComponent(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.dispose();
                }
            };
            this.fButtonBar.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(TABBED_PANE_BORDER_COLOR);
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n4);
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 0, 0, 1);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }
            });
            this.fContent = new MJPanel((LayoutManager)new BorderLayout());
            this.fCloseButton = SettingsPanel.this.createCloseButton();
            this.resetContentPane();
            this.fGroup = new ButtonGroup();
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.fButtonBar, "West");
            this.add((Component)this.fContent, "Center");
        }

        private void resetContentPane() {
            this.fContent.removeAll();
            this.fContent.add((Component)this.fCloseButton, (Object)"South");
        }

        void select(ParamSet paramSet) {
            for (Component component : this.fButtonBar.getComponents()) {
                if (!(component instanceof TabButton) || ((TabButton)((Object)component)).getParamSet() != paramSet) continue;
                ((TabButton)((Object)component)).setSelected(true);
                break;
            }
        }

        ParamSet getSelectedParamSet() {
            for (Component component : this.fButtonBar.getComponents()) {
                if (!(component instanceof TabButton) || !((TabButton)((Object)component)).isSelected()) continue;
                return ((TabButton)((Object)component)).getParamSet();
            }
            return null;
        }

        void reset() {
            this.resetContentPane();
            this.fButtonBar.removeAll();
            this.fButtonBar.revalidate();
            this.fButtonBar.repaint();
            this.fButtonBarConstraints.gridx = 0;
            this.fButtonBarConstraints.gridy = 0;
            this.fButtonBarConstraints.fill = 2;
            this.fButtonBarConstraints.weightx = 1.0;
        }

        boolean hasSelectedTab() {
            return this.fGroup.getSelection() != null;
        }

        void selectFirstTab() {
            this.fGroup.getElements().nextElement().setSelected(true);
        }

        void add(TabButton tabButton) {
            this.add(tabButton, false);
        }

        void add(final TabButton tabButton, boolean bl) {
            this.fGroup.add((AbstractButton)((Object)tabButton));
            if (!bl) {
                this.fButtonBar.remove((Component)this.fPadding);
            }
            if (!bl) {
                this.fButtonBar.add((Component)((Object)tabButton), (Object)this.fButtonBarConstraints);
                ++this.fButtonBarConstraints.gridy;
                this.fButtonBar.add((Component)this.fPadding, (Object)new GridBagConstraints(0, this.fButtonBarConstraints.gridy, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                ++this.fButtonBarConstraints.gridy;
                this.fButtonBar.add((Component)((Object)tabButton), (Object)this.fButtonBarConstraints);
            }
            tabButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (tabButton.isSelected()) {
                        TabbedPane.this.resetContentPane();
                        TabbedPane.this.fContent.add(tabButton.getOrCreatePanel());
                        TabbedPane.this.fContent.revalidate();
                        TabbedPane.this.fContent.repaint();
                    }
                }
            });
            this.fButtonBar.revalidate();
            this.fButtonBar.repaint();
        }
    }

    private class ImportExportButton
    extends TabButton {
        private ImportExportPanel fPanel;

        private ImportExportButton() {
            super(null, CoderResources.getString("wfa.settings.importExport"), CoderResources.getIcon("import_24.png"));
        }

        @Override
        protected Component getNonParamSetPanel() {
            if (this.fPanel == null) {
                this.fPanel = new ImportExportPanel(SettingsPanel.this.fApp, (Component)SettingsPanel.this.fComponent);
            }
            return this.fPanel.getComponent();
        }
    }

    private class AllSettingsButton
    extends TabButton {
        private AllSettingsButton() {
            super(null, CoderResources.getString("wfa.allSettings"), BuiltInResources.getIcon((String)"all_settings.png"));
            SettingsPanel.this.createAllSettingsTable();
        }

        @Override
        protected Component getNonParamSetPanel() {
            return SettingsPanel.this.fTablePanel;
        }
    }

    private class TabButton
    extends MJToggleButton {
        private final ParamSet fParamSet;
        private ParamSetPanel fPanel;
        private MJScrollPane fScroller;
        private Color fSelectedOutlineColor;
        private boolean fFillWhenSelected;

        TabButton(ParamSet paramSet) {
            this(paramSet, paramSet.getName(), paramSet.getIcon());
        }

        TabButton(ParamSet paramSet, String string, Icon icon) {
            super(string, icon);
            this.fParamSet = paramSet;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSelectedOutlineColor(new Color(220, 220, 220));
            this.setFillWhenSelected(true);
        }

        Component getOrCreatePanel() {
            if (this.fPanel == null) {
                if (this.fParamSet == null) {
                    return this.getNonParamSetPanel();
                }
                this.fPanel = new ParamSetPanel(SettingsPanel.this.fConfiguration.getProject(), this.fParamSet, false, false);
                this.fScroller = new MJScrollPane(this.fPanel.getComponent());
                this.fScroller.setBorder(null);
            }
            return this.fScroller;
        }

        ParamSet getParamSet() {
            return this.fParamSet;
        }

        void setFillWhenSelected(boolean bl) {
            this.fFillWhenSelected = bl;
        }

        void setSelectedOutlineColor(Color color) {
            this.fSelectedOutlineColor = color;
        }

        protected Component getNonParamSetPanel() {
            throw new UnsupportedOperationException();
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(UIManager.getColor("control"));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.isSelected() || this.getModel().isRollover()) {
                if (this.fFillWhenSelected || this.getModel().isRollover()) {
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                graphics2D.setColor(this.fSelectedOutlineColor);
                graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(this.getFont());
            this.getIcon().paintIcon((Component)((Object)this), graphics2D, 8, this.getHeight() / 2 - this.getIcon().getIconHeight() / 2);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.drawString(this.getText(), 16 + this.getIcon().getIconWidth(), this.getHeight() / 2 - (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2 + fontMetrics.getAscent());
            graphics2D.dispose();
        }

        public Dimension getPreferredSize() {
            SettingsPanel.this.fTempGraphics.setFont(this.getFont());
            Rectangle2D rectangle2D = SettingsPanel.this.fTempGraphics.getFontMetrics().getStringBounds(this.getText(), SettingsPanel.this.fTempGraphics);
            return new Dimension((int)((double)(28 + this.getIcon().getIconWidth()) + rectangle2D.getWidth()), (int)(8.0 + Math.max((double)this.getIcon().getIconHeight(), rectangle2D.getHeight())));
        }
    }
}

