/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.NumericRule;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.table.PropertyTableCellEditor;
import com.mathworks.project.impl.table.PropertyTableCellEditorFactory;
import com.mathworks.project.impl.table.PropertyTablePainter;
import com.mathworks.project.impl.table.TextFieldUtils;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.toolbox.coder.widgets.FauxColumnEditorFactory;
import com.mathworks.toolbox.coder.widgets.FauxColumnLayout;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public final class HDLParameterCellEditorFactory<T>
extends FauxColumnEditorFactory.MultiPropertyTableCellEditorFactory<T> {
    private final CellEditorValueContext<T> fContext;

    private HDLParameterCellEditorFactory(CellEditorValueContext<T> cellEditorValueContext) {
        this.fContext = cellEditorValueContext;
    }

    public static <T> PropertyTableCellEditorFactory<T> createEditorFactory(CellEditorValueContext<T> cellEditorValueContext) {
        return new FauxColumnEditorFactory<T>(new HDLParameterCellEditorFactory<T>(cellEditorValueContext), new FauxColumnLayout.EvenLayout());
    }

    @Override
    protected List<PropertyTableCellEditor<T>> createMultipleWidgets(PropertyTable<T> propertyTable, int n, int n2, T t) {
        List<HDLExtendedModel.HDLParameter<?>> list = this.fContext.getHDLParameters(t, n2);
        LinkedList<PropertyTableCellEditor<T>> linkedList = new LinkedList<PropertyTableCellEditor<T>>();
        for (HDLExtendedModel.HDLParameter<?> hDLParameter : list) {
            linkedList.add(this.createSingleEditor(hDLParameter, propertyTable));
        }
        return linkedList;
    }

    @Override
    public PropertyTableCellEditor<T> createWidget(PropertyTable<T> propertyTable, int n, int n2, T t) {
        return this.createSingleEditor(this.fContext.getHDLParameters(t, n2).get(n2), propertyTable);
    }

    private PropertyTableCellEditor<T> createSingleEditor(HDLExtendedModel.HDLParameter hDLParameter, PropertyTable<T> propertyTable) {
        PropertyTableCellEditor<?> propertyTableCellEditor = null;
        if (hDLParameter.getValueType().equals(Integer.class)) {
            propertyTableCellEditor = this.createIntegerEditor(propertyTable, hDLParameter);
        } else if (hDLParameter.getValueType().equals(Double.class)) {
            propertyTableCellEditor = this.createDoubleEditor(propertyTable, hDLParameter);
        } else if (hDLParameter.getValueType().equals(Boolean.class)) {
            propertyTableCellEditor = this.createEnumEditor(propertyTable, hDLParameter, Boolean.TRUE, Boolean.FALSE);
        } else if (Enum.class.isAssignableFrom(hDLParameter.getValueType())) {
            propertyTableCellEditor = this.createEnumEditorByClass(propertyTable, hDLParameter, hDLParameter.getValueType());
        }
        if (propertyTableCellEditor != null) {
            return propertyTableCellEditor;
        }
        throw new IllegalArgumentException(String.format("Unsupported HDLParameter valueType: %s", hDLParameter.getValueType()));
    }

    private PropertyTableCellEditor<?> createStringEditor(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter) {
        return new TextFieldCellEditor<T>(hDLParameter, this.fContext.getKeys(), propertyTable, null, null);
    }

    private PropertyTableCellEditor<?> createIntegerEditor(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter) {
        return new TextFieldCellEditor<T>(hDLParameter, this.fContext.getKeys(), propertyTable, new TextCellEditorTranslator(){

            @Override
            public Object parseValue(String string) throws Exception {
                return Integer.parseInt(string);
            }
        }, (ValidationRule)new NumericRule(0, Integer.MAX_VALUE, false, new DecimalFormat()));
    }

    private PropertyTableCellEditor<?> createDoubleEditor(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter) {
        return new TextFieldCellEditor<T>(hDLParameter, this.fContext.getKeys(), propertyTable, new TextCellEditorTranslator(){

            @Override
            public Object parseValue(String string) throws Exception {
                return Double.parseDouble(string);
            }
        }, (ValidationRule)new NumericRule(0, Integer.MAX_VALUE, true, new DecimalFormat()));
    }

    private <V> PropertyTableCellEditor<?> createEnumEditor(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter, V ... VArray) {
        return new EnumeratedValueCellEditor<T>(hDLParameter, this.fContext.getKeys(), propertyTable, Arrays.asList(VArray));
    }

    private PropertyTableCellEditor<Boolean> createBooleanEditor(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter) {
        return new EnumeratedValueCellEditor<Boolean>(hDLParameter, this.fContext.getKeys(), propertyTable, Arrays.asList(Boolean.TRUE, Boolean.FALSE));
    }

    private PropertyTableCellEditor<?> createEnumEditorByClass(PropertyTable<T> propertyTable, HDLExtendedModel.HDLParameter hDLParameter, Class<? extends Enum> clazz) {
        return this.createEnumEditor(propertyTable, hDLParameter, clazz.getEnumConstants());
    }

    public static interface CellEditorValueContext<T> {
        public Collection<?> getKeys();

        public List<HDLExtendedModel.HDLParameter<?>> getHDLParameters(T var1, int var2);
    }

    private class CompositeCellEditor
    implements PropertyTableCellEditor<T> {
        private final Collection<PropertyTableCellEditor<T>> fEditors = new LinkedList();
        private final MJPanel fComponent;

        CompositeCellEditor(final List<HDLExtendedModel.HDLParameter<?>> list, PropertyTable<T> propertyTable) {
            this.fComponent = new MJPanel(){
                private final PropertyTablePainter<T> fPainter = HDLTableUtils.createPropertyTablePainter();

                public void doLayout() {
                    int n = 1;
                    int n2 = (this.getWidth() - n * 2) / list.size() - this.fPainter.getGridLineWidth() * (list.size() - 1);
                    float f = 0.0f;
                    int n3 = this.getHeight() - n * 2;
                    for (Component component : this.getComponents()) {
                        component.setBounds(Math.round(f), n, Math.round(f + (float)n2), n3);
                        f += (float)(n2 + n * 2 + this.fPainter.getGridLineWidth());
                    }
                }
            };
            for (HDLExtendedModel.HDLParameter<?> hDLParameter : list) {
                PropertyTableCellEditor propertyTableCellEditor = HDLParameterCellEditorFactory.this.createSingleEditor(hDLParameter, propertyTable);
                this.fEditors.add(propertyTableCellEditor);
                this.fComponent.add((Component)propertyTableCellEditor.getComponent());
            }
        }

        public void loadData(Object object, String string) {
        }

        public void commitData() {
            for (PropertyTableCellEditor propertyTableCellEditor : this.fEditors) {
                propertyTableCellEditor.commitData();
            }
        }

        public JComponent getComponent() {
            return this.fComponent;
        }

        public void activate() {
        }

        public void dispose() {
        }
    }

    private static abstract class AbstractPropertyCellEditor<T>
    implements PropertyTableCellEditor<T> {
        private final HDLExtendedModel.HDLParameter fParameter;
        private final PropertyTable<T> fTable;
        private final Collection<?> fKeys;

        AbstractPropertyCellEditor(HDLExtendedModel.HDLParameter hDLParameter, Collection<?> collection, PropertyTable<T> propertyTable) {
            this.fParameter = hDLParameter;
            this.fKeys = new LinkedList(collection);
            this.fTable = propertyTable;
        }

        final HDLExtendedModel.HDLParameter getParameter() {
            return this.fParameter;
        }

        final Collection<?> getKeys() {
            return this.fKeys;
        }

        final PropertyTable<T> getTable() {
            return this.fTable;
        }

        public final void loadData(Object object, String string) {
            if (object instanceof HDLExtendedModel.HDLParameter && !this.fKeys.isEmpty()) {
                this.loadData(((HDLExtendedModel.HDLParameter)object).getValue(this.fKeys.iterator().next()));
            }
        }

        public final void commitData() {
            for (Object obj : this.getKeys()) {
                this.commitSingleKey(obj);
            }
        }

        public void activate() {
        }

        public void dispose() {
        }

        abstract void loadData(Object var1);

        abstract void commitSingleKey(Object var1);
    }

    private static class TextFieldCellEditor<T>
    extends AbstractPropertyCellEditor<T> {
        private final JTextField fComponent = new MJTextField();
        private final TextCellEditorTranslator fTranslator;

        TextFieldCellEditor(HDLExtendedModel.HDLParameter hDLParameter, Collection<?> collection, final PropertyTable<T> propertyTable, TextCellEditorTranslator textCellEditorTranslator, ValidationRule validationRule) {
            super(hDLParameter, collection, propertyTable);
            this.fComponent.setFont(propertyTable.getFont());
            TextCellEditorTranslator textCellEditorTranslator2 = this.fTranslator = textCellEditorTranslator != null ? textCellEditorTranslator : new TextCellEditorTranslator(){

                @Override
                public Object parseValue(String string) {
                    return string;
                }
            };
            if (PlatformInfo.isMacintosh()) {
                this.fComponent.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        propertyTable.stopEditing(false);
                    }
                });
            }
            if (validationRule != null) {
                new BasicTextValidator((JTextComponent)this.fComponent, validationRule);
            }
            TextFieldUtils.installCommitAndCancelKeystrokes(propertyTable, (JTextField)this.fComponent);
        }

        @Override
        void commitSingleKey(Object object) {
            try {
                Object object2 = this.fTranslator.parseValue(this.fComponent.getText());
                if (object2 != null) {
                    this.getParameter().performSetValue(object, object2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        void loadData(Object object) {
            this.fComponent.setText(object != null ? object.toString() : "");
        }

        public JComponent getComponent() {
            return this.fComponent;
        }
    }

    private static class EnumeratedValueCellEditor<T>
    extends AbstractPropertyCellEditor<T> {
        private final JComboBox<T> fComboBox;

        EnumeratedValueCellEditor(HDLExtendedModel.HDLParameter hDLParameter, Collection<Object> collection, PropertyTable<T> propertyTable, List<T> list, final List<String> list2) {
            super(hDLParameter, collection, propertyTable);
            this.fComboBox = new MJComboBox(new ArrayList<T>(list));
            this.fComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    this.setFont(EnumeratedValueCellEditor.this.getTable().getFont());
                    this.setText(n >= 0 ? (String)list2.get(n) : "");
                    return this;
                }
            });
            if (collection.size() > 0) {
                this.fComboBox.setSelectedItem(hDLParameter.getValue(collection.iterator().next()));
            }
            this.fComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EnumeratedValueCellEditor.this.getTable().stopEditing(false);
                }
            });
        }

        EnumeratedValueCellEditor(HDLExtendedModel.HDLParameter hDLParameter, Collection<Object> collection, PropertyTable<T> propertyTable, List<T> list) {
            this(hDLParameter, collection, propertyTable, list, EnumeratedValueCellEditor.getDispStrings(hDLParameter, list));
        }

        private static <T> List<String> getDispStrings(HDLExtendedModel.HDLParameter hDLParameter, Collection<T> collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (T t : collection) {
                String string = hDLParameter.getValueDisplayKey(t);
                String string2 = string != null ? CoderResources.getString(string) : t.toString();
                arrayList.add(string2);
            }
            return arrayList;
        }

        @Override
        void loadData(Object object) {
            this.fComboBox.setSelectedItem(object);
        }

        @Override
        void commitSingleKey(Object object) {
            this.getParameter().performSetValue(object, this.fComboBox.getSelectedItem());
        }

        public JComponent getComponent() {
            return this.fComboBox;
        }
    }

    private static interface TextCellEditorTranslator {
        public Object parseValue(String var1) throws Exception;
    }
}

