/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.wfa.build;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.logui.BufferedLogSource;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.app.CoderApp;
import com.mathworks.toolbox.coder.app.OutputPane;
import com.mathworks.toolbox.coder.app.ide.EditorView;
import com.mathworks.toolbox.coder.app.ide.IDEContext;
import com.mathworks.toolbox.coder.app.ide.IDEFileSidebar;
import com.mathworks.toolbox.coder.app.ide.IDELayout;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupController;
import com.mathworks.toolbox.coder.fixedpoint.CodePopupFrame;
import com.mathworks.toolbox.coder.fixedpoint.HDLCoderDataAdapter;
import com.mathworks.toolbox.coder.fixedpoint.HDLExtendedModel;
import com.mathworks.toolbox.coder.mi.ConversionUtils;
import com.mathworks.toolbox.coder.model.Function;
import com.mathworks.toolbox.coder.model.Variable;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.wfa.build.GenerateCodeView;
import com.mathworks.toolbox.coder.wfa.build.HDLCodePopupContentView;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownDelegates;
import com.mathworks.toolbox.coder.wfa.build.HDLDrillDownTable;
import com.mathworks.toolbox.coder.wfa.build.HDLFunctionTable;
import com.mathworks.toolbox.coder.wfa.build.HDLInferenceTableContext;
import com.mathworks.toolbox.coder.wfa.build.HDLTableUtils;
import com.mathworks.toolbox.coder.wfa.build.InferenceTable;
import com.mathworks.toolbox.coder.wfa.core.Step;
import com.mathworks.toolbox.coder.wfa.core.StepModel;
import com.mathworks.util.Converter;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestFilter;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class HDLGenerateCodeView
extends GenerateCodeView {
    private static final String SOURCE_INSPECTION_LOG_KEY = "Source File Analysis";
    private static final String KEY_FUNCTION_TABLE_TAB = "function-table";
    private static final String RES_FUNCTION_TAB_LABEL = "wfa.hdl.functionTabLabel";
    private final HDLExtendedModel fHdlModel = new HDLExtendedModel(this.getApp().getModel());
    private final HDLInferenceTableContext fTableContext;
    private final HDLFunctionTable fFunctionTable;
    private final HDLDrillDownDelegates.InferenceSourceView fVariableSourceView;
    private final HDLDrillDownTable<Variable> fVariableDownTable;
    private final HDLDrillDownTable<Function> fFunctionDownTable;
    private IDEContext fContext;
    private EditorView fEditor;
    private boolean fNeedsFunctionTab = true;

    public HDLGenerateCodeView(CoderApp coderApp, StepModel stepModel, Step step) {
        super(coderApp, stepModel, step);
        this.fHdlModel.addPropertyChangeListener(this.createHDLPropertyChangeListener());
        this.fTableContext = new HDLInferenceTableContext(this.fHdlModel);
        this.fVariableSourceView = new HDLDrillDownDelegates.InferenceSourceView(this.fTableContext);
        this.fVariableDownTable = new HDLDrillDownTable<Variable>(HDLTableUtils.createParameterContext(this.fHdlModel), this.fVariableSourceView, new HDLDrillDownDelegates.DefaultDrillDownView<Variable>(this.getApp(), new Converter<Variable, String>(){

            public String convert(Variable variable) {
                return variable.getName();
            }
        }), true);
        this.fFunctionTable = new HDLFunctionTable(this.fHdlModel, this.getApp());
        this.fFunctionDownTable = null;
        this.getApp().getIDEView().getFileSets().addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HDLGenerateCodeView.this.updateSelectedFile();
            }
        });
    }

    private void updateSelectedFile() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (HDLGenerateCodeView.this.fFunctionTable == null) {
                    return;
                }
                File file = HDLGenerateCodeView.this.getApp().getIDEView().getFileSets().getSelectedFile();
                if (file != null) {
                    HDLGenerateCodeView.this.fFunctionTable.setCurrentFile(file);
                }
            }
        });
    }

    @Override
    protected InferenceTable.InferenceTableContext getInferenceTableContext() {
        return this.fTableContext;
    }

    @Override
    protected JComponent wrapInferenceTable(InferenceTable inferenceTable) {
        this.fVariableSourceView.updateView(inferenceTable);
        return this.fVariableDownTable.getComponent();
    }

    @Override
    protected void doBuildFinished(final boolean bl) {
        DeploymentProcess deploymentProcess = DeploymentEngine.createProcess((Configuration)this.getApp().getModel().getConfiguration(), (Command[])new Command[]{new Command(){

            public void execute(final CommandStatus commandStatus) {
                ConversionUtils.loadAllVariableKinds(HDLGenerateCodeView.this.fHdlModel.getCoreModel(), new Runnable(){

                    @Override
                    public void run() {
                        HDLGenerateCodeView.super.doBuildFinished(bl);
                        commandStatus.finished();
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (HDLGenerateCodeView.this.fNeedsFunctionTab) {
                                    HDLGenerateCodeView.this.fNeedsFunctionTab = false;
                                    HDLGenerateCodeView.this.fContext.addTab(HDLGenerateCodeView.KEY_FUNCTION_TABLE_TAB, CoderResources.getString(HDLGenerateCodeView.RES_FUNCTION_TAB_LABEL), HDLGenerateCodeView.this.fFunctionTable.getComponent());
                                }
                                HDLGenerateCodeView.this.fVariableDownTable.init();
                                HDLGenerateCodeView.this.fFunctionTable.init();
                            }
                        });
                    }
                });
            }

            public void cancel() {
            }

            public String toString() {
                return CoderResources.getString("wfa.inspectingHDLSource.label");
            }
        }});
        this.fContext.runWithLog(SOURCE_INSPECTION_LOG_KEY, CoderResources.getString("wfa.inspectingHDLSource.label"), deploymentProcess, null, "", new Predicate<BufferedLogSource>(){

            public boolean accept(BufferedLogSource bufferedLogSource) {
                return true;
            }
        });
    }

    private PropertyChangeListener createHDLPropertyChangeListener() {
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                HDLGenerateCodeView.this.fHdlModel.serialize(new HDLCoderDataAdapter(HDLGenerateCodeView.this.getApp().getModel().getConfiguration()));
            }
        });
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                requestFilter.request(new Runnable(){

                    @Override
                    public void run() {
                        HDLGenerateCodeView.this.updateInferenceTable();
                    }
                });
            }
        };
    }

    @Override
    protected GenerateCodeView.GenerateCodeIDEContext initIDEContext() {
        this.fContext = new GenerateCodeView.GenerateCodeIDEContext(){

            @Override
            public CodePopupController createCodePopupController(Window window, EditorView editorView) {
                return new CodePopupController(new CodePopupFrame(window, new HDLCodePopupContentView(HDLGenerateCodeView.this.fHdlModel)), editorView, HDLGenerateCodeView.this.fHdlModel.getCoreModel());
            }

            @Override
            public void activate(IDEFileSidebar iDEFileSidebar, IDELayout iDELayout, OutputPane outputPane, EditorView editorView) {
                super.activate(iDEFileSidebar, iDELayout, outputPane, editorView);
                HDLGenerateCodeView.this.fEditor = editorView;
            }
        };
        return (GenerateCodeView.GenerateCodeIDEContext)this.fContext;
    }
}

